/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ec2.compute.strategy;

import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.aws.util.AWSUtils;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.compute.strategy.GetNodeMetadataStrategy;
import org.jclouds.compute.strategy.ResumeNodeStrategy;
import org.jclouds.ec2.EC2Api;
import org.jclouds.ec2.features.InstanceApi;

@Singleton
public class EC2ResumeNodeStrategy
implements ResumeNodeStrategy {
    private final InstanceApi client;
    private final GetNodeMetadataStrategy getNode;

    @Inject
    protected EC2ResumeNodeStrategy(EC2Api client, GetNodeMetadataStrategy getNode) {
        this.client = client.getInstanceApi().get();
        this.getNode = getNode;
    }

    @Override
    public NodeMetadata resumeNode(String id) {
        String[] parts = AWSUtils.parseHandle(id);
        String region = parts[0];
        String instanceId = parts[1];
        this.client.startInstancesInRegion(region, instanceId);
        return this.getNode.getNode(id);
    }
}

