/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ec2.functions;

import com.google.common.base.Charsets;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.io.BaseEncoding;
import javax.inject.Singleton;
import org.jclouds.util.Predicates2;

@Singleton
public class EncodedRSAPublicKeyToBase64
implements Function<Object, String> {
    private static final Predicate<String> ALLOWED_MARKERS = Predicates.or(Predicates2.startsWith("ssh-rsa"), Predicates2.startsWith("-----BEGIN CERTIFICATE-----"), Predicates2.startsWith("---- BEGIN SSH2 PUBLIC KEY ----"));

    @Override
    public String apply(Object from) {
        String fromString = Preconditions.checkNotNull(from, "input").toString();
        Preconditions.checkArgument(ALLOWED_MARKERS.apply(fromString), "must be a ssh public key, conforming to %s ", ALLOWED_MARKERS);
        return BaseEncoding.base64().encode(fromString.getBytes(Charsets.UTF_8));
    }
}

