/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.googlecomputeengine.options;

import com.google.common.collect.ImmutableList;
import java.net.URI;
import java.util.List;
import org.jclouds.googlecomputeengine.domain.Firewall;

public class FirewallOptions {
    private String name;
    private URI network;
    private String description;
    private ImmutableList.Builder<String> sourceRanges = ImmutableList.builder();
    private ImmutableList.Builder<String> sourceTags = ImmutableList.builder();
    private ImmutableList.Builder<String> targetTags = ImmutableList.builder();
    private ImmutableList.Builder<Firewall.Rule> allowed = ImmutableList.builder();

    public List<Firewall.Rule> getAllowed() {
        return this.allowed.build();
    }

    public FirewallOptions addAllowedRule(Firewall.Rule allowedRule) {
        this.allowed.add((Object)allowedRule);
        return this;
    }

    public FirewallOptions allowedRules(List<Firewall.Rule> allowedRules) {
        this.allowed = ImmutableList.builder();
        this.allowed.addAll(allowedRules);
        return this;
    }

    public FirewallOptions name(String name) {
        this.name = name;
        return this;
    }

    public String name() {
        return this.name;
    }

    public FirewallOptions description(String description) {
        this.description = description;
        return this;
    }

    public String description() {
        return this.description;
    }

    public FirewallOptions network(URI network) {
        this.network = network;
        return this;
    }

    public URI network() {
        return this.network;
    }

    public List<String> sourceRanges() {
        return this.sourceRanges.build();
    }

    public FirewallOptions addSourceRange(String sourceRange) {
        this.sourceRanges.add((Object)sourceRange);
        return this;
    }

    public FirewallOptions sourceRanges(Iterable<String> sourceRanges) {
        this.sourceRanges = ImmutableList.builder();
        this.sourceRanges.addAll((Iterable)sourceRanges);
        return this;
    }

    public List<String> sourceTags() {
        return this.sourceTags.build();
    }

    public FirewallOptions addSourceTag(String sourceTag) {
        this.sourceTags.add((Object)sourceTag);
        return this;
    }

    public FirewallOptions sourceTags(Iterable<String> sourceTags) {
        this.sourceTags = ImmutableList.builder();
        this.sourceTags.addAll((Iterable)sourceTags);
        return this;
    }

    public List<String> targetTags() {
        return this.targetTags.build();
    }

    public FirewallOptions addTargetTag(String targetTag) {
        this.targetTags.add((Object)targetTag);
        return this;
    }

    public FirewallOptions targetTags(List<String> targetTags) {
        this.targetTags = ImmutableList.builder();
        this.targetTags.addAll(targetTags);
        return this;
    }
}

