/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.joyent.cloudapi.v6_5.compute.functions;

import com.google.common.base.Function;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import java.util.Map;
import javax.inject.Inject;
import org.jclouds.compute.domain.OperatingSystem;
import org.jclouds.compute.domain.OsFamily;
import org.jclouds.compute.util.ComputeServiceUtils;
import org.jclouds.joyent.cloudapi.v6_5.domain.Dataset;

public class DatasetToOperatingSystem
implements Function<Dataset, OperatingSystem> {
    private final Map<OsFamily, Map<String, String>> osVersionMap;

    @Inject
    public DatasetToOperatingSystem(Map<OsFamily, Map<String, String>> osVersionMap) {
        this.osVersionMap = osVersionMap;
    }

    @Override
    public OperatingSystem apply(Dataset from) {
        OperatingSystem.Builder builder = OperatingSystem.builder();
        builder.name(from.getName());
        builder.description(from.getUrn());
        builder.is64Bit(true);
        String os = from.getOs();
        OsFamily family = OsFamily.UNRECOGNIZED;
        String version = "";
        if (os.compareTo("smartos") == 0) {
            family = OsFamily.fromValue(os);
            version = from.getVersion();
        } else {
            ImmutableList<String> pieces = ImmutableList.copyOf(Splitter.on(':').split(from.getUrn()));
            if (((String)pieces.get(2)).indexOf(45) != -1) {
                ImmutableList<String> osFamVersion = ImmutableList.copyOf(Splitter.on('-').split((CharSequence)pieces.get(2)));
                family = OsFamily.fromValue((String)osFamVersion.get(0));
                if (family != OsFamily.UNRECOGNIZED) {
                    version = (String)osFamVersion.get(1);
                }
            } else {
                family = OsFamily.fromValue((String)pieces.get(2));
            }
        }
        builder.family(family);
        if (family != OsFamily.UNRECOGNIZED) {
            version = ComputeServiceUtils.parseVersionOrReturnEmptyString(family, version, this.osVersionMap);
        }
        if ("".equals(version)) {
            version = from.getVersion();
        }
        builder.version(version);
        return builder.build();
    }
}

