/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.conn.vmm;

import es.bsc.conn.Connector;
import es.bsc.conn.clients.exceptions.ConnClientException;
import es.bsc.conn.clients.vmm.VMMClient;
import es.bsc.conn.clients.vmm.types.VMDescription;
import es.bsc.conn.exceptions.ConnException;
import es.bsc.conn.types.HardwareDescription;
import es.bsc.conn.types.SoftwareDescription;
import es.bsc.conn.types.StarterCommand;
import es.bsc.conn.types.VirtualResource;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class VMMConnector
extends Connector {
    private static final String ACTIVE = "ACTIVE";
    private static final String ERROR = "ERROR";
    private static final long POLLING_INTERVAL = 5L;
    private static final int TIMEOUT = 1800;
    private static final Logger LOGGER = LogManager.getLogger("es.bsc.compss.Connectors.Conn.VMM");
    private VMMClient client;
    private final Map<String, HardwareDescription> vmidToHardwareRequest = new HashMap<String, HardwareDescription>();
    private final Map<String, SoftwareDescription> vmidToSoftwareRequest = new HashMap<String, SoftwareDescription>();
    private int currentVMs = 0;

    public VMMConnector(Map<String, String> props) throws ConnException {
        super(props);
        this.client = new VMMClient(this.server);
    }

    @Override
    public Object create(String requestName, HardwareDescription hd, SoftwareDescription sd, Map<String, String> prop, StarterCommand starterCMD) throws ConnException {
        try {
            String vmName = this.appName + '-' + UUID.randomUUID().toString();
            String preferredHost = "";
            ++this.currentVMs;
            String vmId = this.client.createVM(vmName, hd.getImageName(), hd.getTotalCPUComputingUnits(), (int)(hd.getMemorySize() * 1024.0f), (int)hd.getStorageSize(), this.appName, preferredHost, true);
            this.vmidToHardwareRequest.put(vmId, hd);
            this.vmidToSoftwareRequest.put(vmId, sd);
            VirtualResource vr = new VirtualResource(vmId, hd, sd, prop);
            return vr.getId();
        }
        catch (ConnClientException ce) {
            LOGGER.error("Exception submitting vm creation", (Throwable)ce);
            --this.currentVMs;
            throw new ConnException(ce);
        }
        catch (Exception e) {
            LOGGER.error("Exception submitting vm creation", (Throwable)e);
            throw new ConnException(e);
        }
    }

    @Override
    public Object[] createMultiple(int replicas, String requestName, HardwareDescription hd, SoftwareDescription sd, Map<String, String> prop, StarterCommand starterCMD) throws ConnException {
        Object[] envIds = new Object[replicas];
        for (int i = 0; i < replicas; ++i) {
            envIds[i] = this.create(requestName, hd, sd, prop, starterCMD);
        }
        return envIds;
    }

    @Override
    public VirtualResource waitUntilCreation(Object id) throws ConnException {
        LOGGER.debug("Waiting for creation " + id);
        String vmId = (String)id;
        LOGGER.info("Waiting until VM " + vmId + " is created");
        try {
            VMDescription vmd = this.client.getVMDescription(vmId);
            LOGGER.info("VM State is " + vmd.getState());
            int tries = 0;
            while (vmd.getState() == null || !vmd.getState().equals(ACTIVE)) {
                if (vmd.getState().equals(ERROR)) {
                    LOGGER.error("Error waiting for VM Creation. Middleware has return an error state");
                    throw new ConnException("Error waiting for VM Creation. Middleware has return an error state");
                }
                if ((long)tries * 5L > 1800L) {
                    throw new ConnException("Maximum VM creation time reached.");
                }
                ++tries;
                Thread.sleep(5000L);
                vmd = this.client.getVMDescription(vmId);
            }
            VirtualResource vr = new VirtualResource();
            vr.setId(vmId);
            vr.setIp(vmd.getIpAddress());
            vr.setProperties(null);
            HardwareDescription hd = this.vmidToHardwareRequest.get(vmId);
            if (hd == null) {
                throw new ConnException("Unregistered hardware description for vmId = " + vmId);
            }
            hd.setTotalComputingUnits(vmd.getCpus());
            hd.setMemorySize((float)vmd.getRamMb() / 1024.0f);
            hd.setStorageSize(vmd.getDiskGb());
            hd.setImageName(vmd.getImage());
            vr.setHd(hd);
            SoftwareDescription sd = this.vmidToSoftwareRequest.get(vmId);
            if (sd == null) {
                throw new ConnException("Unregistered software description for vmId = " + vmId);
            }
            sd.setOperatingSystemType("Linux");
            vr.setSd(sd);
            return vr;
        }
        catch (ConnClientException | InterruptedException e) {
            LOGGER.error("Exception waiting for VM Creation");
            throw new ConnException(e);
        }
    }

    @Override
    public void destroy(Object id) {
        String vmId = (String)id;
        LOGGER.debug("Destroying VM " + vmId);
        try {
            this.client.deleteVM(vmId);
            this.vmidToHardwareRequest.remove(vmId);
            this.vmidToSoftwareRequest.remove(vmId);
        }
        catch (ConnClientException cce) {
            LOGGER.error("Exception waiting for VM Destruction", (Throwable)cce);
        }
        LOGGER.debug("VM " + vmId + " destroyed.");
        --this.currentVMs;
    }

    @Override
    public float getPriceSlot(VirtualResource virtualResource) {
        return virtualResource.getHd().getPricePerUnit();
    }

    @Override
    public void close() {
    }

    public int getCurrentVMs() {
        return this.currentVMs;
    }
}

