/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.compute.functions;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.Sets;
import java.util.Set;
import javax.inject.Inject;
import org.jclouds.cloudstack.compute.predicates.AllNodesInGroupTerminated;
import org.jclouds.cloudstack.domain.ZoneAndName;
import org.jclouds.compute.ComputeService;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.compute.predicates.NodePredicates;
import org.jclouds.domain.LocationScope;

public class OrphanedGroupsByZoneId
implements Function<Set<? extends NodeMetadata>, Multimap<String, String>> {
    private final Predicate<ZoneAndName> allNodesInGroupTerminated;

    @Inject
    protected OrphanedGroupsByZoneId(ComputeService computeService) {
        this(new AllNodesInGroupTerminated(Preconditions.checkNotNull(computeService, "computeService")));
    }

    @VisibleForTesting
    OrphanedGroupsByZoneId(Predicate<ZoneAndName> allNodesInGroupTerminated) {
        this.allNodesInGroupTerminated = Preconditions.checkNotNull(allNodesInGroupTerminated, "allNodesInGroupTerminated");
    }

    @Override
    public Multimap<String, String> apply(Set<? extends NodeMetadata> deadNodes) {
        Set<NodeMetadata> nodesWithGroup = Sets.filter(deadNodes, NodePredicates.hasGroup());
        ImmutableSet<ZoneAndName> zoneAndGroupNames = ImmutableSet.copyOf(Iterables.filter(Iterables.transform(nodesWithGroup, new Function<NodeMetadata, ZoneAndName>(){

            @Override
            public ZoneAndName apply(NodeMetadata input) {
                String zoneId = input.getLocation().getScope() == LocationScope.HOST ? input.getLocation().getParent().getId() : input.getLocation().getId();
                return ZoneAndName.fromZoneAndName(zoneId, input.getGroup());
            }
        }), this.allNodesInGroupTerminated));
        ListMultimap<String, String> zoneToZoneAndGroupNames = Multimaps.transformValues(Multimaps.index(zoneAndGroupNames, ZoneAndName.ZONE_FUNCTION), ZoneAndName.NAME_FUNCTION);
        return zoneToZoneAndGroupNames;
    }
}

