/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.functions;

import com.google.common.base.Preconditions;
import com.google.common.cache.CacheLoader;
import com.google.inject.Inject;
import org.jclouds.cloudstack.CloudStackApi;
import org.jclouds.cloudstack.domain.Zone;
import org.jclouds.cloudstack.features.ZoneApi;

public class ZoneIdToZone
extends CacheLoader<String, Zone> {
    private final ZoneApi zoneClient;

    @Inject
    public ZoneIdToZone(CloudStackApi client) {
        Preconditions.checkNotNull(client, "client");
        this.zoneClient = client.getZoneApi();
    }

    @Override
    public Zone load(String zoneId) throws Exception {
        Preconditions.checkNotNull(zoneId, "zoneId");
        return this.zoneClient.getZone(zoneId);
    }
}

