/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.keystone.v2_0.domain;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ForwardingSet;
import com.google.common.collect.ImmutableSet;
import java.beans.ConstructorProperties;
import java.util.Set;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.openstack.keystone.v2_0.domain.Role;

public class User
extends ForwardingSet<Role> {
    private final String id;
    private final String name;
    private final String email;
    private final Boolean enabled;
    private final String tenantId;
    private final Set<Role> roles;

    public static Builder<?> builder() {
        return new ConcreteBuilder();
    }

    public Builder<?> toBuilder() {
        return new ConcreteBuilder().fromUser(this);
    }

    @ConstructorProperties(value={"id", "name", "email", "enabled", "tenantId", "roles"})
    protected User(String id, String name, @Nullable String email, @Nullable Boolean enabled, @Nullable String tenantId, @Nullable Set<Role> roles) {
        this.id = Preconditions.checkNotNull(id, "id");
        this.name = Preconditions.checkNotNull(name, "name");
        this.email = email;
        this.enabled = enabled;
        this.tenantId = tenantId;
        this.roles = roles == null ? ImmutableSet.of() : ImmutableSet.copyOf(roles);
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getEmail() {
        return this.email;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public String getTenantId() {
        return this.tenantId;
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(this.id, this.name, this.email, this.enabled, this.tenantId, this.roles);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        User that = (User)User.class.cast(obj);
        return Objects.equal(this.id, that.id) && Objects.equal(this.name, that.name) && Objects.equal(this.roles, that.roles) && Objects.equal(this.enabled, that.enabled) && Objects.equal(this.tenantId, that.tenantId) && Objects.equal(this.email, that.email);
    }

    protected Objects.ToStringHelper string() {
        return Objects.toStringHelper(this).omitNullValues().add("id", this.id).add("name", this.name).add("email", this.email).add("enabled", this.enabled).add("roles", this.roles).add("tenanId", this.tenantId);
    }

    @Override
    public String toString() {
        return this.string().toString();
    }

    @Override
    protected Set<Role> delegate() {
        return this.roles;
    }

    private static class ConcreteBuilder
    extends Builder<ConcreteBuilder> {
        private ConcreteBuilder() {
        }

        @Override
        protected ConcreteBuilder self() {
            return this;
        }
    }

    public static abstract class Builder<T extends Builder<T>> {
        protected String id;
        protected String name;
        protected String email;
        protected Boolean enabled;
        protected String tenantId;
        protected ImmutableSet.Builder<Role> roles = ImmutableSet.builder();

        protected abstract T self();

        public T id(String id) {
            this.id = id;
            return this.self();
        }

        public T name(String name) {
            this.name = name;
            return this.self();
        }

        public T email(String email) {
            this.email = email;
            return this.self();
        }

        public T enabled(Boolean enabled) {
            this.enabled = enabled;
            return this.self();
        }

        public T tenantId(String tenantId) {
            this.tenantId = tenantId;
            return this.self();
        }

        public T role(Role role) {
            this.roles.add((Object)role);
            return this.self();
        }

        public T roles(Iterable<Role> roles) {
            this.roles.addAll((Iterable)roles);
            return this.self();
        }

        public User build() {
            return new User(this.id, this.name, this.email, this.enabled, this.tenantId, (Set<Role>)((Object)this.roles.build()));
        }

        public T fromUser(User in) {
            return ((Builder)((Builder)((Builder)((Builder)((Builder)this.id(in.getId())).name(in.getName())).email(in.getEmail())).enabled(in.isEnabled())).tenantId(in.getTenantId())).roles(in);
        }
    }
}

