/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ovf.xml;

import java.util.Map;
import javax.inject.Inject;
import javax.inject.Provider;
import org.jclouds.ovf.ProductSection;
import org.jclouds.ovf.Property;
import org.jclouds.ovf.xml.SectionHandler;
import org.jclouds.util.SaxUtils;
import org.xml.sax.Attributes;

public class ProductSectionHandler
extends SectionHandler<ProductSection, ProductSection.Builder> {
    protected Property.Builder configBuilder = Property.builder();

    @Inject
    public ProductSectionHandler(Provider<ProductSection.Builder> builderProvider) {
        super(builderProvider);
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attrs) {
        Map<String, String> attributes = SaxUtils.cleanseAttributes(attrs);
        if (SaxUtils.equalsOrSuffix(qName, "Property")) {
            this.configBuilder.key(attributes.get("key"));
            this.configBuilder.value(attributes.get("value"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void endElement(String uri, String localName, String qName) {
        if (SaxUtils.equalsOrSuffix(qName, "Info")) {
            ((ProductSection.Builder)this.builder).info(SaxUtils.currentOrNull(this.currentText));
        } else if (SaxUtils.equalsOrSuffix(qName, "Label")) {
            this.configBuilder.label(SaxUtils.currentOrNull(this.currentText));
        } else if (SaxUtils.equalsOrSuffix(qName, "Description")) {
            this.configBuilder.description(SaxUtils.currentOrNull(this.currentText));
        } else if (SaxUtils.equalsOrSuffix(qName, "Property")) {
            try {
                ((ProductSection.Builder)this.builder).property(this.configBuilder.build());
            }
            finally {
                this.configBuilder = Property.builder();
            }
        }
        super.endElement(uri, localName, qName);
    }
}

