/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.scriptbuilder.statements.login;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import org.jclouds.scriptbuilder.domain.OsFamily;
import org.jclouds.scriptbuilder.domain.Statement;
import org.jclouds.scriptbuilder.domain.StatementList;
import org.jclouds.scriptbuilder.domain.Statements;

public class ReplaceShadowPasswordEntry
implements Statement {
    private final Function<String, String> cryptFunction;
    private final String login;
    private final String password;

    public ReplaceShadowPasswordEntry(Function<String, String> cryptFunction, String login, String password) {
        this.cryptFunction = Preconditions.checkNotNull(cryptFunction, "cryptFunction");
        this.login = Preconditions.checkNotNull(login, "login");
        this.password = Preconditions.checkNotNull(password, "password");
    }

    @Override
    public Iterable<String> functionDependencies(OsFamily family) {
        return ImmutableList.of();
    }

    @Override
    public String render(OsFamily family) {
        Preconditions.checkNotNull(family, "family");
        if (family == OsFamily.WINDOWS) {
            throw new UnsupportedOperationException("windows not yet implemented");
        }
        try {
            String shadowPasswordEntry = this.cryptFunction.apply(this.password);
            String shadowFile = "/etc/shadow";
            Statement replaceEntryInTempFile = Statements.exec(String.format("awk -v user=^%1$s: -v password='%2$s' 'BEGIN { FS=OFS=\":\" } $0 ~ user { $2 = password } 1' %3$s >%3$s.%1$s", this.login, shadowPasswordEntry, shadowFile));
            Statement replaceShadowFile = Statements.exec(String.format("test -f %2$s.%1$s && mv %2$s.%1$s %2$s", this.login, shadowFile));
            return new StatementList(ImmutableList.of(replaceEntryInTempFile, replaceShadowFile)).render(family);
        }
        catch (Exception e) {
            Throwables.propagate(e);
            return null;
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.login == null ? 0 : this.login.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ReplaceShadowPasswordEntry other = (ReplaceShadowPasswordEntry)obj;
        return !(this.login == null ? other.login != null : !this.login.equals(other.login));
    }
}

