/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openssl;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.Reader;
import java.security.AlgorithmParameters;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import java.security.cert.CertificateFactory;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.DSAPrivateKeySpec;
import java.security.spec.DSAPublicKeySpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.RSAPrivateCrtKeySpec;
import java.security.spec.RSAPublicKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;
import javax.crypto.spec.RC2ParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERInteger;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.cms.ContentInfo;
import org.bouncycastle.asn1.pkcs.EncryptedPrivateKeyInfo;
import org.bouncycastle.asn1.pkcs.EncryptionScheme;
import org.bouncycastle.asn1.pkcs.KeyDerivationFunc;
import org.bouncycastle.asn1.pkcs.PBEParameter;
import org.bouncycastle.asn1.pkcs.PBES2Parameters;
import org.bouncycastle.asn1.pkcs.PBKDF2Params;
import org.bouncycastle.asn1.pkcs.PKCS12PBEParams;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.asn1.pkcs.RSAPrivateKey;
import org.bouncycastle.asn1.pkcs.RSAPublicKey;
import org.bouncycastle.asn1.sec.ECPrivateKey;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.asn1.x9.X9ObjectIdentifiers;
import org.bouncycastle.crypto.PBEParametersGenerator;
import org.bouncycastle.crypto.generators.OpenSSLPBEParametersGenerator;
import org.bouncycastle.crypto.generators.PKCS5S2ParametersGenerator;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.jce.ECNamedCurveTable;
import org.bouncycastle.jce.PKCS10CertificationRequest;
import org.bouncycastle.jce.spec.ECNamedCurveParameterSpec;
import org.bouncycastle.openssl.EncryptionException;
import org.bouncycastle.openssl.PEMException;
import org.bouncycastle.openssl.PEMUtilities;
import org.bouncycastle.openssl.PasswordException;
import org.bouncycastle.openssl.PasswordFinder;
import org.bouncycastle.util.encoders.Hex;
import org.bouncycastle.util.io.pem.PemHeader;
import org.bouncycastle.util.io.pem.PemObject;
import org.bouncycastle.util.io.pem.PemObjectParser;
import org.bouncycastle.util.io.pem.PemReader;
import org.bouncycastle.x509.X509V2AttributeCertificate;

public class PEMReader
extends PemReader {
    private final Map parsers = new HashMap();
    private PasswordFinder pFinder;

    public PEMReader(Reader reader) {
        this(reader, null, "BC");
    }

    public PEMReader(Reader reader, PasswordFinder passwordFinder) {
        this(reader, passwordFinder, "BC");
    }

    public PEMReader(Reader reader, PasswordFinder passwordFinder, String string) {
        this(reader, passwordFinder, string, string);
    }

    public PEMReader(Reader reader, PasswordFinder passwordFinder, String string, String string2) {
        super(reader);
        this.pFinder = passwordFinder;
        this.parsers.put("CERTIFICATE REQUEST", new PKCS10CertificationRequestParser());
        this.parsers.put("NEW CERTIFICATE REQUEST", new PKCS10CertificationRequestParser());
        this.parsers.put("CERTIFICATE", new X509CertificateParser(string2));
        this.parsers.put("X509 CERTIFICATE", new X509CertificateParser(string2));
        this.parsers.put("X509 CRL", new X509CRLParser(string2));
        this.parsers.put("PKCS7", new PKCS7Parser());
        this.parsers.put("ATTRIBUTE CERTIFICATE", new X509AttributeCertificateParser());
        this.parsers.put("EC PARAMETERS", new ECNamedCurveSpecParser());
        this.parsers.put("PUBLIC KEY", new PublicKeyParser(string2));
        this.parsers.put("RSA PUBLIC KEY", new RSAPublicKeyParser(string2));
        this.parsers.put("RSA PRIVATE KEY", new RSAKeyPairParser(string, string2));
        this.parsers.put("DSA PRIVATE KEY", new DSAKeyPairParser(string, string2));
        this.parsers.put("EC PRIVATE KEY", new ECDSAKeyPairParser(string, string2));
        this.parsers.put("ENCRYPTED PRIVATE KEY", new EncryptedPrivateKeyParser(string, string2));
        this.parsers.put("PRIVATE KEY", new PrivateKeyParser(string2));
    }

    public Object readObject() throws IOException {
        PemObject pemObject = this.readPemObject();
        if (pemObject != null) {
            String string = pemObject.getType();
            if (this.parsers.containsKey(string)) {
                return ((PemObjectParser)this.parsers.get(string)).parseObject(pemObject);
            }
            throw new IOException("unrecognised object: " + string);
        }
        return null;
    }

    static byte[] crypt(boolean bl, String string, byte[] byArray, char[] cArray, String string2, byte[] byArray2) throws IOException {
        Provider provider = null;
        if (string != null && (provider = Security.getProvider(string)) == null) {
            throw new EncryptionException("cannot find provider: " + string);
        }
        return PEMReader.crypt(bl, provider, byArray, cArray, string2, byArray2);
    }

    static byte[] crypt(boolean bl, Provider provider, byte[] byArray, char[] cArray, String string, byte[] byArray2) throws IOException {
        SecretKey secretKey;
        String string2;
        AlgorithmParameterSpec algorithmParameterSpec = new IvParameterSpec(byArray2);
        String string3 = "CBC";
        String string4 = "PKCS5Padding";
        if (string.endsWith("-CFB")) {
            string3 = "CFB";
            string4 = "NoPadding";
        }
        if (string.endsWith("-ECB") || "DES-EDE".equals(string) || "DES-EDE3".equals(string)) {
            string3 = "ECB";
            algorithmParameterSpec = null;
        }
        if (string.endsWith("-OFB")) {
            string3 = "OFB";
            string4 = "NoPadding";
        }
        if (string.startsWith("DES-EDE")) {
            string2 = "DESede";
            boolean bl2 = !string.startsWith("DES-EDE3");
            secretKey = PEMReader.getKey(cArray, string2, 24, byArray2, bl2);
        } else if (string.startsWith("DES-")) {
            string2 = "DES";
            secretKey = PEMReader.getKey(cArray, string2, 8, byArray2);
        } else if (string.startsWith("BF-")) {
            string2 = "Blowfish";
            secretKey = PEMReader.getKey(cArray, string2, 16, byArray2);
        } else if (string.startsWith("RC2-")) {
            string2 = "RC2";
            int n = 128;
            if (string.startsWith("RC2-40-")) {
                n = 40;
            } else if (string.startsWith("RC2-64-")) {
                n = 64;
            }
            secretKey = PEMReader.getKey(cArray, string2, n / 8, byArray2);
            algorithmParameterSpec = algorithmParameterSpec == null ? new RC2ParameterSpec(n) : new RC2ParameterSpec(n, byArray2);
        } else if (string.startsWith("AES-")) {
            int n;
            string2 = "AES";
            byte[] byArray3 = byArray2;
            if (byArray3.length > 8) {
                byArray3 = new byte[8];
                System.arraycopy(byArray2, 0, byArray3, 0, 8);
            }
            if (string.startsWith("AES-128-")) {
                n = 128;
            } else if (string.startsWith("AES-192-")) {
                n = 192;
            } else if (string.startsWith("AES-256-")) {
                n = 256;
            } else {
                throw new EncryptionException("unknown AES encryption with private key");
            }
            secretKey = PEMReader.getKey(cArray, "AES", n / 8, byArray3);
        } else {
            throw new EncryptionException("unknown encryption with private key");
        }
        String string5 = string2 + "/" + string3 + "/" + string4;
        try {
            int n;
            Cipher cipher = Cipher.getInstance(string5, provider);
            int n2 = n = bl ? 1 : 2;
            if (algorithmParameterSpec == null) {
                cipher.init(n, secretKey);
            } else {
                cipher.init(n, (Key)secretKey, algorithmParameterSpec);
            }
            return cipher.doFinal(byArray);
        }
        catch (Exception exception) {
            throw new EncryptionException("exception using cipher - please check password and data.", (Throwable)exception);
        }
    }

    private static SecretKey getKey(char[] cArray, String string, int n, byte[] byArray) {
        return PEMReader.getKey(cArray, string, n, byArray, false);
    }

    private static SecretKey getKey(char[] cArray, String string, int n, byte[] byArray, boolean bl) {
        OpenSSLPBEParametersGenerator openSSLPBEParametersGenerator = new OpenSSLPBEParametersGenerator();
        openSSLPBEParametersGenerator.init(PBEParametersGenerator.PKCS5PasswordToBytes(cArray), byArray);
        KeyParameter keyParameter = (KeyParameter)openSSLPBEParametersGenerator.generateDerivedParameters(n * 8);
        byte[] byArray2 = keyParameter.getKey();
        if (bl && byArray2.length >= 24) {
            System.arraycopy(byArray2, 0, byArray2, 16, 8);
        }
        return new SecretKeySpec(byArray2, string);
    }

    public static SecretKey generateSecretKeyForPKCS5Scheme2(String string, char[] cArray, byte[] byArray, int n) {
        PKCS5S2ParametersGenerator pKCS5S2ParametersGenerator = new PKCS5S2ParametersGenerator();
        pKCS5S2ParametersGenerator.init(PBEParametersGenerator.PKCS5PasswordToBytes(cArray), byArray, n);
        return new SecretKeySpec(((KeyParameter)((PBEParametersGenerator)pKCS5S2ParametersGenerator).generateDerivedParameters(PEMUtilities.getKeySize(string))).getKey(), string);
    }

    private class DSAKeyPairParser
    extends KeyPairParser {
        private String asymProvider;

        public DSAKeyPairParser(String string, String string2) {
            super(string);
            this.asymProvider = string2;
        }

        public Object parseObject(PemObject pemObject) throws IOException {
            try {
                ASN1Sequence aSN1Sequence = this.readKeyPair(pemObject);
                if (aSN1Sequence.size() != 6) {
                    throw new PEMException("malformed sequence in DSA private key");
                }
                DERInteger dERInteger = (DERInteger)aSN1Sequence.getObjectAt(1);
                DERInteger dERInteger2 = (DERInteger)aSN1Sequence.getObjectAt(2);
                DERInteger dERInteger3 = (DERInteger)aSN1Sequence.getObjectAt(3);
                DERInteger dERInteger4 = (DERInteger)aSN1Sequence.getObjectAt(4);
                DERInteger dERInteger5 = (DERInteger)aSN1Sequence.getObjectAt(5);
                DSAPrivateKeySpec dSAPrivateKeySpec = new DSAPrivateKeySpec(dERInteger5.getValue(), dERInteger.getValue(), dERInteger2.getValue(), dERInteger3.getValue());
                DSAPublicKeySpec dSAPublicKeySpec = new DSAPublicKeySpec(dERInteger4.getValue(), dERInteger.getValue(), dERInteger2.getValue(), dERInteger3.getValue());
                KeyFactory keyFactory = KeyFactory.getInstance("DSA", this.asymProvider);
                return new KeyPair(keyFactory.generatePublic(dSAPublicKeySpec), keyFactory.generatePrivate(dSAPrivateKeySpec));
            }
            catch (IOException iOException) {
                throw iOException;
            }
            catch (Exception exception) {
                throw new PEMException("problem creating DSA private key: " + exception.toString(), exception);
            }
        }
    }

    private class ECDSAKeyPairParser
    extends KeyPairParser {
        private String asymProvider;

        public ECDSAKeyPairParser(String string, String string2) {
            super(string);
            this.asymProvider = string2;
        }

        public Object parseObject(PemObject pemObject) throws IOException {
            try {
                ASN1Sequence aSN1Sequence = this.readKeyPair(pemObject);
                ECPrivateKey eCPrivateKey = ECPrivateKey.getInstance(aSN1Sequence);
                AlgorithmIdentifier algorithmIdentifier = new AlgorithmIdentifier(X9ObjectIdentifiers.id_ecPublicKey, eCPrivateKey.getParameters());
                PrivateKeyInfo privateKeyInfo = new PrivateKeyInfo(algorithmIdentifier, eCPrivateKey);
                SubjectPublicKeyInfo subjectPublicKeyInfo = new SubjectPublicKeyInfo(algorithmIdentifier, eCPrivateKey.getPublicKey().getBytes());
                PKCS8EncodedKeySpec pKCS8EncodedKeySpec = new PKCS8EncodedKeySpec(privateKeyInfo.getEncoded());
                X509EncodedKeySpec x509EncodedKeySpec = new X509EncodedKeySpec(subjectPublicKeyInfo.getEncoded());
                KeyFactory keyFactory = KeyFactory.getInstance("ECDSA", this.asymProvider);
                return new KeyPair(keyFactory.generatePublic(x509EncodedKeySpec), keyFactory.generatePrivate(pKCS8EncodedKeySpec));
            }
            catch (IOException iOException) {
                throw iOException;
            }
            catch (Exception exception) {
                throw new PEMException("problem creating EC private key: " + exception.toString(), exception);
            }
        }
    }

    private class ECNamedCurveSpecParser
    implements PemObjectParser {
        private ECNamedCurveSpecParser() {
        }

        public Object parseObject(PemObject pemObject) throws IOException {
            try {
                DERObjectIdentifier dERObjectIdentifier = (DERObjectIdentifier)ASN1Primitive.fromByteArray(pemObject.getContent());
                ECNamedCurveParameterSpec eCNamedCurveParameterSpec = ECNamedCurveTable.getParameterSpec(dERObjectIdentifier.getId());
                if (eCNamedCurveParameterSpec == null) {
                    throw new IOException("object ID not found in EC curve table");
                }
                return eCNamedCurveParameterSpec;
            }
            catch (IOException iOException) {
                throw iOException;
            }
            catch (Exception exception) {
                throw new PEMException("exception extracting EC named curve: " + exception.toString());
            }
        }
    }

    private class EncryptedPrivateKeyParser
    implements PemObjectParser {
        private String symProvider;
        private String asymProvider;

        public EncryptedPrivateKeyParser(String string, String string2) {
            this.symProvider = string;
            this.asymProvider = string2;
        }

        public Object parseObject(PemObject pemObject) throws IOException {
            try {
                EncryptedPrivateKeyInfo encryptedPrivateKeyInfo = EncryptedPrivateKeyInfo.getInstance(ASN1Primitive.fromByteArray(pemObject.getContent()));
                AlgorithmIdentifier algorithmIdentifier = encryptedPrivateKeyInfo.getEncryptionAlgorithm();
                if (PEMReader.this.pFinder == null) {
                    throw new PEMException("no PasswordFinder specified");
                }
                if (PEMUtilities.isPKCS5Scheme2(algorithmIdentifier.getAlgorithm())) {
                    PBES2Parameters pBES2Parameters = PBES2Parameters.getInstance(algorithmIdentifier.getParameters());
                    KeyDerivationFunc keyDerivationFunc = pBES2Parameters.getKeyDerivationFunc();
                    EncryptionScheme encryptionScheme = pBES2Parameters.getEncryptionScheme();
                    PBKDF2Params pBKDF2Params = (PBKDF2Params)keyDerivationFunc.getParameters();
                    int n = pBKDF2Params.getIterationCount().intValue();
                    byte[] byArray = pBKDF2Params.getSalt();
                    String string = encryptionScheme.getAlgorithm().getId();
                    SecretKey secretKey = PEMReader.generateSecretKeyForPKCS5Scheme2(string, PEMReader.this.pFinder.getPassword(), byArray, n);
                    Cipher cipher = Cipher.getInstance(string, this.symProvider);
                    AlgorithmParameters algorithmParameters = AlgorithmParameters.getInstance(string, this.symProvider);
                    algorithmParameters.init(encryptionScheme.getParameters().toASN1Primitive().getEncoded());
                    cipher.init(2, (Key)secretKey, algorithmParameters);
                    PrivateKeyInfo privateKeyInfo = PrivateKeyInfo.getInstance(ASN1Primitive.fromByteArray(cipher.doFinal(encryptedPrivateKeyInfo.getEncryptedData())));
                    PKCS8EncodedKeySpec pKCS8EncodedKeySpec = new PKCS8EncodedKeySpec(privateKeyInfo.getEncoded());
                    KeyFactory keyFactory = KeyFactory.getInstance(privateKeyInfo.getPrivateKeyAlgorithm().getAlgorithm().getId(), this.asymProvider);
                    return keyFactory.generatePrivate(pKCS8EncodedKeySpec);
                }
                if (PEMUtilities.isPKCS12((DERObjectIdentifier)algorithmIdentifier.getAlgorithm())) {
                    PKCS12PBEParams pKCS12PBEParams = PKCS12PBEParams.getInstance(algorithmIdentifier.getParameters());
                    String string = algorithmIdentifier.getAlgorithm().getId();
                    PBEKeySpec pBEKeySpec = new PBEKeySpec(PEMReader.this.pFinder.getPassword());
                    SecretKeyFactory secretKeyFactory = SecretKeyFactory.getInstance(string, this.symProvider);
                    PBEParameterSpec pBEParameterSpec = new PBEParameterSpec(pKCS12PBEParams.getIV(), pKCS12PBEParams.getIterations().intValue());
                    Cipher cipher = Cipher.getInstance(string, this.symProvider);
                    cipher.init(2, (Key)secretKeyFactory.generateSecret(pBEKeySpec), pBEParameterSpec);
                    PrivateKeyInfo privateKeyInfo = PrivateKeyInfo.getInstance(ASN1Primitive.fromByteArray(cipher.doFinal(encryptedPrivateKeyInfo.getEncryptedData())));
                    PKCS8EncodedKeySpec pKCS8EncodedKeySpec = new PKCS8EncodedKeySpec(privateKeyInfo.getEncoded());
                    KeyFactory keyFactory = KeyFactory.getInstance(privateKeyInfo.getPrivateKeyAlgorithm().getAlgorithm().getId(), this.asymProvider);
                    return keyFactory.generatePrivate(pKCS8EncodedKeySpec);
                }
                if (PEMUtilities.isPKCS5Scheme1((DERObjectIdentifier)algorithmIdentifier.getAlgorithm())) {
                    PBEParameter pBEParameter = PBEParameter.getInstance(algorithmIdentifier.getParameters());
                    String string = algorithmIdentifier.getAlgorithm().getId();
                    PBEKeySpec pBEKeySpec = new PBEKeySpec(PEMReader.this.pFinder.getPassword());
                    SecretKeyFactory secretKeyFactory = SecretKeyFactory.getInstance(string, this.symProvider);
                    PBEParameterSpec pBEParameterSpec = new PBEParameterSpec(pBEParameter.getSalt(), pBEParameter.getIterationCount().intValue());
                    Cipher cipher = Cipher.getInstance(string, this.symProvider);
                    cipher.init(2, (Key)secretKeyFactory.generateSecret(pBEKeySpec), pBEParameterSpec);
                    PrivateKeyInfo privateKeyInfo = PrivateKeyInfo.getInstance(ASN1Primitive.fromByteArray(cipher.doFinal(encryptedPrivateKeyInfo.getEncryptedData())));
                    PKCS8EncodedKeySpec pKCS8EncodedKeySpec = new PKCS8EncodedKeySpec(privateKeyInfo.getEncoded());
                    KeyFactory keyFactory = KeyFactory.getInstance(privateKeyInfo.getPrivateKeyAlgorithm().getAlgorithm().getId(), this.asymProvider);
                    return keyFactory.generatePrivate(pKCS8EncodedKeySpec);
                }
                throw new PEMException("Unknown algorithm: " + algorithmIdentifier.getAlgorithm());
            }
            catch (IOException iOException) {
                throw iOException;
            }
            catch (Exception exception) {
                throw new PEMException("problem parsing ENCRYPTED PRIVATE KEY: " + exception.toString(), exception);
            }
        }
    }

    private abstract class KeyPairParser
    implements PemObjectParser {
        protected String symProvider;

        public KeyPairParser(String string) {
            this.symProvider = string;
        }

        protected ASN1Sequence readKeyPair(PemObject pemObject) throws IOException {
            boolean bl = false;
            String string = null;
            List list = pemObject.getHeaders();
            for (Object object2 : list) {
                if (((PemHeader)object2).getName().equals("Proc-Type") && ((PemHeader)object2).getValue().equals("4,ENCRYPTED")) {
                    bl = true;
                    continue;
                }
                if (!((PemHeader)object2).getName().equals("DEK-Info")) continue;
                string = ((PemHeader)object2).getValue();
            }
            Object object = pemObject.getContent();
            if (bl) {
                Object object2;
                if (PEMReader.this.pFinder == null) {
                    throw new PasswordException("No password finder specified, but a password is required");
                }
                object2 = PEMReader.this.pFinder.getPassword();
                if (object2 == null) {
                    throw new PasswordException("Password is null, but a password is required");
                }
                StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
                String string2 = stringTokenizer.nextToken();
                byte[] byArray = Hex.decode(stringTokenizer.nextToken());
                object = PEMReader.crypt(false, this.symProvider, (byte[])object, (char[])object2, string2, byArray);
            }
            try {
                return ASN1Sequence.getInstance(ASN1Primitive.fromByteArray((byte[])object));
            }
            catch (IOException iOException) {
                if (bl) {
                    throw new PEMException("exception decoding - please check password and data.", iOException);
                }
                throw new PEMException(iOException.getMessage(), iOException);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                if (bl) {
                    throw new PEMException("exception decoding - please check password and data.", illegalArgumentException);
                }
                throw new PEMException(illegalArgumentException.getMessage(), illegalArgumentException);
            }
        }
    }

    private class PKCS10CertificationRequestParser
    implements PemObjectParser {
        private PKCS10CertificationRequestParser() {
        }

        public Object parseObject(PemObject pemObject) throws IOException {
            try {
                return new PKCS10CertificationRequest(pemObject.getContent());
            }
            catch (Exception exception) {
                throw new PEMException("problem parsing certrequest: " + exception.toString(), exception);
            }
        }
    }

    private class PKCS7Parser
    implements PemObjectParser {
        private PKCS7Parser() {
        }

        public Object parseObject(PemObject pemObject) throws IOException {
            try {
                ASN1InputStream aSN1InputStream = new ASN1InputStream(pemObject.getContent());
                return ContentInfo.getInstance(aSN1InputStream.readObject());
            }
            catch (Exception exception) {
                throw new PEMException("problem parsing PKCS7 object: " + exception.toString(), exception);
            }
        }
    }

    private class PrivateKeyParser
    implements PemObjectParser {
        private String provider;

        public PrivateKeyParser(String string) {
            this.provider = string;
        }

        public Object parseObject(PemObject pemObject) throws IOException {
            try {
                PrivateKeyInfo privateKeyInfo = PrivateKeyInfo.getInstance(ASN1Primitive.fromByteArray(pemObject.getContent()));
                PKCS8EncodedKeySpec pKCS8EncodedKeySpec = new PKCS8EncodedKeySpec(pemObject.getContent());
                KeyFactory keyFactory = KeyFactory.getInstance(privateKeyInfo.getPrivateKeyAlgorithm().getAlgorithm().getId(), this.provider);
                return keyFactory.generatePrivate(pKCS8EncodedKeySpec);
            }
            catch (Exception exception) {
                throw new PEMException("problem parsing PRIVATE KEY: " + exception.toString(), exception);
            }
        }
    }

    private class PublicKeyParser
    implements PemObjectParser {
        private String provider;

        public PublicKeyParser(String string) {
            this.provider = string;
        }

        public Object parseObject(PemObject pemObject) throws IOException {
            X509EncodedKeySpec x509EncodedKeySpec = new X509EncodedKeySpec(pemObject.getContent());
            String[] stringArray = new String[]{"DSA", "RSA"};
            for (int i = 0; i < stringArray.length; ++i) {
                try {
                    KeyFactory keyFactory = KeyFactory.getInstance(stringArray[i], this.provider);
                    PublicKey publicKey = keyFactory.generatePublic(x509EncodedKeySpec);
                    return publicKey;
                }
                catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                    continue;
                }
                catch (InvalidKeySpecException invalidKeySpecException) {
                    continue;
                }
                catch (NoSuchProviderException noSuchProviderException) {
                    throw new RuntimeException("can't find provider " + this.provider);
                }
            }
            return null;
        }
    }

    private class RSAKeyPairParser
    extends KeyPairParser {
        private String asymProvider;

        public RSAKeyPairParser(String string, String string2) {
            super(string);
            this.asymProvider = string2;
        }

        public Object parseObject(PemObject pemObject) throws IOException {
            try {
                ASN1Sequence aSN1Sequence = this.readKeyPair(pemObject);
                if (aSN1Sequence.size() != 9) {
                    throw new PEMException("malformed sequence in RSA private key");
                }
                RSAPrivateKey rSAPrivateKey = RSAPrivateKey.getInstance(aSN1Sequence);
                RSAPublicKeySpec rSAPublicKeySpec = new RSAPublicKeySpec(rSAPrivateKey.getModulus(), rSAPrivateKey.getPublicExponent());
                RSAPrivateCrtKeySpec rSAPrivateCrtKeySpec = new RSAPrivateCrtKeySpec(rSAPrivateKey.getModulus(), rSAPrivateKey.getPublicExponent(), rSAPrivateKey.getPrivateExponent(), rSAPrivateKey.getPrime1(), rSAPrivateKey.getPrime2(), rSAPrivateKey.getExponent1(), rSAPrivateKey.getExponent2(), rSAPrivateKey.getCoefficient());
                KeyFactory keyFactory = KeyFactory.getInstance("RSA", this.asymProvider);
                return new KeyPair(keyFactory.generatePublic(rSAPublicKeySpec), keyFactory.generatePrivate(rSAPrivateCrtKeySpec));
            }
            catch (IOException iOException) {
                throw iOException;
            }
            catch (Exception exception) {
                throw new PEMException("problem creating RSA private key: " + exception.toString(), exception);
            }
        }
    }

    private class RSAPublicKeyParser
    implements PemObjectParser {
        private String provider;

        public RSAPublicKeyParser(String string) {
            this.provider = string;
        }

        public Object parseObject(PemObject pemObject) throws IOException {
            try {
                ASN1InputStream aSN1InputStream = new ASN1InputStream(pemObject.getContent());
                ASN1Primitive aSN1Primitive = aSN1InputStream.readObject();
                ASN1Sequence aSN1Sequence = (ASN1Sequence)aSN1Primitive;
                RSAPublicKey rSAPublicKey = RSAPublicKey.getInstance(aSN1Sequence);
                RSAPublicKeySpec rSAPublicKeySpec = new RSAPublicKeySpec(rSAPublicKey.getModulus(), rSAPublicKey.getPublicExponent());
                KeyFactory keyFactory = KeyFactory.getInstance("RSA", this.provider);
                return keyFactory.generatePublic(rSAPublicKeySpec);
            }
            catch (IOException iOException) {
                throw iOException;
            }
            catch (NoSuchProviderException noSuchProviderException) {
                throw new IOException("can't find provider " + this.provider);
            }
            catch (Exception exception) {
                throw new PEMException("problem extracting key: " + exception.toString(), exception);
            }
        }
    }

    private class X509AttributeCertificateParser
    implements PemObjectParser {
        private X509AttributeCertificateParser() {
        }

        public Object parseObject(PemObject pemObject) throws IOException {
            return new X509V2AttributeCertificate(pemObject.getContent());
        }
    }

    private class X509CRLParser
    implements PemObjectParser {
        private String provider;

        public X509CRLParser(String string) {
            this.provider = string;
        }

        public Object parseObject(PemObject pemObject) throws IOException {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(pemObject.getContent());
            try {
                CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509", this.provider);
                return certificateFactory.generateCRL(byteArrayInputStream);
            }
            catch (Exception exception) {
                throw new PEMException("problem parsing cert: " + exception.toString(), exception);
            }
        }
    }

    private class X509CertificateParser
    implements PemObjectParser {
        private String provider;

        public X509CertificateParser(String string) {
            this.provider = string;
        }

        public Object parseObject(PemObject pemObject) throws IOException {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(pemObject.getContent());
            try {
                CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509", this.provider);
                return certificateFactory.generateCertificate(byteArrayInputStream);
            }
            catch (Exception exception) {
                throw new PEMException("problem parsing cert: " + exception.toString(), exception);
            }
        }
    }
}

