/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.compute;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Supplier;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import com.google.common.util.concurrent.ListeningExecutorService;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.jclouds.cloudstack.CloudStackApi;
import org.jclouds.cloudstack.compute.options.CloudStackTemplateOptions;
import org.jclouds.cloudstack.domain.SecurityGroup;
import org.jclouds.cloudstack.domain.SshKeyPair;
import org.jclouds.cloudstack.domain.Zone;
import org.jclouds.cloudstack.domain.ZoneAndName;
import org.jclouds.cloudstack.options.ListSSHKeyPairsOptions;
import org.jclouds.cloudstack.options.ListSecurityGroupsOptions;
import org.jclouds.cloudstack.predicates.SecurityGroupPredicates;
import org.jclouds.cloudstack.predicates.SshKeyPairPredicates;
import org.jclouds.cloudstack.predicates.ZonePredicates;
import org.jclouds.collect.Memoized;
import org.jclouds.compute.ComputeServiceContext;
import org.jclouds.compute.callables.RunScriptOnNode;
import org.jclouds.compute.domain.Hardware;
import org.jclouds.compute.domain.Image;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.compute.domain.TemplateBuilder;
import org.jclouds.compute.extensions.ImageExtension;
import org.jclouds.compute.extensions.SecurityGroupExtension;
import org.jclouds.compute.functions.GroupNamingConvention;
import org.jclouds.compute.internal.BaseComputeService;
import org.jclouds.compute.internal.PersistNodeCredentials;
import org.jclouds.compute.options.TemplateOptions;
import org.jclouds.compute.reference.ComputeServiceConstants;
import org.jclouds.compute.strategy.CreateNodesInGroupThenAddToSet;
import org.jclouds.compute.strategy.DestroyNodeStrategy;
import org.jclouds.compute.strategy.GetImageStrategy;
import org.jclouds.compute.strategy.GetNodeMetadataStrategy;
import org.jclouds.compute.strategy.InitializeRunScriptOnNodeOrPlaceInBadMap;
import org.jclouds.compute.strategy.ListNodesStrategy;
import org.jclouds.compute.strategy.RebootNodeStrategy;
import org.jclouds.compute.strategy.ResumeNodeStrategy;
import org.jclouds.compute.strategy.SuspendNodeStrategy;
import org.jclouds.domain.Credentials;
import org.jclouds.domain.Location;
import org.jclouds.scriptbuilder.functions.InitAdminAccess;

@Singleton
public class CloudStackComputeService
extends BaseComputeService {
    protected final CloudStackApi client;
    protected final LoadingCache<ZoneAndName, SecurityGroup> securityGroupMap;
    protected final LoadingCache<String, SshKeyPair> keyPairCache;
    protected final Function<Set<? extends NodeMetadata>, Multimap<String, String>> orphanedGroupsByZoneId;
    protected final GroupNamingConvention.Factory namingConvention;
    protected final Supplier<LoadingCache<String, Zone>> zoneIdToZone;

    @Inject
    protected CloudStackComputeService(ComputeServiceContext context, Map<String, Credentials> credentialStore, @Memoized Supplier<Set<? extends Image>> images, @Memoized Supplier<Set<? extends Hardware>> sizes, @Memoized Supplier<Set<? extends Location>> locations, ListNodesStrategy listNodesStrategy, GetImageStrategy getImageStrategy, GetNodeMetadataStrategy getNodeMetadataStrategy, CreateNodesInGroupThenAddToSet runNodesAndAddToSetStrategy, RebootNodeStrategy rebootNodeStrategy, DestroyNodeStrategy destroyNodeStrategy, ResumeNodeStrategy startNodeStrategy, SuspendNodeStrategy stopNodeStrategy, Provider<TemplateBuilder> templateBuilderProvider, @Named(value="DEFAULT") Provider<TemplateOptions> templateOptionsProvider, @Named(value="jclouds.compute.timeout.node-running") Predicate<AtomicReference<NodeMetadata>> nodeRunning, @Named(value="jclouds.compute.timeout.node-terminated") Predicate<AtomicReference<NodeMetadata>> nodeTerminated, @Named(value="jclouds.compute.timeout.node-suspended") Predicate<AtomicReference<NodeMetadata>> nodeSuspended, InitializeRunScriptOnNodeOrPlaceInBadMap.Factory initScriptRunnerFactory, RunScriptOnNode.Factory runScriptOnNodeFactory, InitAdminAccess initAdminAccess, PersistNodeCredentials persistNodeCredentials, ComputeServiceConstants.Timeouts timeouts, @Named(value="jclouds.user-threads") ListeningExecutorService userExecutor, CloudStackApi client, LoadingCache<ZoneAndName, SecurityGroup> securityGroupMap, LoadingCache<String, SshKeyPair> keyPairCache, Function<Set<? extends NodeMetadata>, Multimap<String, String>> orphanedGroupsByZoneId, GroupNamingConvention.Factory namingConvention, Supplier<LoadingCache<String, Zone>> zoneIdToZone, Optional<ImageExtension> imageExtension, Optional<SecurityGroupExtension> securityGroupExtension) {
        super(context, credentialStore, images, sizes, locations, listNodesStrategy, getImageStrategy, getNodeMetadataStrategy, runNodesAndAddToSetStrategy, rebootNodeStrategy, destroyNodeStrategy, startNodeStrategy, stopNodeStrategy, templateBuilderProvider, templateOptionsProvider, nodeRunning, nodeTerminated, nodeSuspended, initScriptRunnerFactory, initAdminAccess, runScriptOnNodeFactory, persistNodeCredentials, timeouts, userExecutor, imageExtension, securityGroupExtension);
        this.zoneIdToZone = Preconditions.checkNotNull(zoneIdToZone, "zoneIdToZone");
        this.client = Preconditions.checkNotNull(client, "client");
        this.securityGroupMap = Preconditions.checkNotNull(securityGroupMap, "securityGroupMap");
        this.keyPairCache = Preconditions.checkNotNull(keyPairCache, "keyPairCache");
        this.orphanedGroupsByZoneId = Preconditions.checkNotNull(orphanedGroupsByZoneId, "orphanedGroupsByZoneId");
        this.namingConvention = Preconditions.checkNotNull(namingConvention, "namingConvention");
    }

    @Override
    protected void cleanUpIncidentalResourcesOfDeadNodes(Set<? extends NodeMetadata> deadNodes) {
        Multimap<String, String> zoneToZoneAndGroupNames = this.orphanedGroupsByZoneId.apply(deadNodes);
        for (String zoneId : zoneToZoneAndGroupNames.keySet()) {
            this.cleanOrphanedGroupsInZone(ImmutableSet.copyOf(zoneToZoneAndGroupNames.get(zoneId)), zoneId);
        }
    }

    protected void cleanOrphanedGroupsInZone(Set<String> groups, String zoneId) {
        this.cleanupOrphanedSecurityGroupsInZone(groups, zoneId);
        this.cleanupOrphanedKeyPairsInZone(groups, zoneId);
    }

    private void cleanupOrphanedSecurityGroupsInZone(Set<String> groups, String zoneId) {
        Zone zone = this.zoneIdToZone.get().getUnchecked(zoneId);
        if (ZonePredicates.supportsSecurityGroups().apply(zone)) {
            for (String group : groups) {
                for (SecurityGroup securityGroup : Iterables.filter(this.client.getSecurityGroupApi().listSecurityGroups(new ListSecurityGroupsOptions[0]), SecurityGroupPredicates.nameMatches(this.namingConvention.create().containsGroup(group)))) {
                    ZoneAndName zoneAndName = ZoneAndName.fromZoneAndName(zoneId, securityGroup.getName());
                    this.logger.debug(">> deleting securityGroup(%s)", zoneAndName);
                    this.client.getSecurityGroupApi().deleteSecurityGroup(securityGroup.getId());
                    this.securityGroupMap.invalidate(zoneAndName);
                    this.logger.debug("<< deleted securityGroup(%s)", zoneAndName);
                }
            }
        }
    }

    private void cleanupOrphanedKeyPairsInZone(Set<String> groups, String zoneId) {
        for (String group : groups) {
            for (SshKeyPair pair : Iterables.filter(this.client.getSSHKeyPairApi().listSSHKeyPairs(new ListSSHKeyPairsOptions[0]), SshKeyPairPredicates.nameMatches(this.namingConvention.create().containsGroup(group)))) {
                this.logger.debug(">> deleting keypair(%s)", pair.getName());
                this.client.getSSHKeyPairApi().deleteSSHKeyPair(pair.getName());
                this.keyPairCache.invalidate(pair.getName());
                this.logger.debug("<< deleted keypair(%s)", pair.getName());
            }
            this.keyPairCache.invalidate(this.namingConvention.create().sharedNameForGroup(group));
        }
    }

    @Override
    public CloudStackTemplateOptions templateOptions() {
        return (CloudStackTemplateOptions)CloudStackTemplateOptions.class.cast(super.templateOptions());
    }
}

