/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.options;

import com.google.common.collect.ImmutableSet;
import java.util.Map;
import org.jclouds.cloudstack.options.AccountInDomainOptions;

public class ListPublicIPAddressesOptions
extends AccountInDomainOptions {
    public static final ListPublicIPAddressesOptions NONE = new ListPublicIPAddressesOptions();

    public ListPublicIPAddressesOptions id(String id) {
        this.queryParameters.replaceValues("id", ImmutableSet.of(id + ""));
        return this;
    }

    public ListPublicIPAddressesOptions allocatedOnly(boolean allocatedOnly) {
        this.queryParameters.replaceValues("allocatedonly", ImmutableSet.of(allocatedOnly + ""));
        return this;
    }

    public ListPublicIPAddressesOptions networkId(String networkId) {
        this.queryParameters.replaceValues("networkid", ImmutableSet.of(networkId + ""));
        return this;
    }

    public ListPublicIPAddressesOptions projectId(String projectId) {
        this.queryParameters.replaceValues("projectid", ImmutableSet.of(projectId + ""));
        return this;
    }

    public ListPublicIPAddressesOptions VLANId(String VLANId) {
        this.queryParameters.replaceValues("vlanid", ImmutableSet.of(VLANId + ""));
        return this;
    }

    public ListPublicIPAddressesOptions IPAddress(String IPAddress2) {
        this.queryParameters.replaceValues("ipaddress", ImmutableSet.of(IPAddress2));
        return this;
    }

    public ListPublicIPAddressesOptions zoneId(String zoneId) {
        this.queryParameters.replaceValues("zoneid", ImmutableSet.of(zoneId + ""));
        return this;
    }

    public ListPublicIPAddressesOptions usesVirtualNetwork(boolean usesVirtualNetwork) {
        this.queryParameters.replaceValues("forvirtualnetwork", ImmutableSet.of(usesVirtualNetwork + ""));
        return this;
    }

    public ListPublicIPAddressesOptions tags(Map<String, String> tags) {
        int count = 0;
        for (Map.Entry<String, String> entry : tags.entrySet()) {
            this.queryParameters.replaceValues(String.format("tags[%d].key", count), ImmutableSet.of(entry.getKey()));
            this.queryParameters.replaceValues(String.format("tags[%d].value", count), ImmutableSet.of(entry.getValue()));
            ++count;
        }
        return this;
    }

    @Override
    public ListPublicIPAddressesOptions accountInDomain(String account, String domain) {
        return (ListPublicIPAddressesOptions)ListPublicIPAddressesOptions.class.cast(super.accountInDomain(account, domain));
    }

    @Override
    public ListPublicIPAddressesOptions domainId(String domainId) {
        return (ListPublicIPAddressesOptions)ListPublicIPAddressesOptions.class.cast(super.domainId(domainId));
    }

    public static class Builder {
        public static ListPublicIPAddressesOptions accountInDomain(String account, String domain) {
            ListPublicIPAddressesOptions options = new ListPublicIPAddressesOptions();
            return options.accountInDomain(account, domain);
        }

        public static ListPublicIPAddressesOptions IPAddress(String IPAddress2) {
            ListPublicIPAddressesOptions options = new ListPublicIPAddressesOptions();
            return options.IPAddress(IPAddress2);
        }

        public static ListPublicIPAddressesOptions domainId(String id) {
            ListPublicIPAddressesOptions options = new ListPublicIPAddressesOptions();
            return options.domainId(id);
        }

        public static ListPublicIPAddressesOptions id(String id) {
            ListPublicIPAddressesOptions options = new ListPublicIPAddressesOptions();
            return options.id(id);
        }

        public static ListPublicIPAddressesOptions allocatedOnly(boolean allocatedOnly) {
            ListPublicIPAddressesOptions options = new ListPublicIPAddressesOptions();
            return options.allocatedOnly(allocatedOnly);
        }

        public static ListPublicIPAddressesOptions networkId(String id) {
            ListPublicIPAddressesOptions options = new ListPublicIPAddressesOptions();
            return options.networkId(id);
        }

        public static ListPublicIPAddressesOptions projectId(String id) {
            ListPublicIPAddressesOptions options = new ListPublicIPAddressesOptions();
            return options.projectId(id);
        }

        public static ListPublicIPAddressesOptions VLANId(String id) {
            ListPublicIPAddressesOptions options = new ListPublicIPAddressesOptions();
            return options.VLANId(id);
        }

        public static ListPublicIPAddressesOptions zoneId(String id) {
            ListPublicIPAddressesOptions options = new ListPublicIPAddressesOptions();
            return options.zoneId(id);
        }

        public static ListPublicIPAddressesOptions usesVirtualNetwork(boolean usesVirtualNetwork) {
            ListPublicIPAddressesOptions options = new ListPublicIPAddressesOptions();
            return options.usesVirtualNetwork(usesVirtualNetwork);
        }

        public static ListPublicIPAddressesOptions tags(Map<String, String> tags) {
            ListPublicIPAddressesOptions options = new ListPublicIPAddressesOptions();
            return options.tags(tags);
        }
    }
}

