/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.elasticstack.binders;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.elasticstack.domain.Drive;
import org.jclouds.elasticstack.functions.ListOfMapsToListOfKeyValuesDelimitedByBlankLines;
import org.jclouds.http.HttpRequest;
import org.jclouds.rest.Binder;

@Singleton
public class BindDriveToPlainTextString
implements Binder {
    private final Function<Drive, Map<String, String>> createDriveRequestToMap;
    private final ListOfMapsToListOfKeyValuesDelimitedByBlankLines listOfMapsToListOfKeyValuesDelimitedByBlankLines;

    @Inject
    public BindDriveToPlainTextString(Function<Drive, Map<String, String>> createDriveRequestToMap, ListOfMapsToListOfKeyValuesDelimitedByBlankLines listOfMapsToListOfKeyValuesDelimitedByBlankLines) {
        this.createDriveRequestToMap = createDriveRequestToMap;
        this.listOfMapsToListOfKeyValuesDelimitedByBlankLines = listOfMapsToListOfKeyValuesDelimitedByBlankLines;
    }

    @Override
    public <R extends HttpRequest> R bindToRequest(R request, Object payload) {
        Preconditions.checkArgument(payload instanceof Drive, "this binder is only valid for Drive!");
        Drive create = (Drive)Drive.class.cast(payload);
        Map<String, String> map = this.createDriveRequestToMap.apply(create);
        request.setPayload(this.listOfMapsToListOfKeyValuesDelimitedByBlankLines.apply((Iterable<Map<String, String>>)ImmutableSet.of(map)));
        request.getPayload().getContentMetadata().setContentType("text/plain");
        return request;
    }
}

