/*
 * Decompiled with CFR 0.152.
 */
package net.schmizz.sshj.transport;

import java.util.concurrent.locks.Lock;
import net.schmizz.sshj.common.SSHPacket;
import net.schmizz.sshj.transport.Converter;
import net.schmizz.sshj.transport.cipher.Cipher;
import net.schmizz.sshj.transport.compression.Compression;
import net.schmizz.sshj.transport.mac.MAC;
import net.schmizz.sshj.transport.random.Random;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class Encoder
extends Converter {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final Random prng;
    private final Lock encodeLock;

    Encoder(Random prng, Lock encodeLock) {
        this.prng = prng;
        this.encodeLock = encodeLock;
    }

    private SSHPacket checkHeaderSpace(SSHPacket buffer) {
        if (buffer.rpos() < 5) {
            this.log.warn("Performance cost: when sending a packet, ensure that 5 bytes are available in front of the buffer");
            SSHPacket nb = new SSHPacket(buffer.available() + 5);
            nb.rpos(5);
            nb.wpos(5);
            nb.putBuffer(buffer);
            buffer = nb;
        }
        return buffer;
    }

    private void compress(SSHPacket buffer) {
        this.compression.compress(buffer);
    }

    private void putMAC(SSHPacket buffer, int startOfPacket, int endOfPadding) {
        buffer.wpos(endOfPadding + this.mac.getBlockSize());
        this.mac.update(this.seq);
        this.mac.update(buffer.array(), startOfPacket, endOfPadding);
        this.mac.doFinal(buffer.array(), endOfPadding);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long encode(SSHPacket buffer) {
        this.encodeLock.lock();
        try {
            int payloadSize;
            int padLen;
            if (this.log.isTraceEnabled()) {
                this.log.trace("Encoding packet #{}: {}", (Object)this.seq, (Object)buffer.printHex());
            }
            if (this.usingCompression()) {
                this.compress(buffer);
            }
            if ((padLen = -((payloadSize = buffer.available()) + 5) & this.cipherSize - 1) < this.cipherSize) {
                padLen += this.cipherSize;
            }
            int startOfPacket = buffer.rpos() - 5;
            int packetLen = payloadSize + 1 + padLen;
            buffer.wpos(startOfPacket);
            buffer.putUInt32(packetLen);
            buffer.putByte((byte)padLen);
            buffer.wpos(startOfPacket + 5 + payloadSize + padLen);
            this.prng.fill(buffer.array(), buffer.wpos() - padLen, padLen);
            this.seq = this.seq + 1L & 0xFFFFFFFFL;
            if (this.mac != null) {
                this.putMAC(buffer, startOfPacket, buffer.wpos());
            }
            this.cipher.update(buffer.array(), startOfPacket, 4 + packetLen);
            buffer.rpos(startOfPacket);
            long l = this.seq;
            return l;
        }
        finally {
            this.encodeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void setAlgorithms(Cipher cipher, MAC mac, Compression compression) {
        this.encodeLock.lock();
        try {
            super.setAlgorithms(cipher, mac, compression);
        }
        finally {
            this.encodeLock.unlock();
        }
    }

    @Override
    void setAuthenticated() {
        this.encodeLock.lock();
        try {
            super.setAuthenticated();
        }
        finally {
            this.encodeLock.unlock();
        }
    }

    @Override
    Compression.Mode getCompressionType() {
        return Compression.Mode.DEFLATE;
    }
}

