/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.gogrid.binders;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMultimap;
import org.jclouds.gogrid.domain.IpPortPair;
import org.jclouds.http.HttpRequest;
import org.jclouds.rest.Binder;

public class BindVirtualIpPortPairToQueryParams
implements Binder {
    @Override
    public <R extends HttpRequest> R bindToRequest(R request, Object input) {
        Preconditions.checkArgument(Preconditions.checkNotNull(input, "input is null") instanceof IpPortPair, "this binder is only valid for a IpPortPair argument");
        IpPortPair ipPortPair = (IpPortPair)input;
        Preconditions.checkNotNull(ipPortPair.getIp(), "There must be an IP address defined");
        Preconditions.checkNotNull(ipPortPair.getIp().getIp(), "There must be an IP address defined in Ip object");
        Preconditions.checkState(ipPortPair.getPort() > 0, "The port number must be a positive integer");
        ImmutableMultimap.Builder<String, String> builder = ImmutableMultimap.builder();
        builder.put("virtualip.ip", ipPortPair.getIp().getIp());
        builder.put("virtualip.port", String.valueOf(ipPortPair.getPort()));
        return (R)((HttpRequest.Builder)((HttpRequest.Builder)request.toBuilder()).replaceQueryParams(builder.build())).build();
    }
}

