/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.scriptbuilder.statements.login;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.File;
import java.util.Arrays;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.scriptbuilder.statements.login.AdminAccess;

public class AdminAccessBuilderSpec {
    protected static final Splitter KEYS_SPLITTER = Splitter.on(',').trimResults();
    protected static final Splitter KEY_VALUE_SPLITTER = Splitter.on('=').trimResults();
    protected static final ImmutableMap<String, ValueParser> VALUE_PARSERS = ImmutableMap.builder().put("adminUsername", new AdminUserNameParser()).put("adminHome", (AdminUserNameParser)((Object)new AdminHomeParser())).put("adminPublicKeyFile", (AdminUserNameParser)((Object)new AdminPublicKeyFileParser())).put("adminPrivateKeyFile", (AdminUserNameParser)((Object)new AdminPrivateKeyFileParser())).put("adminPassword", (AdminUserNameParser)((Object)new AdminPasswordParser())).put("loginPassword", (AdminUserNameParser)((Object)new LoginPasswordParser())).put("lockSsh", (AdminUserNameParser)((Object)new LockSshParser())).put("grantSudoToAdminUser", (AdminUserNameParser)((Object)new GrantSudoToAdminUserParser())).put("authorizeAdminPublicKey", (AdminUserNameParser)((Object)new AuthorizeAdminPublicKeyParser())).put("installAdminPrivateKey", (AdminUserNameParser)((Object)new InstallAdminPrivateKeyParser())).put("resetLoginPassword", (AdminUserNameParser)((Object)new ResetLoginPasswordParser())).build();
    @VisibleForTesting
    String adminUsername;
    @VisibleForTesting
    String adminHome;
    @VisibleForTesting
    File adminPublicKeyFile;
    @VisibleForTesting
    File adminPrivateKeyFile;
    @VisibleForTesting
    String adminPassword;
    @VisibleForTesting
    String loginPassword;
    @VisibleForTesting
    Boolean lockSsh;
    @VisibleForTesting
    Boolean grantSudoToAdminUser;
    @VisibleForTesting
    Boolean authorizeAdminPublicKey;
    @VisibleForTesting
    Boolean installAdminPrivateKey;
    @VisibleForTesting
    Boolean resetLoginPassword;
    protected transient String[] specifications;

    protected AdminAccessBuilderSpec() {
    }

    protected AdminAccessBuilderSpec(String ... specifications) {
        this.specifications = specifications;
    }

    public static AdminAccessBuilderSpec parse(String adminAccessSpecification) {
        AdminAccessBuilderSpec spec = new AdminAccessBuilderSpec(adminAccessSpecification);
        if (!adminAccessSpecification.isEmpty()) {
            for (String keyValuePair : KEYS_SPLITTER.split(adminAccessSpecification)) {
                ImmutableList<String> keyAndValue = ImmutableList.copyOf(KEY_VALUE_SPLITTER.split(keyValuePair));
                Preconditions.checkArgument(!keyAndValue.isEmpty(), "blank key-value pair");
                Preconditions.checkArgument(keyAndValue.size() <= 2, "key-value pair %s with more than one equals sign", keyValuePair);
                String key = (String)keyAndValue.get(0);
                ValueParser valueParser = VALUE_PARSERS.get(key);
                Preconditions.checkArgument(valueParser != null, "unknown key %s", key);
                String value = keyAndValue.size() == 1 ? null : (String)keyAndValue.get(1);
                valueParser.parse(spec, key, value);
            }
        }
        return spec;
    }

    public AdminAccess.Builder copyTo(AdminAccess.Builder builder) {
        if (this.adminUsername != null) {
            builder.adminUsername(this.adminUsername);
        }
        if (this.adminHome != null) {
            builder.adminHome(this.adminHome);
        }
        if (this.adminPublicKeyFile != null) {
            builder.adminPublicKey(this.adminPublicKeyFile);
        }
        if (this.adminPrivateKeyFile != null) {
            builder.adminPrivateKey(this.adminPrivateKeyFile);
        }
        if (this.adminPassword != null) {
            builder.adminPassword(this.adminPassword);
        }
        if (this.loginPassword != null) {
            builder.loginPassword(this.loginPassword);
        }
        if (this.lockSsh != null) {
            builder.lockSsh(this.lockSsh);
        }
        if (this.grantSudoToAdminUser != null) {
            builder.grantSudoToAdminUser(this.grantSudoToAdminUser);
        }
        if (this.authorizeAdminPublicKey != null) {
            builder.authorizeAdminPublicKey(this.authorizeAdminPublicKey);
        }
        if (this.installAdminPrivateKey != null) {
            builder.installAdminPrivateKey(this.installAdminPrivateKey);
        }
        if (this.resetLoginPassword != null) {
            builder.resetLoginPassword(this.resetLoginPassword);
        }
        return builder;
    }

    public String[] toParsableStrings() {
        return this.specifications;
    }

    public String toString() {
        return Objects.toStringHelper(this).addValue(Arrays.toString(this.toParsableStrings())).toString();
    }

    public int hashCode() {
        return Objects.hashCode(this.adminUsername, this.adminHome, this.adminPublicKeyFile, this.adminPrivateKeyFile, this.adminPassword, this.loginPassword, this.lockSsh, this.grantSudoToAdminUser, this.authorizeAdminPublicKey, this.installAdminPrivateKey, this.resetLoginPassword);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof AdminAccessBuilderSpec)) {
            return false;
        }
        AdminAccessBuilderSpec that = (AdminAccessBuilderSpec)obj;
        return Objects.equal(this.adminUsername, that.adminUsername) && Objects.equal(this.adminHome, that.adminHome) && Objects.equal(this.adminPublicKeyFile, that.adminPublicKeyFile) && Objects.equal(this.adminPrivateKeyFile, that.adminPrivateKeyFile) && Objects.equal(this.adminPassword, that.adminPassword) && Objects.equal(this.loginPassword, that.loginPassword) && Objects.equal(this.lockSsh, that.lockSsh) && Objects.equal(this.grantSudoToAdminUser, that.grantSudoToAdminUser) && Objects.equal(this.installAdminPrivateKey, that.installAdminPrivateKey) && Objects.equal(this.resetLoginPassword, that.resetLoginPassword);
    }

    public String getAdminUsername() {
        return this.adminUsername;
    }

    public String getAdminHome() {
        return this.adminHome;
    }

    public File getAdminPublicKeyFile() {
        return this.adminPublicKeyFile;
    }

    public File getAdminPrivateKeyFile() {
        return this.adminPrivateKeyFile;
    }

    public String getAdminPassword() {
        return this.adminPassword;
    }

    public String getLoginPassword() {
        return this.loginPassword;
    }

    public Boolean getLockSsh() {
        return this.lockSsh;
    }

    public Boolean getGrantSudoToAdminUser() {
        return this.grantSudoToAdminUser;
    }

    public Boolean getInstallAdminPrivateKey() {
        return this.installAdminPrivateKey;
    }

    public Boolean getResetLoginPassword() {
        return this.resetLoginPassword;
    }

    static class ResetLoginPasswordParser
    extends BooleanParser {
        ResetLoginPasswordParser() {
        }

        @Override
        protected void parseBoolean(AdminAccessBuilderSpec spec, boolean value) {
            Preconditions.checkArgument(spec.resetLoginPassword == null, "reset login password was already set to ", spec.resetLoginPassword);
            spec.resetLoginPassword = value;
        }
    }

    static class InstallAdminPrivateKeyParser
    extends BooleanParser {
        InstallAdminPrivateKeyParser() {
        }

        @Override
        protected void parseBoolean(AdminAccessBuilderSpec spec, boolean value) {
            Preconditions.checkArgument(spec.installAdminPrivateKey == null, "install admin private key was already set to ", spec.installAdminPrivateKey);
            spec.installAdminPrivateKey = value;
        }
    }

    static class AuthorizeAdminPublicKeyParser
    extends BooleanParser {
        AuthorizeAdminPublicKeyParser() {
        }

        @Override
        protected void parseBoolean(AdminAccessBuilderSpec spec, boolean value) {
            Preconditions.checkArgument(spec.authorizeAdminPublicKey == null, "authorize admin public key was already set to ", spec.authorizeAdminPublicKey);
            spec.authorizeAdminPublicKey = value;
        }
    }

    static class GrantSudoToAdminUserParser
    extends BooleanParser {
        GrantSudoToAdminUserParser() {
        }

        @Override
        protected void parseBoolean(AdminAccessBuilderSpec spec, boolean value) {
            Preconditions.checkArgument(spec.grantSudoToAdminUser == null, "grant sudo to admin user was already set to ", spec.grantSudoToAdminUser);
            spec.grantSudoToAdminUser = value;
        }
    }

    static class LockSshParser
    extends BooleanParser {
        LockSshParser() {
        }

        @Override
        protected void parseBoolean(AdminAccessBuilderSpec spec, boolean value) {
            Preconditions.checkArgument(spec.loginPassword == null, "lockSsh was already set to ", spec.lockSsh);
            spec.lockSsh = value;
        }
    }

    static class LoginPasswordParser
    extends StringParser {
        LoginPasswordParser() {
        }

        @Override
        protected void set(AdminAccessBuilderSpec spec, String value) {
            Preconditions.checkArgument(spec.loginPassword == null, "login password was already set to ", spec.loginPassword);
            spec.loginPassword = value;
        }
    }

    static class AdminPasswordParser
    extends StringParser {
        AdminPasswordParser() {
        }

        @Override
        protected void set(AdminAccessBuilderSpec spec, String value) {
            Preconditions.checkArgument(spec.adminPassword == null, "admin password was already set to ", spec.adminPassword);
            spec.adminPassword = value;
        }
    }

    static class AdminPrivateKeyFileParser
    extends FileParser {
        AdminPrivateKeyFileParser() {
        }

        @Override
        protected void set(AdminAccessBuilderSpec spec, File value) {
            Preconditions.checkArgument(spec.adminPrivateKeyFile == null, "admin private key file was already set to ", spec.adminPrivateKeyFile);
            spec.adminPrivateKeyFile = value;
        }
    }

    static class AdminPublicKeyFileParser
    extends FileParser {
        AdminPublicKeyFileParser() {
        }

        @Override
        protected void set(AdminAccessBuilderSpec spec, File value) {
            Preconditions.checkArgument(spec.adminPublicKeyFile == null, "admin public key file was already set to ", spec.adminPublicKeyFile);
            spec.adminPublicKeyFile = value;
        }
    }

    static class AdminHomeParser
    extends StringParser {
        AdminHomeParser() {
        }

        @Override
        protected void set(AdminAccessBuilderSpec spec, String value) {
            Preconditions.checkArgument(spec.adminHome == null, "admin home was already set to ", spec.adminHome);
            spec.adminHome = value;
        }
    }

    static class AdminUserNameParser
    extends StringParser {
        AdminUserNameParser() {
        }

        @Override
        protected void set(AdminAccessBuilderSpec spec, String value) {
            Preconditions.checkArgument(spec.adminUsername == null, "admin username was already set to ", spec.adminUsername);
            spec.adminUsername = value;
        }
    }

    static abstract class FileParser
    implements ValueParser {
        FileParser() {
        }

        protected abstract void set(AdminAccessBuilderSpec var1, File var2);

        @Override
        public void parse(AdminAccessBuilderSpec spec, String key, String value) {
            Preconditions.checkArgument(value != null && !value.isEmpty(), "value of key %s omitted", key);
            File file = new File(value);
            if (!file.exists()) {
                throw new IllegalArgumentException(String.format("key %s value set to %s, must be an existing file", key, value));
            }
            this.set(spec, file);
        }
    }

    static abstract class BooleanParser
    implements ValueParser {
        BooleanParser() {
        }

        protected abstract void parseBoolean(AdminAccessBuilderSpec var1, boolean var2);

        @Override
        public void parse(AdminAccessBuilderSpec spec, String key, String value) {
            Preconditions.checkArgument(value != null && !value.isEmpty(), "value of key %s omitted", key);
            try {
                this.parseBoolean(spec, Boolean.parseBoolean(value));
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException(String.format("key %s value set to %s, must be booleans", key, value), e);
            }
        }
    }

    static abstract class StringParser
    implements ValueParser {
        StringParser() {
        }

        protected abstract void set(AdminAccessBuilderSpec var1, String var2);

        @Override
        public void parse(AdminAccessBuilderSpec spec, String key, String value) {
            Preconditions.checkArgument(value != null && !value.isEmpty(), "value of key %s omitted", key);
            this.set(spec, value);
        }
    }

    protected static interface ValueParser {
        public void parse(AdminAccessBuilderSpec var1, String var2, @Nullable String var3);
    }
}

