/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.aws.ec2.functions;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import javax.annotation.Resource;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.aws.ec2.AWSEC2Api;
import org.jclouds.aws.ec2.domain.RegionNameAndPublicKeyMaterial;
import org.jclouds.ec2.domain.KeyPair;
import org.jclouds.logging.Logger;
import org.jclouds.ssh.SshKeys;

@Singleton
public class ImportOrReturnExistingKeypair
implements Function<RegionNameAndPublicKeyMaterial, KeyPair> {
    @Resource
    @Named(value="jclouds.compute")
    protected Logger logger = Logger.NULL;
    protected final AWSEC2Api ec2Api;

    @Inject
    public ImportOrReturnExistingKeypair(AWSEC2Api ec2Api) {
        this.ec2Api = ec2Api;
    }

    @Override
    public KeyPair apply(RegionNameAndPublicKeyMaterial from) {
        return this.importOrReturnExistingKeypair(from.getRegion(), from.getName(), from.getPublicKeyMaterial());
    }

    @VisibleForTesting
    KeyPair importOrReturnExistingKeypair(String region, String group, String publicKeyMaterial) {
        Preconditions.checkNotNull(region, "region");
        Preconditions.checkNotNull(group, "group");
        Preconditions.checkNotNull(publicKeyMaterial, "publicKeyMaterial");
        this.logger.debug(">> importing keyPair region(%s) group(%s)", region, group);
        KeyPair keyPair = null;
        while (keyPair == null) {
            try {
                keyPair = this.ec2Api.getKeyPairApi().get().importKeyPairInRegion(region, "jclouds#" + group, publicKeyMaterial);
                keyPair = this.addFingerprintToKeyPair(publicKeyMaterial, keyPair);
                this.logger.debug("<< imported keyPair(%s)", keyPair);
            }
            catch (IllegalStateException e) {
                keyPair = Iterables.getFirst(this.ec2Api.getKeyPairApi().get().describeKeyPairsInRegion(region, "jclouds#" + group), null);
                if (keyPair == null) continue;
                keyPair = this.addFingerprintToKeyPair(publicKeyMaterial, keyPair);
                this.logger.debug("<< retrieved existing keyPair(%s)", keyPair);
            }
        }
        return keyPair;
    }

    public KeyPair addFingerprintToKeyPair(String publicKeyMaterial, KeyPair keyPair) {
        keyPair = keyPair.toBuilder().fingerprint(SshKeys.fingerprintPublicKey(publicKeyMaterial)).build();
        return keyPair;
    }
}

