/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.joyent.cloudapi.v6_5.domain;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ComparisonChain;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.Map;
import javax.inject.Named;
import org.jclouds.domain.JsonBall;
import org.jclouds.joyent.cloudapi.v6_5.domain.Machine;

public class Dataset
implements Comparable<Dataset> {
    private final String id;
    private final String name;
    private final String os;
    private final String urn;
    private final Machine.Type type;
    private final String description;
    @Named(value="default")
    private final boolean isDefault;
    private final Map<String, JsonBall> requirements;
    private final String version;
    private final Date created;
    @VisibleForTesting
    static final Function<JsonBall, String> unquoteString = new Function<JsonBall, String>(){

        @Override
        public String apply(JsonBall input) {
            String value = input.toString();
            if (value.length() >= 2 && value.charAt(0) == '\"' && value.charAt(input.length() - 1) == '\"') {
                return value.substring(1, input.length() - 1);
            }
            return value;
        }
    };

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().fromDataset(this);
    }

    @ConstructorProperties(value={"id", "urn", "name", "os", "type", "description", "default", "requirements", "version", "created"})
    public Dataset(String id, String urn, String name, String os, Machine.Type type, String description, boolean isDefault, Map<String, JsonBall> requirements, String version, Date created) {
        this.id = Preconditions.checkNotNull(id, "id");
        this.urn = Preconditions.checkNotNull(urn, "urn of dataset(%s)", id);
        this.name = Preconditions.checkNotNull(name, "name of dataset(%s)", id);
        this.os = Preconditions.checkNotNull(os, "os of dataset(%s)", id);
        this.type = Preconditions.checkNotNull(type, "type of dataset(%s)", id);
        this.description = Preconditions.checkNotNull(description, "description of dataset(%s)", id);
        this.isDefault = isDefault;
        this.requirements = ImmutableMap.copyOf(Preconditions.checkNotNull(requirements, "requirements of dataset(%s)", id));
        this.version = Preconditions.checkNotNull(version, "version of dataset(%s)", id);
        this.created = Preconditions.checkNotNull(created, "created of dataset(%s)", id);
    }

    public String getId() {
        return this.id;
    }

    public String getUrn() {
        return this.urn;
    }

    public String getName() {
        return this.name;
    }

    public String getOs() {
        return this.os;
    }

    public Machine.Type getType() {
        return this.type;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean isDefault() {
        return this.isDefault;
    }

    public Map<String, String> getRequirementsAsJsonLiterals() {
        return Maps.transformValues(this.requirements, Functions.toStringFunction());
    }

    public Map<String, String> getRequirements() {
        return Maps.transformValues(this.requirements, Functions.compose(Functions.toStringFunction(), unquoteString));
    }

    public String getVersion() {
        return this.version;
    }

    public Date getCreated() {
        return this.created;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof Dataset) {
            Dataset that = (Dataset)Dataset.class.cast(object);
            return Objects.equal(this.id, that.id);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode(this.id);
    }

    public String toString() {
        return Objects.toStringHelper("").omitNullValues().add("id", this.id).add("urn", this.urn).add("name", this.name).add("os", this.os).add("type", (Object)this.type).add("description", this.description).add("default", this.isDefault).add("requirements", this.requirements).add("version", this.version).add("created", this.created).toString();
    }

    @Override
    public int compareTo(Dataset that) {
        return ComparisonChain.start().compare((Comparable<?>)((Object)this.urn), (Comparable<?>)((Object)that.urn)).compare((Comparable<?>)((Object)this.name), (Comparable<?>)((Object)that.name)).compare((Comparable<?>)((Object)this.os), (Comparable<?>)((Object)that.os)).compare((Comparable<?>)((Object)this.type), (Comparable<?>)((Object)that.type)).compare((Comparable<?>)((Object)this.description), (Comparable<?>)((Object)that.description)).compare((Comparable<?>)((Object)this.version), (Comparable<?>)((Object)that.version)).compare(this.created, that.created).compare((Comparable<?>)((Object)this.id), (Comparable<?>)((Object)that.id)).result();
    }

    public static class Builder {
        private String id;
        private String urn;
        private String name;
        private String os;
        private Machine.Type type;
        private String description;
        private boolean isDefault;
        private ImmutableMap.Builder<String, JsonBall> requirements = ImmutableMap.builder();
        private String version;
        private Date created;

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder urn(String urn) {
            this.urn = urn;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder os(String os) {
            this.os = os;
            return this;
        }

        public Builder type(Machine.Type type) {
            this.type = type;
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder isDefault(boolean isDefault) {
            this.isDefault = isDefault;
            return this;
        }

        public Builder requirements(Map<String, JsonBall> requirements) {
            this.requirements = ImmutableMap.builder();
            this.requirements.putAll(Preconditions.checkNotNull(requirements, "requirements"));
            return this;
        }

        public Builder addRequirement(String name, JsonBall values) {
            this.requirements.put(Preconditions.checkNotNull(name, "name"), Preconditions.checkNotNull(values, "value of %s", name));
            return this;
        }

        public Builder version(String version) {
            this.version = version;
            return this;
        }

        public Builder created(Date created) {
            this.created = created;
            return this;
        }

        public Dataset build() {
            return new Dataset(this.id, this.urn, this.name, this.os, this.type, this.description, this.isDefault, this.requirements.build(), this.version, this.created);
        }

        public Builder fromDataset(Dataset in) {
            return this.id(in.getId()).urn(in.getUrn()).name(in.getName()).os(in.getOs()).type(in.getType()).description(in.getDescription()).isDefault(in.isDefault()).requirements(in.requirements).version(in.getVersion()).created(in.getCreated());
        }
    }
}

