/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.nova.v2_0.compute;

import com.google.common.base.Function;
import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Supplier;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import javax.inject.Inject;
import javax.inject.Named;
import org.jclouds.compute.ComputeServiceAdapter;
import org.jclouds.compute.domain.Template;
import org.jclouds.compute.util.ComputeServiceUtils;
import org.jclouds.domain.Location;
import org.jclouds.domain.LoginCredentials;
import org.jclouds.location.Region;
import org.jclouds.logging.Logger;
import org.jclouds.openstack.nova.v2_0.NovaApi;
import org.jclouds.openstack.nova.v2_0.compute.functions.RemoveFloatingIpFromNodeAndDeallocate;
import org.jclouds.openstack.nova.v2_0.compute.options.NovaTemplateOptions;
import org.jclouds.openstack.nova.v2_0.domain.Flavor;
import org.jclouds.openstack.nova.v2_0.domain.Image;
import org.jclouds.openstack.nova.v2_0.domain.KeyPair;
import org.jclouds.openstack.nova.v2_0.domain.RebootType;
import org.jclouds.openstack.nova.v2_0.domain.Server;
import org.jclouds.openstack.nova.v2_0.domain.ServerCreated;
import org.jclouds.openstack.nova.v2_0.domain.regionscoped.FlavorInRegion;
import org.jclouds.openstack.nova.v2_0.domain.regionscoped.ImageInRegion;
import org.jclouds.openstack.nova.v2_0.domain.regionscoped.RegionAndId;
import org.jclouds.openstack.nova.v2_0.domain.regionscoped.RegionAndName;
import org.jclouds.openstack.nova.v2_0.domain.regionscoped.ServerInRegion;
import org.jclouds.openstack.nova.v2_0.options.CreateServerOptions;
import org.jclouds.openstack.nova.v2_0.predicates.ImagePredicates;
import org.jclouds.util.Predicates2;

public class NovaComputeServiceAdapter
implements ComputeServiceAdapter<ServerInRegion, FlavorInRegion, ImageInRegion, Location> {
    @Resource
    @Named(value="jclouds.compute")
    protected Logger logger = Logger.NULL;
    protected final NovaApi novaApi;
    protected final Supplier<Set<String>> regionIds;
    protected final RemoveFloatingIpFromNodeAndDeallocate removeFloatingIpFromNodeAndDeallocate;
    protected final LoadingCache<RegionAndName, KeyPair> keyPairCache;

    @Inject
    public NovaComputeServiceAdapter(NovaApi novaApi, @Region Supplier<Set<String>> regionIds, RemoveFloatingIpFromNodeAndDeallocate removeFloatingIpFromNodeAndDeallocate, LoadingCache<RegionAndName, KeyPair> keyPairCache) {
        this.novaApi = Preconditions.checkNotNull(novaApi, "novaApi");
        this.regionIds = Preconditions.checkNotNull(regionIds, "regionIds");
        this.removeFloatingIpFromNodeAndDeallocate = Preconditions.checkNotNull(removeFloatingIpFromNodeAndDeallocate, "removeFloatingIpFromNodeAndDeallocate");
        this.keyPairCache = Preconditions.checkNotNull(keyPairCache, "keyPairCache");
    }

    @Override
    public ComputeServiceAdapter.NodeAndInitialCredentials<ServerInRegion> createNodeWithGroupEncodedIntoName(String group, String name, Template template) {
        LoginCredentials.Builder credentialsBuilder = LoginCredentials.builder();
        NovaTemplateOptions templateOptions = template.getOptions().as(NovaTemplateOptions.class);
        CreateServerOptions options = new CreateServerOptions();
        options.metadata(ComputeServiceUtils.metadataAndTagsAsCommaDelimitedValue(template.getOptions()));
        if (!templateOptions.getGroups().isEmpty()) {
            options.securityGroupNames(templateOptions.getGroups());
        }
        options.userData(templateOptions.getUserData());
        options.diskConfig(templateOptions.getDiskConfig());
        options.configDrive(templateOptions.getConfigDrive());
        options.availabilityZone(templateOptions.getAvailabilityZone());
        if (templateOptions.getNovaNetworks() != null) {
            options.novaNetworks(templateOptions.getNovaNetworks());
        }
        if (templateOptions.getNetworks() != null) {
            options.networks(templateOptions.getNetworks());
        }
        Optional<Object> privateKey = Optional.absent();
        if (templateOptions.getKeyPairName() != null) {
            options.keyPairName(templateOptions.getKeyPairName());
            KeyPair keyPair = (KeyPair)this.keyPairCache.getIfPresent(RegionAndName.fromRegionAndName(template.getLocation().getId(), templateOptions.getKeyPairName()));
            if (keyPair != null && keyPair.getPrivateKey() != null) {
                privateKey = Optional.of(keyPair.getPrivateKey());
                credentialsBuilder.privateKey((String)privateKey.get());
            }
        }
        final String regionId = template.getLocation().getId();
        String imageId = template.getImage().getProviderId();
        String flavorId = template.getHardware().getProviderId();
        this.logger.debug(">> creating new server region(%s) name(%s) image(%s) flavor(%s) options(%s)", regionId, name, imageId, flavorId, options);
        ServerCreated lightweightServer = this.novaApi.getServerApi(regionId).create(name, imageId, flavorId, options);
        if (!Predicates2.retry(new Predicate<String>(){

            @Override
            public boolean apply(String serverId) {
                Server server = NovaComputeServiceAdapter.this.novaApi.getServerApi(regionId).get(serverId);
                return server != null && server.getAddresses() != null && !server.getAddresses().isEmpty();
            }
        }, 1800L, 1L, TimeUnit.SECONDS).apply(lightweightServer.getId())) {
            String message = String.format("Server %s was not created within %sms so it will be destroyed.", name, "30 * 60");
            this.logger.warn(message, new Object[0]);
            this.destroyNode(lightweightServer.getId());
            throw new IllegalStateException(message);
        }
        this.logger.trace("<< server(%s)", lightweightServer.getId());
        Server server = this.novaApi.getServerApi(regionId).get(lightweightServer.getId());
        ServerInRegion serverInRegion = new ServerInRegion(server, regionId);
        if (!privateKey.isPresent() && lightweightServer.getAdminPass().isPresent()) {
            credentialsBuilder.password(lightweightServer.getAdminPass().get());
        }
        return new ComputeServiceAdapter.NodeAndInitialCredentials<ServerInRegion>(serverInRegion, serverInRegion.slashEncode(), credentialsBuilder.build());
    }

    @Override
    public Iterable<FlavorInRegion> listHardwareProfiles() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (final String regionId : this.regionIds.get()) {
            builder.addAll(Iterables.transform(this.novaApi.getFlavorApi(regionId).listInDetail().concat(), new Function<Flavor, FlavorInRegion>(){

                @Override
                public FlavorInRegion apply(Flavor arg0) {
                    return new FlavorInRegion(arg0, regionId);
                }
            }));
        }
        return builder.build();
    }

    @Override
    public Iterable<ImageInRegion> listImages() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        Set<String> regions = this.regionIds.get();
        Preconditions.checkState(!regions.isEmpty(), "no regions found in supplier %s", this.regionIds);
        for (final String regionId : regions) {
            ImmutableSet<Image> images = this.novaApi.getImageApi(regionId).listInDetail().concat().toSet();
            if (images.isEmpty()) {
                this.logger.debug("no images found in region %s", regionId);
                continue;
            }
            Iterable<Image> active = Iterables.filter(images, ImagePredicates.statusEquals(Image.Status.ACTIVE));
            if (images.isEmpty()) {
                this.logger.debug("no images with status active in region %s; non-active: %s", regionId, Iterables.transform(active, new Function<Image, String>(){

                    @Override
                    public String apply(Image input) {
                        return Objects.toStringHelper("").add("id", input.getId()).add("status", (Object)input.getStatus()).toString();
                    }
                }));
                continue;
            }
            builder.addAll(Iterables.transform(active, new Function<Image, ImageInRegion>(){

                @Override
                public ImageInRegion apply(Image arg0) {
                    return new ImageInRegion(arg0, regionId);
                }
            }));
        }
        return builder.build();
    }

    @Override
    public Iterable<ServerInRegion> listNodes() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (final String regionId : this.regionIds.get()) {
            builder.addAll(this.novaApi.getServerApi(regionId).listInDetail().concat().transform(new Function<Server, ServerInRegion>(){

                @Override
                public ServerInRegion apply(Server arg0) {
                    return new ServerInRegion(arg0, regionId);
                }
            }));
        }
        return builder.build();
    }

    @Override
    public Iterable<ServerInRegion> listNodesByIds(final Iterable<String> ids) {
        return Iterables.filter(this.listNodes(), new Predicate<ServerInRegion>(){

            @Override
            public boolean apply(ServerInRegion server) {
                return Iterables.contains(ids, server.slashEncode());
            }
        });
    }

    @Override
    public Iterable<Location> listLocations() {
        return ImmutableSet.of();
    }

    @Override
    public ServerInRegion getNode(String id) {
        RegionAndId regionAndId = RegionAndId.fromSlashEncoded(id);
        Server server = this.novaApi.getServerApi(regionAndId.getRegion()).get(regionAndId.getId());
        return server == null ? null : new ServerInRegion(server, regionAndId.getRegion());
    }

    @Override
    public ImageInRegion getImage(String id) {
        RegionAndId regionAndId = RegionAndId.fromSlashEncoded(id);
        Image image = this.novaApi.getImageApi(regionAndId.getRegion()).get(regionAndId.getId());
        return image == null ? null : new ImageInRegion(image, regionAndId.getRegion());
    }

    @Override
    public void destroyNode(String id) {
        RegionAndId regionAndId = RegionAndId.fromSlashEncoded(id);
        if (this.novaApi.getFloatingIPApi(regionAndId.getRegion()).isPresent()) {
            try {
                this.removeFloatingIpFromNodeAndDeallocate.apply(regionAndId);
            }
            catch (RuntimeException e) {
                this.logger.warn(e, "<< error removing and deallocating ip from node(%s): %s", id, e.getMessage());
            }
        }
        this.novaApi.getServerApi(regionAndId.getRegion()).delete(regionAndId.getId());
    }

    @Override
    public void rebootNode(String id) {
        RegionAndId regionAndId = RegionAndId.fromSlashEncoded(id);
        this.novaApi.getServerApi(regionAndId.getRegion()).reboot(regionAndId.getId(), RebootType.HARD);
    }

    @Override
    public void resumeNode(String id) {
        RegionAndId regionAndId = RegionAndId.fromSlashEncoded(id);
        if (!this.novaApi.getServerAdminApi(regionAndId.getRegion()).isPresent()) {
            throw new UnsupportedOperationException("resume requires installation of the Admin Actions extension");
        }
        this.novaApi.getServerAdminApi(regionAndId.getRegion()).get().resume(regionAndId.getId());
    }

    @Override
    public void suspendNode(String id) {
        RegionAndId regionAndId = RegionAndId.fromSlashEncoded(id);
        if (!this.novaApi.getServerAdminApi(regionAndId.getRegion()).isPresent()) {
            throw new UnsupportedOperationException("suspend requires installation of the Admin Actions extension");
        }
        this.novaApi.getServerAdminApi(regionAndId.getRegion()).get().suspend(regionAndId.getId());
    }
}

