/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.binders;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMultimap;
import javax.inject.Singleton;
import org.jclouds.cloudstack.domain.SnapshotPolicySchedule;
import org.jclouds.http.HttpRequest;
import org.jclouds.rest.Binder;

@Singleton
public class BindSnapshotPolicyScheduleToQueryParam
implements Binder {
    @Override
    public <R extends HttpRequest> R bindToRequest(R request, Object input) {
        Preconditions.checkArgument(input instanceof SnapshotPolicySchedule, "this binder is only valid for SnapshotPolicySchedule");
        SnapshotPolicySchedule schedule = (SnapshotPolicySchedule)SnapshotPolicySchedule.class.cast(input);
        ImmutableMultimap.Builder<String, String> builder = ImmutableMultimap.builder();
        builder.put("intervaltype", schedule.getInterval().toString());
        builder.put("schedule", schedule.getTime().toString());
        return (R)((HttpRequest.Builder)((HttpRequest.Builder)request.toBuilder()).replaceQueryParams(builder.build())).build();
    }
}

