/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.options;

import com.google.common.collect.ImmutableSet;
import java.util.Map;
import org.jclouds.cloudstack.options.AssociateIPAddressOptions;

public class ListSecurityGroupsOptions
extends AssociateIPAddressOptions {
    public static final ListSecurityGroupsOptions NONE = new ListSecurityGroupsOptions();

    public ListSecurityGroupsOptions id(String id) {
        this.queryParameters.replaceValues("id", ImmutableSet.of(id + ""));
        return this;
    }

    public ListSecurityGroupsOptions named(String securityGroupName) {
        this.queryParameters.replaceValues("securitygroupname", ImmutableSet.of(securityGroupName));
        return this;
    }

    public ListSecurityGroupsOptions virtualMachineId(String virtualMachineId) {
        this.queryParameters.replaceValues("virtualmachineid", ImmutableSet.of(virtualMachineId + ""));
        return this;
    }

    @Override
    public ListSecurityGroupsOptions projectId(String projectId) {
        this.queryParameters.replaceValues("projectid", ImmutableSet.of(projectId + ""));
        return this;
    }

    public ListSecurityGroupsOptions tags(Map<String, String> tags) {
        int count = 0;
        for (Map.Entry<String, String> entry : tags.entrySet()) {
            this.queryParameters.replaceValues(String.format("tags[%d].key", count), ImmutableSet.of(entry.getKey()));
            this.queryParameters.replaceValues(String.format("tags[%d].value", count), ImmutableSet.of(entry.getValue()));
            ++count;
        }
        return this;
    }

    @Override
    public ListSecurityGroupsOptions accountInDomain(String account, String domain) {
        return (ListSecurityGroupsOptions)ListSecurityGroupsOptions.class.cast(super.accountInDomain(account, domain));
    }

    @Override
    public ListSecurityGroupsOptions domainId(String domainId) {
        return (ListSecurityGroupsOptions)ListSecurityGroupsOptions.class.cast(super.domainId(domainId));
    }

    public static class Builder {
        public static ListSecurityGroupsOptions named(String securityGroupName) {
            ListSecurityGroupsOptions options = new ListSecurityGroupsOptions();
            return options.named(securityGroupName);
        }

        public static ListSecurityGroupsOptions id(String id) {
            ListSecurityGroupsOptions options = new ListSecurityGroupsOptions();
            return options.id(id);
        }

        public static ListSecurityGroupsOptions virtualMachineId(String virtualMachineId) {
            ListSecurityGroupsOptions options = new ListSecurityGroupsOptions();
            return options.virtualMachineId(virtualMachineId);
        }

        public static ListSecurityGroupsOptions projectId(String projectId) {
            ListSecurityGroupsOptions options = new ListSecurityGroupsOptions();
            return options.projectId(projectId);
        }

        public static ListSecurityGroupsOptions accountInDomain(String account, String domain) {
            ListSecurityGroupsOptions options = new ListSecurityGroupsOptions();
            return options.accountInDomain(account, domain);
        }

        public static ListSecurityGroupsOptions domainId(String domainId) {
            ListSecurityGroupsOptions options = new ListSecurityGroupsOptions();
            return options.domainId(domainId);
        }

        public static ListSecurityGroupsOptions tags(Map<String, String> tags) {
            ListSecurityGroupsOptions options = new ListSecurityGroupsOptions();
            return options.tags(tags);
        }
    }
}

