/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.gogrid.compute.functions;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.annotation.Resource;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.collect.Memoized;
import org.jclouds.compute.domain.Hardware;
import org.jclouds.compute.domain.Image;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.compute.domain.NodeMetadataBuilder;
import org.jclouds.compute.functions.GroupNamingConvention;
import org.jclouds.domain.Location;
import org.jclouds.gogrid.domain.Server;
import org.jclouds.gogrid.domain.ServerState;
import org.jclouds.location.predicates.LocationPredicates;
import org.jclouds.logging.Logger;

@Singleton
public class ServerToNodeMetadata
implements Function<Server, NodeMetadata> {
    @Resource
    protected Logger logger = Logger.NULL;
    private final Map<ServerState, NodeMetadata.Status> serverStateToNodeStatus;
    private final Supplier<Set<? extends Image>> images;
    private final Supplier<Set<? extends Hardware>> hardwares;
    private final Supplier<Set<? extends Location>> locations;
    private final GroupNamingConvention nodeNamingConvention;

    @Inject
    ServerToNodeMetadata(Map<ServerState, NodeMetadata.Status> serverStateToNodeStatus, @Memoized Supplier<Set<? extends Image>> images, @Memoized Supplier<Set<? extends Hardware>> hardwares, @Memoized Supplier<Set<? extends Location>> locations, GroupNamingConvention.Factory namingConvention) {
        this.nodeNamingConvention = Preconditions.checkNotNull(namingConvention, "namingConvention").createWithoutPrefix();
        this.serverStateToNodeStatus = Preconditions.checkNotNull(serverStateToNodeStatus, "serverStateToNodeStatus");
        this.images = Preconditions.checkNotNull(images, "images");
        this.hardwares = Preconditions.checkNotNull(hardwares, "hardwares");
        this.locations = Preconditions.checkNotNull(locations, "locations");
    }

    @Override
    public NodeMetadata apply(Server from) {
        NodeMetadataBuilder builder = new NodeMetadataBuilder();
        builder.ids(from.getId() + "");
        builder.name(from.getName());
        Location location = Iterables.find((Iterable)this.locations.get(), LocationPredicates.idEquals(from.getDatacenter().getId() + ""));
        builder.location(location);
        builder.group(this.nodeNamingConvention.groupInUniqueNameOrNull(from.getName()));
        builder.hardware(this.parseHardware(from));
        builder.imageId(from.getImage().getId() + "");
        Image image = this.parseImage(from);
        if (image != null) {
            builder.operatingSystem(image.getOperatingSystem());
        }
        builder.status(this.serverStateToNodeStatus.get((Object)from.getState()));
        builder.publicAddresses(ImmutableSet.of(from.getIp().getIp()));
        return builder.build();
    }

    protected Image parseImage(Server from) {
        Image image = null;
        try {
            image = Iterables.find((Iterable)this.images.get(), new FindImageForServer(from));
        }
        catch (NoSuchElementException e) {
            this.logger.debug("could not find a matching image for server %s", from);
        }
        return image;
    }

    protected Hardware parseHardware(Server from) {
        Hardware hardware = null;
        try {
            hardware = Iterables.find((Iterable)this.hardwares.get(), new FindHardwareForServer(from));
        }
        catch (NoSuchElementException e) {
            this.logger.debug("could not find a matching hardware for server %s", from);
        }
        return hardware;
    }

    static class FindHardwareForServer
    implements Predicate<Hardware> {
        private final Server instance;

        @Inject
        private FindHardwareForServer(Server instance) {
            this.instance = instance;
        }

        @Override
        public boolean apply(Hardware input) {
            return input.getRam() == Integer.parseInt(this.instance.getRam().getName().replaceAll("[^0-9]", ""));
        }
    }

    static class FindImageForServer
    implements Predicate<Image> {
        private final Server instance;

        @Inject
        private FindImageForServer(Server instance) {
            this.instance = instance;
        }

        @Override
        public boolean apply(Image input) {
            return input.getProviderId().equals(this.instance.getImage().getId() + "") && (input.getLocation() == null || input.getLocation().getId().equals(this.instance.getDatacenter().getId() + ""));
        }
    }
}

