/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.gogrid.domain;

import com.google.common.base.Preconditions;

public enum JobState {
    QUEUED("Queued", "Change request is new to the system."),
    PROCESSING("Processing", "Change request is is transient state...Processing."),
    SUCCEEDED("Succeeded", "Change request has succeeded."),
    FAILED("Failed", "Change request has failed."),
    CANCELED("Canceled", "Change request has been canceled."),
    FATAL("Fatal", "Change request had Fatal or Unrecoverable Failure"),
    CREATED("Created", "Change request is created but not queued yet"),
    UNRECOGNIZED("Unknown", "The state is unknown to JClouds");

    String name;
    String description;

    private JobState(String name, String description) {
        this.name = name;
        this.description = description;
    }

    public String toString() {
        return this.name;
    }

    public static JobState fromValue(String state) {
        for (JobState jobState : JobState.values()) {
            if (!jobState.name.equals(Preconditions.checkNotNull(state))) continue;
            return jobState;
        }
        return UNRECOGNIZED;
    }
}

