/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.joyent.cloudapi.v6_5.features;

import java.util.Set;
import javax.inject.Named;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import org.jclouds.Fallbacks;
import org.jclouds.http.filters.BasicAuthentication;
import org.jclouds.joyent.cloudapi.v6_5.domain.Key;
import org.jclouds.rest.annotations.BinderParam;
import org.jclouds.rest.annotations.Fallback;
import org.jclouds.rest.annotations.Headers;
import org.jclouds.rest.annotations.RequestFilters;
import org.jclouds.rest.binders.BindToJsonPayload;

@Headers(keys={"X-Api-Version"}, values={"{jclouds.api-version}"})
@RequestFilters(value={BasicAuthentication.class})
@Path(value="/my/keys")
@Consumes(value={"application/json"})
public interface KeyApi {
    @Named(value="ListKeys")
    @GET
    @Fallback(value=Fallbacks.EmptySetOnNotFoundOr404.class)
    public Set<Key> list();

    @Named(value="GetKey")
    @GET
    @Path(value="/{name}")
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    public Key get(@PathParam(value="name") String var1);

    @Named(value="CreateKey")
    @POST
    public Key create(@BinderParam(value=BindToJsonPayload.class) Key var1);

    @Named(value="DeleteKey")
    @DELETE
    @Path(value="/{name}")
    @Fallback(value=Fallbacks.VoidOnNotFoundOr404.class)
    public void delete(@PathParam(value="name") String var1);
}

