/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.nova.v2_0.domain;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.beans.ConstructorProperties;
import javax.inject.Named;

public class TenantIdAndName {
    @Named(value="tenant_id")
    private final String tenantId;
    private final String name;

    public static Builder<?> builder() {
        return new ConcreteBuilder();
    }

    public Builder<?> toBuilder() {
        return new ConcreteBuilder().fromTenantIdAndName(this);
    }

    @ConstructorProperties(value={"tenant_id", "name"})
    protected TenantIdAndName(String tenantId, String name) {
        this.tenantId = Preconditions.checkNotNull(tenantId, "tenantId");
        this.name = Preconditions.checkNotNull(name, "name");
    }

    public String getTenantId() {
        return this.tenantId;
    }

    public String getName() {
        return this.name;
    }

    public int hashCode() {
        return Objects.hashCode(this.tenantId, this.name);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        TenantIdAndName that = (TenantIdAndName)TenantIdAndName.class.cast(obj);
        return Objects.equal(this.tenantId, that.tenantId) && Objects.equal(this.name, that.name);
    }

    protected Objects.ToStringHelper string() {
        return Objects.toStringHelper(this).add("tenantId", this.tenantId).add("name", this.name);
    }

    public String toString() {
        return this.string().toString();
    }

    private static class ConcreteBuilder
    extends Builder<ConcreteBuilder> {
        private ConcreteBuilder() {
        }

        @Override
        protected ConcreteBuilder self() {
            return this;
        }
    }

    public static abstract class Builder<T extends Builder<T>> {
        protected String tenantId;
        protected String name;

        protected abstract T self();

        public T tenantId(String tenantId) {
            this.tenantId = tenantId;
            return this.self();
        }

        public T name(String name) {
            this.name = name;
            return this.self();
        }

        public TenantIdAndName build() {
            return new TenantIdAndName(this.tenantId, this.name);
        }

        public T fromTenantIdAndName(TenantIdAndName in) {
            return ((Builder)this.tenantId(in.getTenantId())).name(in.getName());
        }
    }
}

