/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ec2.options;

import com.google.common.base.Preconditions;
import com.google.common.io.BaseEncoding;
import java.util.Set;
import org.jclouds.ec2.domain.BlockDeviceMapping;
import org.jclouds.ec2.options.internal.BaseEC2RequestOptions;

public class RunInstancesOptions
extends BaseEC2RequestOptions {
    public static final RunInstancesOptions NONE = new RunInstancesOptions();

    public RunInstancesOptions withKeyName(String keyName) {
        this.formParameters.put("KeyName", Preconditions.checkNotNull(keyName, "keyName"));
        return this;
    }

    public RunInstancesOptions withSecurityGroups(String ... securityGroups) {
        this.indexFormValuesWithPrefix("SecurityGroup", securityGroups);
        return this;
    }

    public RunInstancesOptions withSecurityGroups(Iterable<String> securityGroups) {
        this.indexFormValuesWithPrefix("SecurityGroup", securityGroups);
        return this;
    }

    public RunInstancesOptions withSecurityGroup(String securityGroup) {
        return this.withSecurityGroups(securityGroup);
    }

    public RunInstancesOptions withUserData(byte[] unencodedData) {
        int length = Preconditions.checkNotNull(unencodedData, "unencodedData").length;
        Preconditions.checkArgument(length > 0, "userData cannot be empty");
        Preconditions.checkArgument(length <= 16384, "userData cannot be larger than 16kb");
        this.formParameters.put("UserData", BaseEncoding.base64().encode(unencodedData));
        return this;
    }

    public RunInstancesOptions asType(String type) {
        this.formParameters.put("InstanceType", Preconditions.checkNotNull(type, "type"));
        return this;
    }

    public RunInstancesOptions withKernelId(String kernelId) {
        this.formParameters.put("KernelId", Preconditions.checkNotNull(kernelId, "kernelId"));
        return this;
    }

    public RunInstancesOptions withRamdisk(String ramDiskId) {
        this.formParameters.put("RamdiskId", Preconditions.checkNotNull(ramDiskId, "ramDiskId"));
        return this;
    }

    public RunInstancesOptions withBlockDeviceMappings(Set<? extends BlockDeviceMapping> mappings) {
        int i = 1;
        for (BlockDeviceMapping blockDeviceMapping : Preconditions.checkNotNull(mappings, "mappings")) {
            Preconditions.checkNotNull(blockDeviceMapping.getDeviceName(), "deviceName");
            this.formParameters.put(String.format("BlockDeviceMapping.%d.DeviceName", i), blockDeviceMapping.getDeviceName());
            if (blockDeviceMapping.getVirtualName() != null) {
                this.formParameters.put(String.format("BlockDeviceMapping.%d.VirtualName", i), blockDeviceMapping.getVirtualName());
            }
            if (blockDeviceMapping.getEbsSnapshotId() != null) {
                this.formParameters.put(String.format("BlockDeviceMapping.%d.Ebs.SnapshotId", i), blockDeviceMapping.getEbsSnapshotId());
            }
            if (blockDeviceMapping.getEbsVolumeSize() != null) {
                this.formParameters.put(String.format("BlockDeviceMapping.%d.Ebs.VolumeSize", i), String.valueOf(blockDeviceMapping.getEbsVolumeSize()));
            }
            if (blockDeviceMapping.getEbsNoDevice() != null) {
                this.formParameters.put(String.format("BlockDeviceMapping.%d.Ebs.NoDevice", i), String.valueOf(blockDeviceMapping.getEbsNoDevice()));
            }
            if (blockDeviceMapping.getEbsDeleteOnTermination() != null) {
                this.formParameters.put(String.format("BlockDeviceMapping.%d.Ebs.DeleteOnTermination", i), String.valueOf(blockDeviceMapping.getEbsDeleteOnTermination()));
            }
            if (blockDeviceMapping.getEbsVolumeType() != null) {
                this.formParameters.put(String.format("BlockDeviceMapping.%d.Ebs.VolumeType", i), blockDeviceMapping.getEbsVolumeType());
            }
            if (blockDeviceMapping.getEbsIops() != null) {
                this.formParameters.put(String.format("BlockDeviceMapping.%d.Ebs.Iops", i), String.valueOf(blockDeviceMapping.getEbsIops()));
            }
            if (blockDeviceMapping.getEbsEncrypted() != null && blockDeviceMapping.getEbsEncrypted().booleanValue()) {
                this.formParameters.put(String.format("BlockDeviceMapping.%d.Ebs.Encrypted", i), String.valueOf(blockDeviceMapping.getEbsEncrypted()));
            }
            ++i;
        }
        return this;
    }

    public RunInstancesOptions withClientToken(String clientToken) {
        this.formParameters.put("ClientToken", Preconditions.checkNotNull(clientToken, "clientToken"));
        return this;
    }

    public static class Builder {
        public static RunInstancesOptions withKeyName(String keyName) {
            RunInstancesOptions options = new RunInstancesOptions();
            return options.withKeyName(keyName);
        }

        public static RunInstancesOptions withSecurityGroup(String securityGroup) {
            RunInstancesOptions options = new RunInstancesOptions();
            return options.withSecurityGroup(securityGroup);
        }

        public static RunInstancesOptions withUserData(byte[] unencodedData) {
            RunInstancesOptions options = new RunInstancesOptions();
            return options.withUserData(unencodedData);
        }

        public static RunInstancesOptions asType(String instanceType) {
            RunInstancesOptions options = new RunInstancesOptions();
            return options.asType(instanceType);
        }

        public static RunInstancesOptions withKernelId(String kernelId) {
            RunInstancesOptions options = new RunInstancesOptions();
            return options.withKernelId(kernelId);
        }

        public static RunInstancesOptions withRamdisk(String ramdiskId) {
            RunInstancesOptions options = new RunInstancesOptions();
            return options.withRamdisk(ramdiskId);
        }

        public static RunInstancesOptions withBlockDeviceMappings(Set<? extends BlockDeviceMapping> mappings) {
            RunInstancesOptions options = new RunInstancesOptions();
            return options.withBlockDeviceMappings(mappings);
        }

        public static RunInstancesOptions withClientToken(String clientToken) {
            RunInstancesOptions options = new RunInstancesOptions();
            return options.withClientToken(clientToken);
        }
    }
}

