/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.oauth.v2.functions;

import com.google.common.base.Charsets;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableList;
import com.google.common.io.BaseEncoding;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.SignatureException;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import org.jclouds.json.Json;
import org.jclouds.oauth.v2.config.Authorization;
import org.jclouds.rest.AuthorizationException;

public final class ClaimsToAssertion
implements Function<Object, String> {
    private static final List<String> SUPPORTED_ALGS = ImmutableList.of("RS256", "none");
    private final Supplier<PrivateKey> privateKey;
    private final Json json;
    private final String alg;

    @Inject
    ClaimsToAssertion(@Named(value="jclouds.oauth.jws-alg") String alg, @Authorization Supplier<PrivateKey> privateKey, Json json) {
        this.alg = alg;
        Preconditions.checkArgument(SUPPORTED_ALGS.contains(alg), "%s %s not in supported list", "jclouds.oauth.jws-alg", alg, SUPPORTED_ALGS);
        this.privateKey = privateKey;
        this.json = json;
    }

    @Override
    public String apply(Object input) {
        String encodedHeader = String.format("{\"alg\":\"%s\",\"typ\":\"JWT\"}", this.alg);
        String encodedClaimSet = this.json.toJson(input);
        encodedHeader = BaseEncoding.base64Url().omitPadding().encode(encodedHeader.getBytes(Charsets.UTF_8));
        encodedClaimSet = BaseEncoding.base64Url().omitPadding().encode(encodedClaimSet.getBytes(Charsets.UTF_8));
        byte[] signature = this.alg.equals("none") ? null : ClaimsToAssertion.sha256(this.privateKey.get(), Joiner.on(".").join(encodedHeader, encodedClaimSet, new Object[0]).getBytes(Charsets.UTF_8));
        String encodedSignature = signature != null ? BaseEncoding.base64Url().omitPadding().encode(signature) : "";
        return Joiner.on(".").join(encodedHeader, encodedClaimSet, encodedSignature);
    }

    static byte[] sha256(PrivateKey privateKey, byte[] input) {
        try {
            Signature signature = Signature.getInstance("SHA256withRSA");
            signature.initSign(privateKey);
            signature.update(input);
            return signature.sign();
        }
        catch (NoSuchAlgorithmException e) {
            throw new AssertionError((Object)e);
        }
        catch (SignatureException e) {
            throw new AuthorizationException(e);
        }
        catch (InvalidKeyException e) {
            throw new AuthorizationException(e);
        }
    }
}

