/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.nova.v2_0.compute.loaders;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.cache.CacheLoader;
import com.google.common.util.concurrent.Atomics;
import java.util.concurrent.atomic.AtomicReference;
import javax.inject.Inject;
import javax.inject.Named;
import org.jclouds.openstack.nova.v2_0.domain.regionscoped.RegionAndName;
import org.jclouds.openstack.nova.v2_0.domain.regionscoped.RegionSecurityGroupNameAndPorts;
import org.jclouds.openstack.nova.v2_0.domain.regionscoped.SecurityGroupInRegion;

public class FindSecurityGroupOrCreate
extends CacheLoader<RegionAndName, SecurityGroupInRegion> {
    protected final Predicate<AtomicReference<RegionAndName>> returnSecurityGroupExistsInRegion;
    protected final Function<RegionSecurityGroupNameAndPorts, SecurityGroupInRegion> groupCreator;

    @Inject
    public FindSecurityGroupOrCreate(@Named(value="SECURITYGROUP_PRESENT") Predicate<AtomicReference<RegionAndName>> returnSecurityGroupExistsInRegion, Function<RegionSecurityGroupNameAndPorts, SecurityGroupInRegion> groupCreator) {
        this.returnSecurityGroupExistsInRegion = Preconditions.checkNotNull(returnSecurityGroupExistsInRegion, "returnSecurityGroupExistsInRegion");
        this.groupCreator = Preconditions.checkNotNull(groupCreator, "groupCreator");
    }

    @Override
    public SecurityGroupInRegion load(RegionAndName in) {
        AtomicReference<RegionAndName> securityGroupInRegionRef = Atomics.newReference(Preconditions.checkNotNull(in, "regionSecurityGroupNameAndPorts"));
        if (this.returnSecurityGroupExistsInRegion.apply(securityGroupInRegionRef)) {
            return this.returnExistingSecurityGroup(securityGroupInRegionRef);
        }
        return this.createNewSecurityGroup(in);
    }

    private SecurityGroupInRegion returnExistingSecurityGroup(AtomicReference<RegionAndName> securityGroupInRegionRef) {
        RegionAndName securityGroupInRegion = securityGroupInRegionRef.get();
        Preconditions.checkState(securityGroupInRegion instanceof SecurityGroupInRegion, "programming error: predicate %s should update the atomic reference to the actual security group found", this.returnSecurityGroupExistsInRegion);
        return (SecurityGroupInRegion)SecurityGroupInRegion.class.cast(securityGroupInRegion);
    }

    private SecurityGroupInRegion createNewSecurityGroup(RegionAndName in) {
        Preconditions.checkState(Preconditions.checkNotNull(in, "regionSecurityGroupNameAndPorts") instanceof RegionSecurityGroupNameAndPorts, "programming error: when issuing get to this cacheloader, you need to pass an instance of RegionSecurityGroupNameAndPorts, not %s", in);
        RegionSecurityGroupNameAndPorts regionSecurityGroupNameAndPorts = (RegionSecurityGroupNameAndPorts)RegionSecurityGroupNameAndPorts.class.cast(in);
        return this.groupCreator.apply(regionSecurityGroupNameAndPorts);
    }

    public String toString() {
        return "returnExistingSecurityGroupInRegionOrCreateAsNeeded()";
    }
}

