/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.nova.v2_0.compute.options;

import com.google.common.util.concurrent.Atomics;
import java.util.concurrent.atomic.AtomicReference;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.openstack.nova.v2_0.compute.options.NovaTemplateOptions;

public class NodeAndNovaTemplateOptions {
    private final AtomicReference<NodeMetadata> nodeMetadata;
    private final AtomicReference<NovaTemplateOptions> novaTemplateOptions;

    protected NodeAndNovaTemplateOptions(AtomicReference<NodeMetadata> nodeMetadata, AtomicReference<NovaTemplateOptions> novaTemplateOptions) {
        this.nodeMetadata = nodeMetadata;
        this.novaTemplateOptions = novaTemplateOptions;
    }

    public AtomicReference<NodeMetadata> getNodeMetadata() {
        return this.nodeMetadata;
    }

    public AtomicReference<NovaTemplateOptions> getNovaTemplateOptions() {
        return this.novaTemplateOptions;
    }

    public static NodeAndNovaTemplateOptions newReference(AtomicReference<NodeMetadata> node, AtomicReference<NovaTemplateOptions> options) {
        return new NodeAndNovaTemplateOptions(node, options);
    }

    public static AtomicReference<NodeAndNovaTemplateOptions> newAtomicReference(AtomicReference<NodeMetadata> node, AtomicReference<NovaTemplateOptions> options) {
        return Atomics.newReference(NodeAndNovaTemplateOptions.newReference(node, options));
    }
}

