/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.googlecomputeengine.compute.functions;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Sets;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.inject.Inject;
import org.jclouds.compute.domain.NodeMetadata;

public final class OrphanedGroupsFromDeadNodes
implements Function<Set<? extends NodeMetadata>, Set<String>> {
    private final Predicate<String> isOrphanedGroupPredicate;

    @Inject
    OrphanedGroupsFromDeadNodes(Predicate<String> isOrphanedGroupPredicate) {
        this.isOrphanedGroupPredicate = isOrphanedGroupPredicate;
    }

    @Override
    public Set<String> apply(Set<? extends NodeMetadata> deadNodes) {
        LinkedHashSet<String> groups = Sets.newLinkedHashSet();
        for (NodeMetadata nodeMetadata : deadNodes) {
            groups.add(nodeMetadata.getGroup());
        }
        LinkedHashSet<String> orphanedGroups = Sets.newLinkedHashSet();
        for (String group : groups) {
            if (!this.isOrphanedGroupPredicate.apply(group)) continue;
            orphanedGroups.add(group);
        }
        return orphanedGroups;
    }
}

