/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.v2_0.options;

import com.google.common.base.Preconditions;
import com.google.common.collect.Multimap;
import java.util.Date;
import org.jclouds.http.options.BaseHttpRequestOptions;

public class PaginationOptions
extends BaseHttpRequestOptions {
    public PaginationOptions queryParameters(Multimap<String, String> queryParams) {
        Preconditions.checkNotNull(queryParams, "queryParams");
        this.queryParameters.putAll(queryParams);
        return this;
    }

    @Deprecated
    public PaginationOptions changesSince(Date changesSince) {
        this.queryParameters.put("changes-since", Preconditions.checkNotNull(changesSince, "changesSince").getTime() / 1000L + "");
        return this;
    }

    public PaginationOptions marker(String marker) {
        this.queryParameters.put("marker", Preconditions.checkNotNull(marker, "marker"));
        return this;
    }

    public PaginationOptions limit(int limit) {
        Preconditions.checkState(limit >= 0, "limit must be >= 0");
        Preconditions.checkState(limit <= 10000, "limit must be <= 10000");
        this.queryParameters.put("limit", Integer.toString(limit));
        return this;
    }

    public static class Builder {
        public static PaginationOptions queryParameters(Multimap<String, String> queryParams) {
            PaginationOptions options = new PaginationOptions();
            return options.queryParameters(queryParams);
        }

        @Deprecated
        public static PaginationOptions changesSince(Date changesSince) {
            PaginationOptions options = new PaginationOptions();
            return options.changesSince(changesSince);
        }

        public static PaginationOptions marker(String marker) {
            PaginationOptions options = new PaginationOptions();
            return options.marker(marker);
        }

        public static PaginationOptions limit(int limit) {
            PaginationOptions options = new PaginationOptions();
            return options.limit(limit);
        }
    }
}

