/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ec2.domain;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.Map;

public final class Subnet {
    private final String subnetId;
    private final State subnetState;
    private final String vpcId;
    private final String cidrBlock;
    private final int availableIpAddressCount;
    private final String availabilityZone;
    private final Map<String, String> tags;

    private Subnet(String subnetId, State subnetState, String vpcId, String cidrBlock, int availableIpAddressCount, String availabilityZone, ImmutableMap<String, String> tags) {
        this.subnetId = Preconditions.checkNotNull(subnetId, "subnetId");
        this.subnetState = Preconditions.checkNotNull(subnetState, "subnetState for %s", subnetId);
        this.vpcId = Preconditions.checkNotNull(vpcId, "vpcId for %s", subnetId);
        this.cidrBlock = Preconditions.checkNotNull(cidrBlock, "cidrBlock for %s", subnetId);
        this.availableIpAddressCount = availableIpAddressCount;
        this.availabilityZone = Preconditions.checkNotNull(availabilityZone, "availabilityZone for %s", subnetId);
        this.tags = Preconditions.checkNotNull(tags, "tags for %s", subnetId);
    }

    public String getSubnetId() {
        return this.subnetId;
    }

    public State getSubnetState() {
        return this.subnetState;
    }

    public String getVpcId() {
        return this.vpcId;
    }

    public String getCidrBlock() {
        return this.cidrBlock;
    }

    public int getAvailableIpAddressCount() {
        return this.availableIpAddressCount;
    }

    public String getAvailabilityZone() {
        return this.availabilityZone;
    }

    public Map<String, String> getTags() {
        return this.tags;
    }

    public int hashCode() {
        return Objects.hashCode(this.subnetId, this.vpcId, this.availabilityZone);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Subnet that = (Subnet)Subnet.class.cast(obj);
        return Objects.equal(this.subnetId, that.subnetId) && Objects.equal(this.vpcId, that.vpcId) && Objects.equal(this.availabilityZone, that.availabilityZone);
    }

    public String toString() {
        return this.string().toString();
    }

    private Objects.ToStringHelper string() {
        return Objects.toStringHelper(this).omitNullValues().add("subnetId", this.subnetId).add("subnetState", (Object)this.subnetState).add("vpcId", this.vpcId).add("cidrBlock", this.cidrBlock).add("availableIpAddressCount", this.availableIpAddressCount).add("availabilityZone", this.availabilityZone).add("tags", this.tags);
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return Subnet.builder().from(this);
    }

    public static final class Builder {
        private String subnetId;
        private State subnetState;
        private String vpcId;
        private String cidrBlock;
        private int availableIpAddressCount;
        private String availabilityZone;
        private ImmutableMap.Builder<String, String> tags = ImmutableMap.builder();

        public Builder subnetId(String subnetId) {
            this.subnetId = subnetId;
            return this;
        }

        public Builder subnetState(State subnetState) {
            this.subnetState = subnetState;
            return this;
        }

        public Builder vpcId(String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        public Builder cidrBlock(String cidrBlock) {
            this.cidrBlock = cidrBlock;
            return this;
        }

        public Builder availableIpAddressCount(int availableIpAddressCount) {
            this.availableIpAddressCount = availableIpAddressCount;
            return this;
        }

        public Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public Builder tags(Map<String, String> tags) {
            this.tags.putAll(Preconditions.checkNotNull(tags, "tags"));
            return this;
        }

        public Builder tag(String key) {
            return this.tag(key, "");
        }

        public Builder tag(String key, String value) {
            this.tags.put(Preconditions.checkNotNull(key, "key"), Preconditions.checkNotNull(value, "value"));
            return this;
        }

        public Subnet build() {
            return new Subnet(this.subnetId, this.subnetState, this.vpcId, this.cidrBlock, this.availableIpAddressCount, this.availabilityZone, this.tags.build());
        }

        public Builder from(Subnet in) {
            return this.subnetId(in.getSubnetId()).subnetState(in.getSubnetState()).vpcId(in.getVpcId()).cidrBlock(in.getCidrBlock()).availableIpAddressCount(in.getAvailableIpAddressCount()).availabilityZone(in.getAvailabilityZone()).tags(in.getTags());
        }
    }

    public static enum State {
        AVAILABLE,
        PENDING,
        UNRECOGNIZED;


        public String value() {
            return this.name().toLowerCase();
        }

        public static State fromValue(String v) {
            try {
                return State.valueOf(v.toUpperCase());
            }
            catch (IllegalArgumentException e) {
                return UNRECOGNIZED;
            }
        }
    }
}

