/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.oauth.v2.filters;

import com.google.common.base.Joiner;
import com.google.common.base.Supplier;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import javax.inject.Named;
import org.jclouds.domain.Credentials;
import org.jclouds.http.HttpException;
import org.jclouds.http.HttpRequest;
import org.jclouds.location.Provider;
import org.jclouds.oauth.v2.AuthorizationApi;
import org.jclouds.oauth.v2.config.OAuthScopes;
import org.jclouds.oauth.v2.domain.Claims;
import org.jclouds.oauth.v2.domain.Token;
import org.jclouds.oauth.v2.filters.OAuthFilter;

public class JWTBearerTokenFlow
implements OAuthFilter {
    private static final Joiner ON_COMMA = Joiner.on(",");
    private final String audience;
    private final Supplier<Credentials> credentialsSupplier;
    private final OAuthScopes scopes;
    private final long tokenDuration;
    private final LoadingCache<Claims, Token> tokenCache;

    @Inject
    JWTBearerTokenFlow(AuthorizeToken loader, @Named(value="jclouds.session-interval") long tokenDuration, @Named(value="jclouds.oauth.audience") String audience, @Provider Supplier<Credentials> credentialsSupplier, OAuthScopes scopes) {
        this.audience = audience;
        this.credentialsSupplier = credentialsSupplier;
        this.scopes = scopes;
        this.tokenDuration = tokenDuration;
        long cacheExpirationSeconds = tokenDuration > 30L ? tokenDuration - 30L : tokenDuration;
        this.tokenCache = CacheBuilder.newBuilder().expireAfterWrite(tokenDuration, TimeUnit.SECONDS).build(loader);
    }

    @Override
    public HttpRequest filter(HttpRequest request) throws HttpException {
        long now = this.currentTimeSeconds();
        Claims claims = Claims.create(this.credentialsSupplier.get().identity, ON_COMMA.join(this.scopes.forRequest(request)), this.audience, now + this.tokenDuration, now);
        Token token = this.tokenCache.getUnchecked(claims);
        String authorization = String.format("%s %s", token.tokenType(), token.accessToken());
        return ((HttpRequest.Builder)request.toBuilder().addHeader("Authorization", authorization)).build();
    }

    long currentTimeSeconds() {
        return System.currentTimeMillis() / 1000L;
    }

    static final class AuthorizeToken
    extends CacheLoader<Claims, Token> {
        private final AuthorizationApi api;

        @Inject
        AuthorizeToken(AuthorizationApi api) {
            this.api = api;
        }

        @Override
        public Token load(Claims key) throws Exception {
            return this.api.authorize(key);
        }
    }

    public static class TestJWTBearerTokenFlow
    extends JWTBearerTokenFlow {
        @Inject
        TestJWTBearerTokenFlow(AuthorizeToken loader, @Named(value="jclouds.session-interval") long tokenDuration, @Named(value="jclouds.oauth.audience") String audience, @Provider Supplier<Credentials> credentialsSupplier, OAuthScopes scopes) {
            super(loader, tokenDuration, audience, credentialsSupplier, scopes);
        }

        @Override
        long currentTimeSeconds() {
            return 0L;
        }
    }
}

