/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.softlayer.compute.functions;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import javax.inject.Singleton;
import org.jclouds.compute.domain.Hardware;
import org.jclouds.compute.domain.HardwareBuilder;
import org.jclouds.compute.domain.Processor;
import org.jclouds.compute.domain.Volume;
import org.jclouds.compute.domain.internal.VolumeImpl;
import org.jclouds.softlayer.domain.VirtualGuest;
import org.jclouds.softlayer.domain.VirtualGuestBlockDevice;

@Singleton
public class VirtualGuestToHardware
implements Function<VirtualGuest, Hardware> {
    @Override
    public Hardware apply(final VirtualGuest from) {
        HardwareBuilder builder = new HardwareBuilder().ids(from.getId() + "").name(from.getHostname()).hypervisor("XenServer").processors(ImmutableList.of(new Processor(from.getStartCpus(), 2.0))).ram(from.getMaxMemory());
        if (from.getVirtualGuestBlockDevices() != null) {
            builder.volumes(FluentIterable.from(from.getVirtualGuestBlockDevices()).filter(new Predicate<VirtualGuestBlockDevice>(){

                @Override
                public boolean apply(VirtualGuestBlockDevice input) {
                    return input.getMountType().equals("Disk");
                }
            }).transform(new Function<VirtualGuestBlockDevice, Volume>(){

                @Override
                public Volume apply(VirtualGuestBlockDevice item) {
                    float volumeSize = item.getVirtualDiskImage().getCapacity();
                    return new VolumeImpl(item.getId() + "", from.isLocalDiskFlag() ? Volume.Type.LOCAL : Volume.Type.SAN, Float.valueOf(volumeSize), null, item.getBootableFlag() == 1, false);
                }
            }).toSet());
        }
        return builder.build();
    }
}

