/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.googlecomputeengine.compute;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.util.concurrent.Atomics;
import com.google.common.util.concurrent.UncheckedTimeoutException;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import javax.inject.Inject;
import javax.inject.Named;
import org.jclouds.compute.ComputeServiceAdapter;
import org.jclouds.compute.domain.Template;
import org.jclouds.compute.options.TemplateOptions;
import org.jclouds.domain.Location;
import org.jclouds.domain.LocationBuilder;
import org.jclouds.domain.LocationScope;
import org.jclouds.domain.LoginCredentials;
import org.jclouds.googlecloud.internal.ListPages;
import org.jclouds.googlecomputeengine.GoogleComputeEngineApi;
import org.jclouds.googlecomputeengine.compute.functions.FirewallTagNamingConvention;
import org.jclouds.googlecomputeengine.compute.functions.Resources;
import org.jclouds.googlecomputeengine.compute.options.GoogleComputeEngineTemplateOptions;
import org.jclouds.googlecomputeengine.domain.AttachDisk;
import org.jclouds.googlecomputeengine.domain.DiskType;
import org.jclouds.googlecomputeengine.domain.Image;
import org.jclouds.googlecomputeengine.domain.Instance;
import org.jclouds.googlecomputeengine.domain.MachineType;
import org.jclouds.googlecomputeengine.domain.NewInstance;
import org.jclouds.googlecomputeengine.domain.Operation;
import org.jclouds.googlecomputeengine.domain.Region;
import org.jclouds.googlecomputeengine.features.InstanceApi;
import org.jclouds.location.suppliers.all.JustProvider;

public final class GoogleComputeEngineServiceAdapter
implements ComputeServiceAdapter<Instance, MachineType, Image, Location> {
    private final JustProvider justProvider;
    private final GoogleComputeEngineApi api;
    private final Resources resources;
    private final Map<URI, URI> diskToSourceImage;
    private final Predicate<AtomicReference<Operation>> operationDone;
    private final Predicate<AtomicReference<Instance>> instanceVisible;
    private final FirewallTagNamingConvention.Factory firewallTagNamingConvention;
    private final List<String> imageProjects;

    @Inject
    GoogleComputeEngineServiceAdapter(JustProvider justProvider, GoogleComputeEngineApi api, Predicate<AtomicReference<Operation>> operationDone, Predicate<AtomicReference<Instance>> instanceVisible, Map<URI, URI> diskToSourceImage, Resources resources, FirewallTagNamingConvention.Factory firewallTagNamingConvention, @Named(value="jclouds.google-compute-engine.image-projects") String imageProjects) {
        this.justProvider = justProvider;
        this.api = api;
        this.operationDone = operationDone;
        this.instanceVisible = instanceVisible;
        this.diskToSourceImage = diskToSourceImage;
        this.resources = resources;
        this.firewallTagNamingConvention = firewallTagNamingConvention;
        this.imageProjects = Splitter.on(',').omitEmptyStrings().splitToList(imageProjects);
    }

    @Override
    public ComputeServiceAdapter.NodeAndInitialCredentials<Instance> createNodeWithGroupEncodedIntoName(String group, String name, Template template) {
        GoogleComputeEngineTemplateOptions options = (GoogleComputeEngineTemplateOptions)GoogleComputeEngineTemplateOptions.class.cast(template.getOptions());
        Preconditions.checkNotNull(options.network(), "template options must specify a network");
        Preconditions.checkNotNull(template.getHardware().getUri(), "hardware must have a URI");
        Preconditions.checkNotNull(template.getImage().getUri(), "image URI is null");
        String zone = template.getLocation().getId();
        ArrayList<AttachDisk> disks = Lists.newArrayList();
        disks.add(AttachDisk.newBootDisk(template.getImage().getUri(), this.getDiskTypeArgument(options, zone)));
        NewInstance newInstance = NewInstance.create(name, template.getHardware().getUri(), options.network(), disks, group);
        newInstance.tags().items().addAll(options.getTags());
        FirewallTagNamingConvention naming = this.firewallTagNamingConvention.get(group);
        for (int port : options.getInboundPorts()) {
            newInstance.tags().items().add(naming.name(port));
        }
        newInstance.metadata().putAll(options.getUserMetadata());
        LoginCredentials credentials = this.resolveNodeCredentials(template);
        if (options.getPublicKey() != null) {
            newInstance.metadata().put("sshKeys", String.format("%s:%s %s@localhost", credentials.getUser(), options.getPublicKey(), credentials.getUser()));
        }
        InstanceApi instanceApi = this.api.instancesInZone(zone);
        Operation create = instanceApi.create(newInstance);
        AtomicReference<Instance> instance = Atomics.newReference(Instance.create("0000000000000000000", null, create.targetLink(), newInstance.name(), newInstance.description(), newInstance.tags(), newInstance.machineType(), Instance.Status.PROVISIONING, null, create.zone(), null, null, null, newInstance.metadata(), null, Instance.Scheduling.create(Instance.Scheduling.OnHostMaintenance.MIGRATE, true)));
        Preconditions.checkState(this.instanceVisible.apply(instance), "instance %s is not api visible!", instance.get());
        this.diskToSourceImage.put(instance.get().disks().get(0).source(), template.getImage().getUri());
        return new ComputeServiceAdapter.NodeAndInitialCredentials<Instance>(instance.get(), instance.get().selfLink().toString(), credentials);
    }

    @Override
    public Iterable<MachineType> listHardwareProfiles() {
        return Iterables.filter(ListPages.concat(this.api.aggregatedList().machineTypes()), new Predicate<MachineType>(){

            @Override
            public boolean apply(MachineType input) {
                return input.deprecated() == null;
            }
        });
    }

    @Override
    public Iterable<Image> listImages() {
        ArrayList images = Lists.newArrayList();
        images.add(ListPages.concat(this.api.images().list()));
        for (String project : this.imageProjects) {
            images.add(ListPages.concat(this.api.images().listInProject(project)));
        }
        return Iterables.concat(images);
    }

    @Override
    public Image getImage(String selfLink) {
        return this.api.images().get(URI.create(Preconditions.checkNotNull(selfLink, "id")));
    }

    @Override
    public Iterable<Location> listLocations() {
        Location provider = (Location)this.justProvider.get().iterator().next();
        ImmutableList.Builder zones = ImmutableList.builder();
        for (Region region : ListPages.concat(this.api.regions().list())) {
            Location regionLocation = new LocationBuilder().scope(LocationScope.REGION).id(region.name()).description(region.selfLink().toString()).parent(provider).build();
            for (URI zoneSelfLink : region.zones()) {
                String zoneName = GoogleComputeEngineServiceAdapter.toName(zoneSelfLink);
                zones.add(new LocationBuilder().scope(LocationScope.ZONE).id(zoneName).description(zoneSelfLink.toString()).parent(regionLocation).build());
            }
        }
        return zones.build();
    }

    @Override
    public Instance getNode(String selfLink) {
        return this.resources.instance(URI.create(Preconditions.checkNotNull(selfLink, "id")));
    }

    @Override
    public Iterable<Instance> listNodes() {
        return ListPages.concat(this.api.aggregatedList().instances());
    }

    @Override
    public Iterable<Instance> listNodesByIds(final Iterable<String> selfLinks) {
        return Iterables.filter(this.listNodes(), new Predicate<Instance>(){

            @Override
            public boolean apply(Instance instance) {
                return Iterables.contains(selfLinks, instance.selfLink().toString());
            }
        });
    }

    @Override
    public void destroyNode(String selfLink) {
        this.waitOperationDone(this.resources.delete(URI.create(Preconditions.checkNotNull(selfLink, "id"))));
    }

    @Override
    public void rebootNode(String selfLink) {
        this.waitOperationDone(this.resources.resetInstance(URI.create(Preconditions.checkNotNull(selfLink, "id"))));
    }

    @Override
    public void resumeNode(String selfLink) {
        this.waitOperationDone(this.resources.startInstance(URI.create(Preconditions.checkNotNull(selfLink, "id"))));
    }

    @Override
    public void suspendNode(String selfLink) {
        this.waitOperationDone(this.resources.stopInstance(URI.create(Preconditions.checkNotNull(selfLink, "id"))));
    }

    private void waitOperationDone(Operation operation) {
        AtomicReference<Operation> operationRef = Atomics.newReference(operation);
        if (!this.operationDone.apply(operationRef)) {
            throw new UncheckedTimeoutException("operation did not reach DONE state" + operationRef.get());
        }
        if (operationRef.get().httpErrorStatusCode() != null) {
            throw new IllegalStateException("operation failed. Http Error Code: " + operationRef.get().httpErrorStatusCode() + " HttpError: " + operationRef.get().httpErrorMessage());
        }
    }

    private LoginCredentials resolveNodeCredentials(Template template) {
        TemplateOptions options = template.getOptions();
        LoginCredentials.Builder credentials = LoginCredentials.builder(template.getImage().getDefaultCredentials());
        if (!Strings.isNullOrEmpty(options.getLoginUser())) {
            credentials.user(options.getLoginUser());
        }
        if (!Strings.isNullOrEmpty(options.getLoginPrivateKey())) {
            credentials.privateKey(options.getLoginPrivateKey());
        }
        if (!Strings.isNullOrEmpty(options.getLoginPassword())) {
            credentials.password(options.getLoginPassword());
        }
        if (options.shouldAuthenticateSudo() != null) {
            credentials.authenticateSudo(options.shouldAuthenticateSudo());
        }
        return credentials.build();
    }

    private static String toName(URI link) {
        String path = link.getPath();
        return path.substring(path.lastIndexOf(47) + 1);
    }

    private URI getDiskTypeArgument(GoogleComputeEngineTemplateOptions options, String zone) {
        DiskType diskType;
        if (options.bootDiskType() != null && (diskType = this.api.diskTypesInZone(zone).get(options.bootDiskType())) != null) {
            return diskType.selfLink();
        }
        return null;
    }
}

