/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.conn.docker;

import com.github.dockerjava.api.model.Container;
import com.github.dockerjava.core.DefaultDockerClientConfig;
import com.google.common.primitives.Ints;
import es.bsc.conn.Connector;
import es.bsc.conn.clients.docker.DockerClient;
import es.bsc.conn.clients.exceptions.ConnClientException;
import es.bsc.conn.exceptions.ConnException;
import es.bsc.conn.types.HardwareDescription;
import es.bsc.conn.types.SoftwareDescription;
import es.bsc.conn.types.VirtualResource;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.UUID;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Docker
extends Connector {
    private static final String PROP_PROVIDER_USER = "provider-user";
    private static final String PROP_VM_USER = "vm-user";
    private static final String[] WORKER_CMD = new String[]{"/usr/sbin/sshd", "-D"};
    private static final String PROP_HTTPS = "https";
    private static final String PROP_HTTP = "http";
    private static final String PROP_TCP = "tcp";
    private static final int SSH_PORT = 22;
    private static final String IMAGE_USERNAME = "compss";
    private static final Logger LOGGER = LogManager.getLogger("es.bsc.compss.Connectors.Conn.Docker");
    private DockerClient dockerClient;
    private final Map<String, HardwareDescription> containeridToHardwareRequest = new HashMap<String, HardwareDescription>();
    private final Map<String, SoftwareDescription> containeridToSoftwareRequest = new HashMap<String, SoftwareDescription>();

    public Docker(Map<String, String> props) throws ConnException {
        super(props);
        LOGGER.info("Initializing Docker Connector");
        String host = this.server.replace(PROP_HTTPS, PROP_TCP).replace(PROP_HTTP, PROP_TCP);
        DefaultDockerClientConfig.Builder b = DefaultDockerClientConfig.createDefaultConfigBuilder();
        b = b.withDockerHost(host);
        DefaultDockerClientConfig config = b.build();
        this.dockerClient = DockerClient.build(config);
    }

    @Override
    public Object create(HardwareDescription hd, SoftwareDescription sd, Map<String, String> prop) throws ConnException {
        int adaptorMinPort = Integer.parseInt(this.getProperty(hd.getImageProperties(), "adaptor-min-port", Integer.toString(-1)));
        int adaptorMaxPort = Integer.parseInt(this.getProperty(hd.getImageProperties(), "adaptor-max-port", Integer.toString(-1)));
        int[] exposedPorts = this.portsToExpose(adaptorMinPort, adaptorMaxPort);
        String containerName = this.appName + '-' + UUID.randomUUID().toString();
        try {
            String containerId = this.dockerClient.createContainer(hd.getImageName(), containerName, exposedPorts, hd.getTotalCPUComputingUnits(), hd.getMemorySize(), WORKER_CMD);
            this.dockerClient.startContainer(containerId);
            this.containeridToHardwareRequest.put(containerId, hd);
            this.containeridToSoftwareRequest.put(containerId, sd);
            return containerId;
        }
        catch (Exception e) {
            String err = "There was an error creating the container '" + containerName + "': " + e.getMessage();
            throw new ConnException(err, e);
        }
    }

    @Override
    public VirtualResource waitUntilCreation(Object id) throws ConnException {
        String containerId = (String)id;
        Container c = this.dockerClient.getContainerById(containerId);
        if (c == null) {
            String err = "The container " + containerId + " couldn't be retrieved.";
            throw new ConnException(err);
        }
        String ip = this.dockerClient.getIpAddress(containerId);
        VirtualResource vr = new VirtualResource();
        vr.setId(containerId);
        vr.setIp(ip);
        HashMap<String, String> providerProperties = new HashMap<String, String>();
        providerProperties.put(PROP_PROVIDER_USER, IMAGE_USERNAME);
        providerProperties.put(PROP_VM_USER, IMAGE_USERNAME);
        vr.setProperties(providerProperties);
        HardwareDescription hd = this.containeridToHardwareRequest.get(containerId);
        if (hd == null) {
            throw new ConnException("Unregistered hardware description for containerId = " + containerId);
        }
        try {
            this.getHardwareInformation(containerId, hd);
        }
        catch (ConnClientException cce) {
            throw new ConnException("Error retrieving resource hardware description of Container " + containerId + " from client", cce);
        }
        vr.setHd(hd);
        SoftwareDescription sd = this.containeridToSoftwareRequest.get(containerId);
        if (sd == null) {
            throw new ConnException("Unregistered software description for containerId = " + containerId);
        }
        sd.setOperatingSystemType("Linux");
        vr.setSd(sd);
        return vr;
    }

    @Override
    public void destroy(Object id) {
        String containerId = (String)id;
        Container c = this.dockerClient.getContainerById(containerId);
        this.dockerClient.removeContainer(c.getId());
        this.containeridToHardwareRequest.remove(containerId);
        this.containeridToSoftwareRequest.remove(containerId);
    }

    @Override
    public float getPriceSlot(VirtualResource virtualResource) {
        return virtualResource.getHd().getPricePerUnit();
    }

    @Override
    public void close() {
        this.dockerClient.removeAllContainers();
    }

    private int[] portsToExpose(int minPort, int maxPort) {
        HashSet<Integer> ports = new HashSet<Integer>();
        ports.add(22);
        if (minPort > 0 && maxPort > 0) {
            for (int port = minPort; port < maxPort; ++port) {
                LOGGER.debug("Adding inbound port:" + port);
                ports.add(port);
            }
        }
        return Ints.toArray(ports);
    }

    private String getProperty(Map<String, String> props, String property, String defaultValue) {
        String value = props.get(property);
        return value != null && !value.isEmpty() ? value : defaultValue;
    }

    private void getHardwareInformation(String containerId, HardwareDescription hd) throws ConnClientException {
    }
}

