/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ec2.options;

import com.google.common.base.Preconditions;
import org.jclouds.ec2.options.internal.BaseEC2RequestOptions;

public class DetachVolumeOptions
extends BaseEC2RequestOptions {
    public DetachVolumeOptions fromInstance(String instanceId) {
        this.formParameters.put("InstanceId", Preconditions.checkNotNull(instanceId, "instanceId"));
        return this;
    }

    public String getInstance() {
        return this.getFirstFormOrNull("InstanceId");
    }

    public DetachVolumeOptions fromDevice(String device) {
        this.formParameters.put("Device", Preconditions.checkNotNull(device, "device"));
        return this;
    }

    public String getDevice() {
        return this.getFirstFormOrNull("Device");
    }

    public static class Builder {
        public static DetachVolumeOptions fromInstance(String instance) {
            DetachVolumeOptions options = new DetachVolumeOptions();
            return options.fromInstance(instance);
        }

        public static DetachVolumeOptions fromDevice(String device) {
            DetachVolumeOptions options = new DetachVolumeOptions();
            return options.fromDevice(device);
        }
    }
}

