/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.http.options;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import java.util.Date;
import java.util.List;
import org.jclouds.date.DateService;
import org.jclouds.date.internal.SimpleDateFormatDateService;
import org.jclouds.http.options.BaseHttpRequestOptions;

public class GetOptions
extends BaseHttpRequestOptions {
    private static final DateService dateService = new SimpleDateFormatDateService();
    public static final GetOptions NONE = new GetOptions();
    private final List<String> ranges = Lists.newArrayList();

    @Override
    public Multimap<String, String> buildRequestHeaders() {
        Multimap<String, String> headers = super.buildRequestHeaders();
        String range = this.getRange();
        if (range != null) {
            headers.put("Range", this.getRange());
        }
        return headers;
    }

    public GetOptions range(long start, long end) {
        Preconditions.checkArgument(start >= 0L, "start must be >= 0");
        Preconditions.checkArgument(end >= 0L, "end must be >= 0");
        this.ranges.add(String.format("%d-%d", start, end));
        return this;
    }

    public GetOptions startAt(long start) {
        Preconditions.checkArgument(start >= 0L, "start must be >= 0");
        this.ranges.add(String.format("%d-", start));
        return this;
    }

    public GetOptions tail(long count) {
        Preconditions.checkArgument(count > 0L, "count must be > 0");
        this.ranges.add(String.format("-%d", count));
        return this;
    }

    public String getRange() {
        return !this.ranges.isEmpty() ? String.format("bytes=%s", Joiner.on(",").join(this.ranges)) : null;
    }

    public GetOptions ifModifiedSince(Date ifModifiedSince) {
        Preconditions.checkArgument(this.getIfMatch() == null, "ifETagMatches() is not compatible with ifModifiedSince()");
        Preconditions.checkArgument(this.getIfUnmodifiedSince() == null, "ifUnmodifiedSince() is not compatible with ifModifiedSince()");
        this.headers.put("If-Modified-Since", dateService.rfc822DateFormat(Preconditions.checkNotNull(ifModifiedSince, "ifModifiedSince")));
        return this;
    }

    public String getIfModifiedSince() {
        return this.getFirstHeaderOrNull("If-Modified-Since");
    }

    public GetOptions ifUnmodifiedSince(Date ifUnmodifiedSince) {
        Preconditions.checkArgument(this.getIfNoneMatch() == null, "ifETagDoesntMatch() is not compatible with ifUnmodifiedSince()");
        Preconditions.checkArgument(this.getIfModifiedSince() == null, "ifModifiedSince() is not compatible with ifUnmodifiedSince()");
        this.headers.put("If-Unmodified-Since", dateService.rfc822DateFormat(Preconditions.checkNotNull(ifUnmodifiedSince, "ifUnmodifiedSince")));
        return this;
    }

    public String getIfUnmodifiedSince() {
        return this.getFirstHeaderOrNull("If-Unmodified-Since");
    }

    public GetOptions ifETagMatches(String eTag) {
        Preconditions.checkArgument(this.getIfNoneMatch() == null, "ifETagDoesntMatch() is not compatible with ifETagMatches()");
        Preconditions.checkArgument(this.getIfModifiedSince() == null, "ifModifiedSince() is not compatible with ifETagMatches()");
        this.headers.put("If-Match", String.format("\"%1$s\"", Preconditions.checkNotNull(eTag, "eTag")));
        return this;
    }

    public String getIfMatch() {
        return this.getFirstHeaderOrNull("If-Match");
    }

    public GetOptions ifETagDoesntMatch(String eTag) {
        Preconditions.checkArgument(this.getIfMatch() == null, "ifETagMatches() is not compatible with ifETagDoesntMatch()");
        Preconditions.checkArgument(this.getIfUnmodifiedSince() == null, "ifUnmodifiedSince() is not compatible with ifETagDoesntMatch()");
        this.headers.put("If-None-Match", String.format("\"%1$s\"", Preconditions.checkNotNull(eTag, "ifETagDoesntMatch")));
        return this;
    }

    public String getIfNoneMatch() {
        return this.getFirstHeaderOrNull("If-None-Match");
    }

    public List<String> getRanges() {
        return this.ranges;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.ranges == null ? 0 : this.ranges.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GetOptions other = (GetOptions)obj;
        return !(this.ranges == null ? other.ranges != null : !this.ranges.equals(other.ranges));
    }

    @Override
    public String toString() {
        return "[formParameters=" + this.formParameters + ", queryParameters=" + this.queryParameters + ", headers=" + this.headers + ", payload=" + this.payload + ", pathSuffix=" + this.pathSuffix + ", ranges=" + this.ranges + "]";
    }

    public static class Builder {
        public static GetOptions range(long start, long end) {
            GetOptions options = new GetOptions();
            return options.range(start, end);
        }

        public static GetOptions startAt(long start) {
            GetOptions options = new GetOptions();
            return options.startAt(start);
        }

        public static GetOptions tail(long count) {
            GetOptions options = new GetOptions();
            return options.tail(count);
        }

        public static GetOptions ifModifiedSince(Date ifModifiedSince) {
            GetOptions options = new GetOptions();
            return options.ifModifiedSince(ifModifiedSince);
        }

        public static GetOptions ifUnmodifiedSince(Date ifUnmodifiedSince) {
            GetOptions options = new GetOptions();
            return options.ifUnmodifiedSince(ifUnmodifiedSince);
        }

        public static GetOptions ifETagMatches(String eTag) {
            GetOptions options = new GetOptions();
            return options.ifETagMatches(eTag);
        }

        public static GetOptions ifETagDoesntMatch(String eTag) {
            GetOptions options = new GetOptions();
            return options.ifETagDoesntMatch(eTag);
        }
    }
}

