/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.softlayer.compute.functions;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.collect.Memoized;
import org.jclouds.compute.domain.Image;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.compute.domain.NodeMetadataBuilder;
import org.jclouds.compute.functions.GroupNamingConvention;
import org.jclouds.domain.Location;
import org.jclouds.location.predicates.LocationPredicates;
import org.jclouds.softlayer.compute.functions.VirtualGuestToHardware;
import org.jclouds.softlayer.compute.functions.VirtualGuestToImage;
import org.jclouds.softlayer.domain.TagReference;
import org.jclouds.softlayer.domain.VirtualGuest;

@Singleton
public class VirtualGuestToNodeMetadata
implements Function<VirtualGuest, NodeMetadata> {
    public static final Map<VirtualGuest.State, NodeMetadata.Status> serverStateToNodeStatus = ImmutableMap.builder().put(VirtualGuest.State.HALTED, NodeMetadata.Status.PENDING).put(VirtualGuest.State.PAUSED, NodeMetadata.Status.SUSPENDED).put(VirtualGuest.State.RUNNING, NodeMetadata.Status.RUNNING).put(VirtualGuest.State.UNRECOGNIZED, NodeMetadata.Status.UNRECOGNIZED).build();
    private final Supplier<Set<? extends Location>> locations;
    private final GroupNamingConvention nodeNamingConvention;
    private final VirtualGuestToImage virtualGuestToImage;
    private final VirtualGuestToHardware virtualGuestToHardware;

    @Inject
    VirtualGuestToNodeMetadata(@Memoized Supplier<Set<? extends Location>> locations, GroupNamingConvention.Factory namingConvention, VirtualGuestToImage virtualGuestToImage, VirtualGuestToHardware virtualGuestToHardware) {
        this.nodeNamingConvention = Preconditions.checkNotNull(namingConvention, "namingConvention").createWithoutPrefix();
        this.locations = Preconditions.checkNotNull(locations, "locations");
        this.virtualGuestToImage = Preconditions.checkNotNull(virtualGuestToImage, "virtualGuestToImage");
        this.virtualGuestToHardware = Preconditions.checkNotNull(virtualGuestToHardware, "virtualGuestToHardware");
    }

    @Override
    public NodeMetadata apply(VirtualGuest from) {
        NodeMetadataBuilder builder = new NodeMetadataBuilder();
        builder.ids(from.getId() + "");
        builder.name(from.getHostname());
        builder.hostname(from.getFullyQualifiedDomainName());
        if (from.getDatacenter() != null) {
            builder.location(FluentIterable.from(this.locations.get()).firstMatch(LocationPredicates.idEquals(from.getDatacenter().getName())).orNull());
        }
        builder.group(this.nodeNamingConvention.groupInUniqueNameOrNull(from.getHostname()));
        builder.hardware(this.virtualGuestToHardware.apply(from));
        Image image = this.virtualGuestToImage.apply(from);
        if (image != null) {
            builder.imageId(image.getId());
            builder.operatingSystem(image.getOperatingSystem());
        }
        if (from.getPowerState() != null) {
            builder.status(serverStateToNodeStatus.get((Object)from.getPowerState().getKeyName()));
        }
        if (from.getPrimaryIpAddress() != null) {
            builder.publicAddresses(ImmutableSet.of(from.getPrimaryIpAddress()));
        }
        if (from.getPrimaryBackendIpAddress() != null) {
            builder.privateAddresses(ImmutableSet.of(from.getPrimaryBackendIpAddress()));
        }
        if (from.getTagReferences() != null && !from.getTagReferences().isEmpty()) {
            ArrayList<String> tags = Lists.newArrayList();
            for (TagReference tagReference : from.getTagReferences()) {
                if (tagReference == null) continue;
                tags.add(tagReference.getTag().getName());
            }
            builder.tags(tags);
        }
        return builder.build();
    }
}

