/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.googlecomputeengine.compute.functions;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.util.concurrent.Atomics;
import java.util.concurrent.atomic.AtomicReference;
import javax.inject.Inject;
import org.jclouds.googlecomputeengine.GoogleComputeEngineApi;
import org.jclouds.googlecomputeengine.compute.domain.NetworkAndAddressRange;
import org.jclouds.googlecomputeengine.domain.Network;
import org.jclouds.googlecomputeengine.domain.Operation;
import org.jclouds.googlecomputeengine.options.NetworkCreationOptions;

public final class CreateNetworkIfNeeded
implements Function<NetworkAndAddressRange, Network> {
    private final GoogleComputeEngineApi api;
    private final Predicate<AtomicReference<Operation>> operationDone;

    @Inject
    CreateNetworkIfNeeded(GoogleComputeEngineApi api, Predicate<AtomicReference<Operation>> operationDone) {
        this.api = api;
        this.operationDone = operationDone;
    }

    @Override
    public Network apply(NetworkAndAddressRange input) {
        Preconditions.checkNotNull(input, "input");
        Network nw = this.api.networks().get(input.name());
        if (nw != null) {
            return nw;
        }
        if (input.gateway() != null) {
            NetworkCreationOptions options = new NetworkCreationOptions.Builder(input.name(), input.rangeIPv4()).gatewayIPv4(input.gateway()).build();
            AtomicReference<Operation> operation = Atomics.newReference(this.api.networks().createInIPv4Range(options));
            this.operationDone.apply(operation);
            Preconditions.checkState(operation.get().httpErrorStatusCode() == null, "Could not insert network, operation failed" + operation);
        } else {
            AtomicReference<Operation> operation = Atomics.newReference(this.api.networks().createInIPv4Range(input.name(), input.rangeIPv4()));
            this.operationDone.apply(operation);
            Preconditions.checkState(operation.get().httpErrorStatusCode() == null, "Could not insert network, operation failed" + operation);
        }
        return Preconditions.checkNotNull(this.api.networks().get(input.name()), "no network with name %s was found", input.name());
    }
}

