/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.googlecomputeengine.compute.functions;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableMap;
import javax.inject.Inject;
import org.jclouds.compute.domain.Image;
import org.jclouds.compute.domain.ImageBuilder;
import org.jclouds.compute.domain.OperatingSystem;
import org.jclouds.googlecomputeengine.domain.Deprecated;

public final class GoogleComputeEngineImageToImage
implements Function<org.jclouds.googlecomputeengine.domain.Image, Image> {
    private final Function<String, OperatingSystem> nameToOperatingSystem;

    @Inject
    GoogleComputeEngineImageToImage(Function<String, OperatingSystem> nameToOperatingSystem) {
        this.nameToOperatingSystem = nameToOperatingSystem;
    }

    @Override
    public Image apply(org.jclouds.googlecomputeengine.domain.Image image) {
        ImageBuilder builder = new ImageBuilder().id(image.selfLink().toString()).providerId(image.id()).name(image.name()).providerId(image.id()).description(image.description()).status(Image.Status.AVAILABLE).uri(image.selfLink());
        if (image.deprecated() != null) {
            builder.userMetadata(ImmutableMap.of("deprecatedState", image.deprecated().state().name()));
            if (image.deprecated().state() == Deprecated.State.DELETED) {
                builder.status(Image.Status.DELETED);
            }
        }
        builder.version(image.name().substring(image.name().lastIndexOf(45) + 1));
        builder.operatingSystem(this.nameToOperatingSystem.apply(image.name()));
        return builder.build();
    }
}

