/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.googlecomputeengine.features;

import com.google.common.base.Function;
import java.util.Iterator;
import javax.inject.Inject;
import javax.inject.Named;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.jclouds.Fallbacks;
import org.jclouds.googlecloud.domain.ListPage;
import org.jclouds.googlecomputeengine.GoogleComputeEngineApi;
import org.jclouds.googlecomputeengine.domain.AttachDisk;
import org.jclouds.googlecomputeengine.domain.Instance;
import org.jclouds.googlecomputeengine.domain.Metadata;
import org.jclouds.googlecomputeengine.domain.NewInstance;
import org.jclouds.googlecomputeengine.domain.Operation;
import org.jclouds.googlecomputeengine.internal.BaseCallerArg0ToIteratorOfListPage;
import org.jclouds.googlecomputeengine.options.ListOptions;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.oauth.v2.filters.OAuthFilter;
import org.jclouds.rest.annotations.BinderParam;
import org.jclouds.rest.annotations.Fallback;
import org.jclouds.rest.annotations.MapBinder;
import org.jclouds.rest.annotations.PayloadParam;
import org.jclouds.rest.annotations.RequestFilters;
import org.jclouds.rest.annotations.SkipEncoding;
import org.jclouds.rest.annotations.Transform;
import org.jclouds.rest.binders.BindToJsonPayload;

@SkipEncoding(value={47, 61})
@RequestFilters(value={OAuthFilter.class})
@Path(value="/instances")
@Consumes(value={"application/json"})
public interface InstanceApi {
    @Named(value="Instances:get")
    @GET
    @Path(value="/{instance}")
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    @Nullable
    public Instance get(@PathParam(value="instance") String var1);

    @Named(value="Instances:insert")
    @POST
    @Produces(value={"application/json"})
    public Operation create(@BinderParam(value=BindToJsonPayload.class) NewInstance var1);

    @Named(value="Instances:delete")
    @DELETE
    @Path(value="/{instance}")
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    @Nullable
    public Operation delete(@PathParam(value="instance") String var1);

    @Named(value="Instances:addAccessConfig")
    @POST
    @Produces(value={"application/json"})
    @Path(value="/{instance}/addAccessConfig")
    public Operation addAccessConfigToNic(@PathParam(value="instance") String var1, @BinderParam(value=BindToJsonPayload.class) Instance.NetworkInterface.AccessConfig var2, @QueryParam(value="networkInterface") String var3);

    @Named(value="Instances:deleteAccessConfig")
    @POST
    @Path(value="/{instance}/deleteAccessConfig")
    public Operation deleteAccessConfigFromNic(@PathParam(value="instance") String var1, @QueryParam(value="accessConfig") String var2, @QueryParam(value="networkInterface") String var3);

    @Named(value="Instances:getSerialPortOutput")
    @GET
    @Path(value="/{instance}/serialPort")
    public Instance.SerialPortOutput getSerialPortOutput(@PathParam(value="instance") String var1);

    @Named(value="Instances:reset")
    @POST
    @Path(value="/{instance}/reset")
    public Operation reset(@PathParam(value="instance") String var1);

    @Named(value="Instances:attachDisk")
    @POST
    @Produces(value={"application/json"})
    @Path(value="/{instance}/attachDisk")
    public Operation attachDisk(@PathParam(value="instance") String var1, @BinderParam(value=BindToJsonPayload.class) AttachDisk var2);

    @Named(value="Instances:detachDisk")
    @POST
    @Path(value="/{instance}/detachDisk")
    public Operation detachDisk(@PathParam(value="instance") String var1, @QueryParam(value="deviceName") String var2);

    @Named(value="Instances:setMetadata")
    @POST
    @Path(value="/{instance}/setMetadata")
    public Operation setMetadata(@PathParam(value="instance") String var1, @BinderParam(value=BindToJsonPayload.class) Metadata var2);

    @Named(value="Instances:setTags")
    @POST
    @Path(value="/{instance}/setTags")
    @Produces(value={"application/json"})
    @MapBinder(value=BindToJsonPayload.class)
    public Operation setTags(@PathParam(value="instance") String var1, @PayloadParam(value="items") Iterable<String> var2, @PayloadParam(value="fingerprint") String var3);

    @Named(value="Instances:setDiskAutoDelete")
    @POST
    @Path(value="/{instance}/setDiskAutoDelete")
    public Operation setDiskAutoDelete(@PathParam(value="instance") String var1, @QueryParam(value="deviceName") String var2, @QueryParam(value="autoDelete") boolean var3);

    @Named(value="Instances:setScheduling")
    @POST
    @Path(value="/{instance}/setScheduling")
    @MapBinder(value=BindToJsonPayload.class)
    public Operation setScheduling(@PathParam(value="instance") String var1, @PayloadParam(value="onHostMaintenance") Instance.Scheduling.OnHostMaintenance var2, @PayloadParam(value="automaticRestart") boolean var3);

    @Named(value="Instances:start")
    @POST
    @Path(value="/{instance}/start")
    @Produces(value={"application/json"})
    public Operation start(@PathParam(value="instance") String var1);

    @Named(value="Instances:stop")
    @POST
    @Path(value="/{instance}/stop")
    @Produces(value={"application/json"})
    public Operation stop(@PathParam(value="instance") String var1);

    @Named(value="Instances:list")
    @GET
    public ListPage<Instance> listPage(@Nullable @QueryParam(value="pageToken") String var1, ListOptions var2);

    @Named(value="Instances:list")
    @GET
    @Transform(value=InstancePages.class)
    public Iterator<ListPage<Instance>> list();

    @Named(value="Instances:list")
    @GET
    @Transform(value=InstancePages.class)
    public Iterator<ListPage<Instance>> list(ListOptions var1);

    public static final class InstancePages
    extends BaseCallerArg0ToIteratorOfListPage<Instance, InstancePages> {
        private final GoogleComputeEngineApi api;

        @Inject
        InstancePages(GoogleComputeEngineApi api) {
            this.api = api;
        }

        @Override
        protected Function<String, ListPage<Instance>> fetchNextPage(final String zoneName, final ListOptions options) {
            return new Function<String, ListPage<Instance>>(){

                @Override
                public ListPage<Instance> apply(String pageToken) {
                    return InstancePages.this.api.instancesInZone(zoneName).listPage(pageToken, options);
                }
            };
        }
    }
}

