/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ovf.xml;

import java.net.URI;
import java.util.Map;
import javax.annotation.Resource;
import javax.inject.Inject;
import javax.inject.Provider;
import org.jclouds.logging.Logger;
import org.jclouds.ovf.Disk;
import org.jclouds.ovf.DiskSection;
import org.jclouds.ovf.xml.SectionHandler;
import org.jclouds.util.SaxUtils;
import org.xml.sax.Attributes;

public class DiskSectionHandler
extends SectionHandler<DiskSection, DiskSection.Builder> {
    @Resource
    protected Logger logger = Logger.NULL;
    protected Disk.Builder diskBuilder = Disk.builder();

    @Inject
    public DiskSectionHandler(Provider<DiskSection.Builder> builderProvider) {
        super(builderProvider);
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attrs) {
        Map<String, String> attributes = SaxUtils.cleanseAttributes(attrs);
        if (SaxUtils.equalsOrSuffix(qName, "Disk")) {
            this.diskBuilder.id(attributes.get("diskId"));
            this.diskBuilder.capacity(this.attemptToParse(attributes.get("capacity"), "capacity", attributes.get("diskId")));
            this.diskBuilder.parentRef(attributes.get("parentRef"));
            this.diskBuilder.fileRef(attributes.get("fileRef"));
            if (attributes.containsKey("format")) {
                this.diskBuilder.format(URI.create(attributes.get("format")));
            }
            this.diskBuilder.populatedSize(this.attemptToParse(attributes.get("populatedSize"), "populatedSize", attributes.get("diskId")));
            this.diskBuilder.capacityAllocationUnits(attributes.get("capacityAllocationUnits"));
        }
    }

    private Long attemptToParse(String toParse, String key, String diskId) {
        Long val = null;
        if (toParse != null) {
            try {
                val = Long.valueOf(toParse);
            }
            catch (NumberFormatException e) {
                this.logger.warn("%s for disk %s not a number [%s]", key, diskId, toParse);
            }
        }
        return val;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void endElement(String uri, String localName, String qName) {
        if (SaxUtils.equalsOrSuffix(qName, "Info")) {
            ((DiskSection.Builder)this.builder).info(SaxUtils.currentOrNull(this.currentText));
        } else if (SaxUtils.equalsOrSuffix(qName, "Disk")) {
            try {
                ((DiskSection.Builder)this.builder).disk(this.diskBuilder.build());
            }
            finally {
                this.diskBuilder = Disk.builder();
            }
        }
        super.endElement(uri, localName, qName);
    }
}

