/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.api.impl;

import es.bsc.compss.COMPSsConstants;
import es.bsc.compss.api.ApplicationRunner;
import es.bsc.compss.api.COMPSsRuntime;
import es.bsc.compss.api.TaskMonitor;
import es.bsc.compss.comm.Comm;
import es.bsc.compss.components.impl.AccessProcessor;
import es.bsc.compss.components.impl.TaskDispatcher;
import es.bsc.compss.components.monitor.impl.GraphGenerator;
import es.bsc.compss.components.monitor.impl.RuntimeMonitor;
import es.bsc.compss.loader.LoaderAPI;
import es.bsc.compss.loader.total.ObjectRegistry;
import es.bsc.compss.loader.total.StreamRegistry;
import es.bsc.compss.scheduler.types.ActionOrchestrator;
import es.bsc.compss.types.Application;
import es.bsc.compss.types.BindingObject;
import es.bsc.compss.types.CoreElementDefinition;
import es.bsc.compss.types.DoNothingTaskMonitor;
import es.bsc.compss.types.ErrorHandler;
import es.bsc.compss.types.WallClockTimerTask;
import es.bsc.compss.types.annotations.parameter.DataType;
import es.bsc.compss.types.annotations.parameter.Direction;
import es.bsc.compss.types.annotations.parameter.OnFailure;
import es.bsc.compss.types.annotations.parameter.StdIOStream;
import es.bsc.compss.types.data.accessparams.AccessParams;
import es.bsc.compss.types.data.accessparams.FileAccessParams;
import es.bsc.compss.types.data.location.BindingObjectLocation;
import es.bsc.compss.types.data.location.DataLocation;
import es.bsc.compss.types.data.location.PersistentLocation;
import es.bsc.compss.types.data.location.ProtocolType;
import es.bsc.compss.types.implementations.ImplementationDescription;
import es.bsc.compss.types.implementations.ImplementationSignature;
import es.bsc.compss.types.listeners.CancelTaskGroupOnResourceCreation;
import es.bsc.compss.types.parameter.BasicTypeParameter;
import es.bsc.compss.types.parameter.BindingObjectParameter;
import es.bsc.compss.types.parameter.CollectionParameter;
import es.bsc.compss.types.parameter.DictCollectionParameter;
import es.bsc.compss.types.parameter.DirectoryParameter;
import es.bsc.compss.types.parameter.ExternalPSCOParameter;
import es.bsc.compss.types.parameter.ExternalStreamParameter;
import es.bsc.compss.types.parameter.FileParameter;
import es.bsc.compss.types.parameter.ObjectParameter;
import es.bsc.compss.types.parameter.Parameter;
import es.bsc.compss.types.parameter.StreamParameter;
import es.bsc.compss.types.resources.MasterResourceImpl;
import es.bsc.compss.types.resources.MethodResourceDescription;
import es.bsc.compss.types.resources.Resource;
import es.bsc.compss.types.resources.ResourcesPool;
import es.bsc.compss.types.uri.MultiURI;
import es.bsc.compss.types.uri.SimpleURI;
import es.bsc.compss.util.CoreManager;
import es.bsc.compss.util.EnvironmentLoader;
import es.bsc.compss.util.ErrorManager;
import es.bsc.compss.util.FileOpsManager;
import es.bsc.compss.util.ResourceManager;
import es.bsc.compss.util.RuntimeConfigManager;
import es.bsc.compss.util.TraceEvent;
import es.bsc.compss.util.Tracer;
import es.bsc.compss.worker.COMPSsException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Timer;
import java.util.TimerTask;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class COMPSsRuntimeImpl
implements COMPSsRuntime,
LoaderAPI,
ErrorHandler {
    private static final String WARN_IT_FILE_NOT_READ = "WARNING: COMPSs Properties file could not be read";
    private static final String WARN_FILE_EMPTY_DEFAULT = "WARNING: COMPSs Properties file is null. Setting default values";
    private static final String WARN_VERSION_PROPERTIES = "WARNING: COMPSs Runtime VERSION-BUILD properties file could not be read";
    private static final String ERROR_FILE_NAME = "ERROR: Cannot parse file name";
    private static final String ERROR_DIR_NAME = "ERROR: Not a valid directory";
    private static final String ERROR_BINDING_OBJECT_PARAMS = "ERROR: Incorrect number of parameters for external objects";
    private static final String WARN_WRONG_DIRECTION = "WARNING: Invalid parameter direction: ";
    private static final String WARN_NULL_PARAM = "WARNING: Optional parameter: ";
    private static String COMPSs_VERSION = null;
    private static String COMPSs_BUILDNUMBER = null;
    private static boolean initialized = false;
    private boolean stopped = false;
    public static final int NUM_FIELDS_PER_PARAM = 9;
    protected static final String DEFAULT_LANG_STR = System.getProperty("compss.lang");
    protected static final COMPSsConstants.Lang DEFAULT_LANG = DEFAULT_LANG_STR == null ? COMPSsConstants.Lang.JAVA : COMPSsConstants.Lang.valueOf(DEFAULT_LANG_STR.toUpperCase());
    private static ObjectRegistry oReg;
    private static StreamRegistry sReg;
    private static AccessProcessor ap;
    private static TaskDispatcher td;
    private static GraphGenerator graphMonitor;
    private static RuntimeMonitor runtimeMonitor;
    private static Timer timer;
    private static final Logger LOGGER;
    private static final TaskMonitor DO_NOTHING_MONITOR;

    private static void setPropertyFromRuntime(String propertyName, String managerValue) {
        if (managerValue != null && System.getProperty(propertyName) == null) {
            System.setProperty(propertyName, managerValue);
        }
    }

    private static void setPropertiesFromRuntime(RuntimeConfigManager manager) {
        try {
            if (manager != null) {
                COMPSsRuntimeImpl.setPropertyFromRuntime("compss.uuid", manager.getDeploymentId());
                COMPSsRuntimeImpl.setPropertyFromRuntime("compss.masterName", manager.getMasterName());
                COMPSsRuntimeImpl.setPropertyFromRuntime("compss.masterPort", manager.getMasterPort());
                COMPSsRuntimeImpl.setPropertyFromRuntime("compss.appName", manager.getAppName());
                COMPSsRuntimeImpl.setPropertyFromRuntime("compss.summary", manager.getTaskSummary());
                COMPSsRuntimeImpl.setPropertyFromRuntime("compss.baseLogDir", manager.getCOMPSsBaseLogDir());
                COMPSsRuntimeImpl.setPropertyFromRuntime("compss.specificLogDir", manager.getSpecificLogDir());
                COMPSsRuntimeImpl.setPropertyFromRuntime("log4j.configurationFile", manager.getLog4jConfiguration());
                COMPSsRuntimeImpl.setPropertyFromRuntime("compss.resources.file", manager.getResourcesFile());
                COMPSsRuntimeImpl.setPropertyFromRuntime("compss.resources.schema", manager.getResourcesSchema());
                COMPSsRuntimeImpl.setPropertyFromRuntime("compss.project.file", manager.getProjectFile());
                COMPSsRuntimeImpl.setPropertyFromRuntime("compss.project.schema", manager.getProjectSchema());
                COMPSsRuntimeImpl.setPropertyFromRuntime("compss.scheduler", manager.getScheduler());
                COMPSsRuntimeImpl.setPropertyFromRuntime("compss.monitor", Long.toString(manager.getMonitorInterval()));
                COMPSsRuntimeImpl.setPropertyFromRuntime("gat.adaptor.path", manager.getGATAdaptor());
                COMPSsRuntimeImpl.setPropertyFromRuntime("gat.broker.adaptor", manager.getGATBrokerAdaptor());
                COMPSsRuntimeImpl.setPropertyFromRuntime("gat.file.adaptor", manager.getGATFileAdaptor());
                if (System.getProperty("compss.execution.reuseOnBlock") == null || System.getProperty("compss.execution.reuseOnBlock").isEmpty()) {
                    System.setProperty("compss.execution.reuseOnBlock", Boolean.toString(manager.getReuseResourcesOnBlock()));
                }
                if (System.getProperty("compss.execution.nested.enabled") == null || System.getProperty("compss.execution.nested.enabled").isEmpty()) {
                    System.setProperty("compss.execution.nested.enabled", Boolean.toString(manager.isNestedDetectionEnabled()));
                }
                COMPSsRuntimeImpl.setPropertyFromRuntime("compss.worker.cp", manager.getWorkerCP());
                COMPSsRuntimeImpl.setPropertyFromRuntime("compss.worker.jvm_opts", manager.getWorkerJVMOpts());
                if (System.getProperty("compss.worker.cpu_affinity") == null || System.getProperty("compss.worker.cpu_affinity").isEmpty()) {
                    System.setProperty("compss.worker.cpu_affinity", Boolean.toString(manager.isWorkerCPUAffinityEnabled()));
                }
                if (System.getProperty("compss.worker.gpu_affinity") == null || System.getProperty("compss.worker.gpu_affinity").isEmpty()) {
                    System.setProperty("compss.worker.gpu_affinity", Boolean.toString(manager.isWorkerGPUAffinityEnabled()));
                }
                COMPSsRuntimeImpl.setPropertyFromRuntime("compss.serviceName", manager.getServiceName());
                if (System.getProperty("compss.comm") == null) {
                    if (manager.getCommAdaptor() != null) {
                        System.setProperty("compss.comm", manager.getCommAdaptor());
                    } else {
                        System.setProperty("compss.comm", "es.bsc.compss.nio.master.NIOAdaptor");
                    }
                }
                if (System.getProperty("compss.conn") == null) {
                    if (manager.getConn() != null) {
                        System.setProperty("compss.conn", manager.getConn());
                    } else {
                        System.setProperty("compss.conn", "es.bsc.compss.connectors.DefaultSSHConnector");
                    }
                }
                if (System.getProperty("gat.debug") == null) {
                    System.setProperty("gat.debug", Boolean.toString(manager.isGATDebug()));
                }
                if (System.getProperty("compss.lang") == null) {
                    System.setProperty("compss.lang", manager.getLang());
                }
                if (System.getProperty("compss.graph") == null) {
                    System.setProperty("compss.graph", Boolean.toString(manager.isGraph()));
                }
                if (System.getProperty("compss.tracing") == null) {
                    System.setProperty("compss.tracing", String.valueOf(manager.getTracing()));
                }
                if (System.getProperty("compss.extrae.file") == null) {
                    System.setProperty("compss.extrae.file", manager.getCustomExtraeFile());
                }
                if (System.getProperty("compss.tracing.task.dependencies") == null) {
                    System.setProperty("compss.tracing.task.dependencies", String.valueOf(manager.getTracingTaskDep()));
                }
                if (System.getProperty("compss.extrae.file.python") == null) {
                    System.setProperty("compss.extrae.file.python", manager.getCustomExtraeFilePython());
                }
                if (System.getProperty("compss.task.execution") == null || System.getProperty("compss.task.execution").equals("")) {
                    System.setProperty("compss.task.execution", COMPSsConstants.TaskExecution.COMPSS.toString());
                }
                if (manager.getContext() != null) {
                    System.setProperty("compss.context", manager.getContext());
                }
                System.setProperty("compss.to.file", Boolean.toString(manager.isToFile()));
            } else {
                COMPSsRuntimeImpl.setDefaultProperties();
            }
        }
        catch (Exception e) {
            System.err.println(WARN_IT_FILE_NOT_READ);
            e.printStackTrace();
        }
    }

    private static void setDefaultProperties() {
        System.err.println(WARN_FILE_EMPTY_DEFAULT);
        COMPSsRuntimeImpl.setDefaultProperty("compss.uuid", COMPSsConstants.DEFAULT_DEPLOYMENT_ID);
        COMPSsRuntimeImpl.setDefaultProperty("compss.resources.schema", COMPSsConstants.DEFAULT_RES_SCHEMA);
        COMPSsRuntimeImpl.setDefaultProperty("compss.project.schema", COMPSsConstants.DEFAULT_PROJECT_SCHEMA);
        COMPSsRuntimeImpl.setDefaultProperty("gat.adaptor.path", COMPSsConstants.DEFAULT_GAT_ADAPTOR_LOCATION);
        COMPSsRuntimeImpl.setDefaultProperty("compss.comm", "es.bsc.compss.nio.master.NIOAdaptor");
        COMPSsRuntimeImpl.setDefaultProperty("compss.execution.reuseOnBlock", "true");
        COMPSsRuntimeImpl.setDefaultProperty("compss.execution.nested.enabled", "false");
        COMPSsRuntimeImpl.setDefaultProperty("compss.conn", "es.bsc.compss.connectors.DefaultSSHConnector");
        COMPSsRuntimeImpl.setDefaultProperty("compss.scheduler", "es.bsc.compss.components.impl.TaskScheduler");
        COMPSsRuntimeImpl.setDefaultProperty("compss.tracing", "0");
        COMPSsRuntimeImpl.setDefaultProperty("compss.extrae.file", "null");
        COMPSsRuntimeImpl.setDefaultProperty("compss.task.execution", COMPSsConstants.TaskExecution.COMPSS.toString());
    }

    private static void setDefaultProperty(String propertyName, String defaultValue) {
        String propertyValue = System.getProperty(propertyName);
        if (propertyValue == null || propertyValue.isEmpty()) {
            System.setProperty(propertyName, defaultValue);
        }
    }

    private static InputStream findPropertiesConfigFile() {
        InputStream stream = COMPSsRuntimeImpl.class.getResourceAsStream("compss.properties");
        if (stream == null && (stream = COMPSsRuntimeImpl.class.getResourceAsStream(File.separator + "compss.properties")) == null && (stream = COMPSsRuntimeImpl.class.getClassLoader().getResourceAsStream("compss.properties")) == null && (stream = COMPSsRuntimeImpl.class.getClassLoader().getResourceAsStream(File.separator + "compss.properties")) == null && (stream = ClassLoader.getSystemResourceAsStream("compss.properties")) == null && (stream = ClassLoader.getSystemResourceAsStream(File.separator + "compss.properties")) == null && (stream = COMPSsRuntimeImpl.class.getClassLoader().getParent().getResourceAsStream("compss.properties")) == null) {
            stream = COMPSsRuntimeImpl.class.getClassLoader().getParent().getResourceAsStream(File.separator + "compss.properties");
        }
        return stream;
    }

    public COMPSsRuntimeImpl() {
        try {
            Properties props = new Properties();
            props.load(this.getClass().getResourceAsStream("/version.properties"));
            COMPSs_VERSION = props.getProperty("compss.version");
            COMPSs_BUILDNUMBER = props.getProperty("compss.build");
        }
        catch (IOException e) {
            LOGGER.warn(WARN_VERSION_PROPERTIES);
        }
        if (COMPSs_VERSION == null) {
            LOGGER.debug("Deploying COMPSs Runtime");
        } else if (COMPSs_BUILDNUMBER == null) {
            LOGGER.debug("Deploying COMPSs Runtime v" + COMPSs_VERSION);
        } else if (COMPSs_BUILDNUMBER.endsWith("rnull")) {
            COMPSs_BUILDNUMBER = COMPSs_BUILDNUMBER.substring(0, COMPSs_BUILDNUMBER.length() - 6);
            LOGGER.debug("Deploying COMPSs Runtime v" + COMPSs_VERSION + " (build " + COMPSs_BUILDNUMBER + ")");
        } else {
            LOGGER.debug("Deploying COMPSs Runtime v" + COMPSs_VERSION + " (build " + COMPSs_BUILDNUMBER + ")");
        }
        ErrorManager.init(this);
        ((MasterResourceImpl)Comm.getAppHost()).setupNestedSupport(this, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void startIT() {
        if (Tracer.extraeEnabled()) {
            Tracer.emitEvent(0L, TraceEvent.STATIC_IT.getType());
            Tracer.emitEvent(TraceEvent.START.getId(), TraceEvent.START.getType());
        }
        Thread.currentThread().setName("APPLICATION");
        if (COMPSs_VERSION == null) {
            LOGGER.warn("Starting COMPSs Runtime");
        } else if (COMPSs_BUILDNUMBER == null) {
            LOGGER.warn("Starting COMPSs Runtime v" + COMPSs_VERSION);
        } else if (COMPSs_BUILDNUMBER.endsWith("rnull")) {
            COMPSs_BUILDNUMBER = COMPSs_BUILDNUMBER.substring(0, COMPSs_BUILDNUMBER.length() - 6);
            LOGGER.warn("Starting COMPSs Runtime v" + COMPSs_VERSION + " (build " + COMPSs_BUILDNUMBER + ")");
        } else {
            LOGGER.warn("Starting COMPSs Runtime v" + COMPSs_VERSION + " (build " + COMPSs_BUILDNUMBER + ")");
        }
        if (!initialized) {
            COMPSsRuntimeImpl cOMPSsRuntimeImpl = this;
            synchronized (cOMPSsRuntimeImpl) {
                LOGGER.debug("Initializing components");
                td = new TaskDispatcher();
                ap = new AccessProcessor(td);
                if (GraphGenerator.isEnabled()) {
                    graphMonitor = new GraphGenerator();
                    ap.setGM(graphMonitor);
                }
                if (RuntimeMonitor.isEnabled()) {
                    runtimeMonitor = new RuntimeMonitor(ap, td, graphMonitor, Long.parseLong(System.getProperty("compss.monitor")));
                }
                initialized = true;
                LOGGER.debug("Ready to process tasks");
            }
        }
        String className = Thread.currentThread().getStackTrace()[2].getClassName();
        LOGGER.debug("Initializing " + className + "Itf");
        try {
            td.addInterface(Class.forName(className + "Itf"));
        }
        catch (ClassNotFoundException cnfe) {
            ErrorManager.fatal("Error adding interface " + className + "Itf", cnfe);
        }
        if (Tracer.extraeEnabled()) {
            Tracer.emitEvent(0L, TraceEvent.START.getType());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stopIT(boolean terminate) {
        COMPSsRuntimeImpl cOMPSsRuntimeImpl = this;
        synchronized (cOMPSsRuntimeImpl) {
            if (!this.stopped) {
                boolean taskSummaryEnabled;
                if (Tracer.extraeEnabled()) {
                    Tracer.emitEvent(TraceEvent.STOP.getId(), TraceEvent.STOP.getType());
                }
                LOGGER.debug("Stopping Wall Clock limit Timer");
                if (timer != null) {
                    timer.cancel();
                }
                boolean bl = taskSummaryEnabled = System.getProperty("compss.summary") != null && !System.getProperty("compss.summary").isEmpty() && Boolean.parseBoolean(System.getProperty("compss.summary"));
                if (taskSummaryEnabled) {
                    td.getTaskSummary(LOGGER);
                }
                LOGGER.info("Stop IT reached");
                if (GraphGenerator.isEnabled()) {
                    LOGGER.debug("Stopping Graph generation...");
                }
                if (RuntimeMonitor.isEnabled()) {
                    LOGGER.debug("Stopping Monitor...");
                    runtimeMonitor.shutdown();
                }
                LOGGER.debug("Stopping AP...");
                if (ap != null) {
                    ap.shutdown();
                } else {
                    LOGGER.debug("AP was not initialized...");
                }
                LOGGER.debug("Stopping TD...");
                if (td != null) {
                    td.shutdown();
                } else {
                    LOGGER.debug("TD was not initialized...");
                }
                LOGGER.debug("Stopping Comm...");
                Comm.stop(CoreManager.getSignaturesToCEIds());
                LOGGER.debug("Runtime stopped");
                this.stopped = true;
            }
        }
        LOGGER.warn("Execution Finished");
    }

    @Override
    public String getApplicationDirectory() {
        return Comm.getAppHost().getAppLogDirPath();
    }

    public static ActionOrchestrator getOrchestrator() {
        return td;
    }

    @Override
    public long registerApplication() {
        Application app = Application.registerApplication();
        return app.getId();
    }

    @Override
    public void registerApplication(Long appId) {
        Application.registerApplication(appId);
    }

    @Override
    public long registerApplication(String parallelismSource, ApplicationRunner runner) {
        Application app = Application.registerApplication(parallelismSource, runner);
        return app.getId();
    }

    @Override
    public void registerApplication(Long appId, String parallelismSource, ApplicationRunner runner) {
        Application.registerApplication(appId, parallelismSource, runner);
    }

    @Override
    public void deregisterApplication(Long appId) {
        Application.deregisterApplication(appId);
    }

    @Override
    public void registerCoreElement(String coreElementSignature, String implSignature, String implConstraints, String implType, String implIO, String ... implTypeArgs) {
        LOGGER.info("Registering CoreElement " + coreElementSignature);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("\t - Implementation: " + implSignature);
            LOGGER.debug("\t - Constraints   : " + implConstraints);
            LOGGER.debug("\t - Type          : " + implType);
            LOGGER.debug("\t - I/O            : " + implIO);
            LOGGER.debug("\t - ImplTypeArgs  : ");
            for (String implTypeArg : implTypeArgs) {
                LOGGER.debug("\t\t Arg: " + implTypeArg);
            }
        }
        MethodResourceDescription mrd = new MethodResourceDescription(implConstraints);
        boolean implisIO = Boolean.parseBoolean(implIO);
        if (implisIO) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Nulling computing resources for I/O task: " + implSignature);
            }
            mrd.setIOResources();
        }
        CoreElementDefinition ced = new CoreElementDefinition();
        ced.setCeSignature(coreElementSignature);
        ImplementationDescription implDef = ImplementationDescription.defineImplementation(implType, implSignature, mrd, implTypeArgs);
        ced.addImplementation(implDef);
        td.registerNewCoreElement(ced);
    }

    @Override
    public void registerCoreElement(CoreElementDefinition ced) {
        LOGGER.info("Registering CoreElement " + ced.getCeSignature());
        if (LOGGER.isDebugEnabled()) {
            int implId = 0;
            for (ImplementationDescription<?, ?> implDef : ced.getImplementations()) {
                LOGGER.debug("\t - Implementation " + implId + ":");
                try {
                    LOGGER.debug(implDef.toString());
                }
                catch (Exception e) {
                    LOGGER.debug("Error printing implDef", (Throwable)e);
                }
            }
        }
        td.registerNewCoreElement(ced);
    }

    @Override
    public void registerData(Long appId, DataType type, Object stub, String data) {
        Application app = Application.registerApplication(appId);
        switch (type) {
            case DIRECTORY_T: 
            case FILE_T: {
                try {
                    DataLocation loc;
                    String fileName = (String)stub;
                    try {
                        loc = this.createLocation(ProtocolType.FILE_URI, fileName);
                    }
                    catch (IOException ioe) {
                        ErrorManager.fatal(ERROR_FILE_NAME, ioe);
                        return;
                    }
                    ap.registerRemoteFile(app, loc, data);
                }
                catch (NullPointerException npe) {
                    LOGGER.error(ERROR_FILE_NAME, (Throwable)npe);
                    ErrorManager.fatal(ERROR_FILE_NAME, npe);
                }
                break;
            }
            case OBJECT_T: 
            case PSCO_T: {
                int hashcode = oReg.newObjectParameter(appId, stub);
                ap.registerRemoteObject(app, hashcode, data);
                break;
            }
            case STREAM_T: {
                break;
            }
            case EXTERNAL_STREAM_T: {
                try {
                    String fileName = (String)stub;
                    new File(fileName).getName();
                }
                catch (NullPointerException npe) {
                    LOGGER.error(ERROR_FILE_NAME, (Throwable)npe);
                    ErrorManager.fatal(ERROR_FILE_NAME, npe);
                }
                break;
            }
            case EXTERNAL_PSCO_T: {
                break;
            }
            case BINDING_OBJECT_T: {
                String value = (String)stub;
                if (value.contains(":")) {
                    String[] fields = value.split(":");
                    if (fields.length == 3) break;
                    LOGGER.error("ERROR: Incorrect number of parameters for external objects received value is " + value);
                    ErrorManager.fatal("ERROR: Incorrect number of parameters for external objects received value is " + value);
                    break;
                }
                LOGGER.error("ERROR: Incorrect number of parameters for external objects received value is " + value);
                ErrorManager.fatal("ERROR: Incorrect number of parameters for external objects received value is " + value);
                break;
            }
            case COLLECTION_T: {
                ap.registerRemoteCollection(app, (String)stub, data);
                break;
            }
            case DICT_COLLECTION_T: {
                throw new UnsupportedOperationException("Not implemented yet.");
            }
        }
    }

    @Override
    public int executeTask(Long appId, String methodClass, String onFailure, int timeOut, String methodName, boolean isPrioritary, int numNodes, boolean isReduce, int reduceChunkSize, boolean isReplicated, boolean isDistributed, boolean hasTarget, Integer numReturns, int parameterCount, Object ... parameters) {
        return this.executeTask(appId, null, COMPSsConstants.Lang.C, false, methodClass, methodName, null, OnFailure.valueOf(onFailure), timeOut, isPrioritary, 1, false, 0, isReplicated, isDistributed, hasTarget, numReturns, parameterCount, parameters);
    }

    @Override
    public int executeTask(Long appId, String signature, String onFailure, int timeOut, boolean isPrioritary, int numNodes, boolean isReduce, int reduceChunkSize, boolean isReplicated, boolean isDistributed, boolean hasTarget, Integer numReturns, int parameterCount, Object ... parameters) {
        return this.executeTask(appId, null, COMPSsConstants.Lang.PYTHON, true, null, null, signature, OnFailure.valueOf(onFailure), timeOut, isPrioritary, numNodes, isReduce, reduceChunkSize, isReplicated, isDistributed, hasTarget, numReturns, parameterCount, parameters);
    }

    @Override
    public int executeTask(Long appId, TaskMonitor monitor, COMPSsConstants.Lang lang, String methodClass, String methodName, boolean isPrioritary, int numNodes, boolean isReduce, int reduceChunkSize, boolean isReplicated, boolean isDistributed, boolean hasTarget, int parameterCount, OnFailure onFailure, int timeOut, Object ... parameters) {
        return this.executeTask(appId, monitor, lang, false, methodClass, methodName, null, onFailure, timeOut, isPrioritary, numNodes, isReduce, reduceChunkSize, isReplicated, isDistributed, hasTarget, null, parameterCount, parameters);
    }

    @Override
    public int executeTask(Long appId, TaskMonitor monitor, String namespace, String service, String port, String operation, boolean isPrioritary, int numNodes, boolean isReduce, int reduceChunkSize, boolean isReplicated, boolean isDistributed, boolean hasTarget, int parameterCount, OnFailure onFailure, int timeOut, Object ... parameters) {
        Application app;
        List<Parameter> pars;
        boolean hasReturn;
        int numReturns;
        if (Tracer.extraeEnabled()) {
            Tracer.emitEvent(TraceEvent.TASK.getId(), TraceEvent.TASK.getType());
        }
        if (numNodes != 1 || isReplicated || isDistributed) {
            ErrorManager.fatal("ERROR: Unsupported feature for Services: multi-node, replicated or distributed");
        }
        LOGGER.info("Creating task from service " + service + ", namespace " + namespace + ", port " + port + ", operation " + operation + " for application " + appId);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("There " + (parameterCount > 1 ? "are " : "is ") + parameterCount + " parameter" + (parameterCount > 1 ? "s" : ""));
        }
        int n = numReturns = (hasReturn = this.hasReturn(pars = this.processParameters(app = Application.registerApplication(appId), parameterCount, parameters))) ? 1 : 0;
        if (monitor == null) {
            monitor = DO_NOTHING_MONITOR;
        }
        int task = ap.newTask(app, monitor, namespace, service, port, operation, isPrioritary, isReduce, reduceChunkSize, hasTarget, numReturns, pars, onFailure, timeOut);
        for (Parameter p : pars) {
            if (!p.getDirection().equals((Object)Direction.IN_DELETE)) continue;
            this.processDelete(app, p);
        }
        if (Tracer.extraeEnabled()) {
            Tracer.emitEvent(0L, TraceEvent.TASK.getType());
        }
        return task;
    }

    @Override
    public int executeTask(Long appId, TaskMonitor monitor, String serviceName, String resource, String request, String payload, String payloadType, String produces, String updates, String declareMethodFullyQualifiedName, boolean isPrioritary, int numNodes, boolean isReduce, int reduceChunkSize, boolean isReplicated, boolean isDistributed, boolean hasTarget, int parameterCount, OnFailure onFailure, int timeOut, Object ... parameters) {
        Application app;
        List<Parameter> pars;
        boolean hasReturn;
        int numReturns;
        if (Tracer.extraeEnabled()) {
            Tracer.emitEvent(TraceEvent.TASK.getId(), TraceEvent.TASK.getType());
        }
        if (numNodes != 1 || isReplicated || isDistributed) {
            ErrorManager.fatal("ERROR: Unsupported feature for HTTP: multi-node, replicated or distributed");
        }
        LOGGER.info("Creating HTTP task with service name " + serviceName + " and resource " + resource + ", for application " + appId + "and declaring class:" + declareMethodFullyQualifiedName);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("There " + (parameterCount > 1 ? "are " : "is ") + parameterCount + " parameter" + (parameterCount > 1 ? "s" : ""));
        }
        int n = numReturns = (hasReturn = this.hasReturn(pars = this.processParameters(app = Application.registerApplication(appId), parameterCount, parameters))) ? 1 : 0;
        if (monitor == null) {
            monitor = DO_NOTHING_MONITOR;
        }
        int task = ap.newTask(app, monitor, serviceName, resource, request, payload, payloadType, produces, updates, declareMethodFullyQualifiedName, isPrioritary, isReduce, reduceChunkSize, hasTarget, numReturns, pars, onFailure, timeOut);
        for (Parameter p : pars) {
            if (!p.getDirection().equals((Object)Direction.IN_DELETE)) continue;
            this.processDelete(app, p);
        }
        if (Tracer.extraeEnabled()) {
            Tracer.emitEvent(0L, TraceEvent.TASK.getType());
        }
        return task;
    }

    public int executeTask(Long appId, TaskMonitor monitor, COMPSsConstants.Lang lang, boolean hasSignature, String methodClass, String methodName, String signature, OnFailure onFailure, int timeOut, boolean isPrioritary, int numNodes, boolean isReduce, int reduceChunkSize, boolean isReplicated, boolean isDistributed, boolean hasTarget, Integer numReturns, int parameterCount, Object ... parameters) {
        if (Tracer.extraeEnabled()) {
            Tracer.emitEvent(TraceEvent.TASK.getId(), TraceEvent.TASK.getType());
        }
        if (hasSignature) {
            LOGGER.info("Creating task from method " + signature + " for application " + appId);
        } else {
            LOGGER.info("Creating task from method " + methodName + " in " + methodClass + " for application " + appId);
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("There " + (parameterCount == 1 ? "is " : "are ") + parameterCount + " parameter" + (parameterCount > 1 ? "s" : ""));
        }
        Application app = Application.registerApplication(appId);
        List<Parameter> pars = this.processParameters(app, parameterCount, parameters);
        if (numReturns == null) {
            numReturns = this.hasReturn(pars) ? 1 : 0;
        }
        if (!hasSignature) {
            signature = ImplementationSignature.getMethodSignature(methodClass, methodName, hasTarget, numReturns, pars);
        }
        if (monitor == null) {
            monitor = DO_NOTHING_MONITOR;
        }
        if (lang == null) {
            lang = DEFAULT_LANG;
        }
        int task = ap.newTask(app, monitor, lang, signature, isPrioritary, numNodes, isReduce, reduceChunkSize, isReplicated, isDistributed, hasTarget, numReturns, pars, onFailure, timeOut);
        for (Parameter p : pars) {
            if (!p.getDirection().equals((Object)Direction.IN_DELETE)) continue;
            this.processDelete(app, p);
        }
        if (Tracer.extraeEnabled()) {
            Tracer.emitEvent(0L, TraceEvent.TASK.getType());
        }
        return task;
    }

    @Override
    public void noMoreTasks(Long appId) {
        Application app = Application.registerApplication(appId);
        this.noMoreTasks(app);
    }

    public void noMoreTasks(Application app) {
        if (Tracer.extraeEnabled()) {
            Tracer.emitEvent(TraceEvent.NO_MORE_TASKS.getId(), TraceEvent.NO_MORE_TASKS.getType());
        }
        LOGGER.info("No more tasks for app " + app.getId());
        ap.noMoreTasks(app);
        app.cancelTimerTask();
        LOGGER.debug("Getting Result Files for app" + app.getId());
        ap.getResultFiles(app);
        if (Tracer.extraeEnabled()) {
            Tracer.emitEvent(0L, TraceEvent.NO_MORE_TASKS.getType());
        }
    }

    @Override
    public void barrier(Long appId) {
        this.barrier(appId, false);
    }

    @Override
    public void barrier(Long appId, boolean noMoreTasks) {
        if (Tracer.extraeEnabled()) {
            Tracer.emitEvent(TraceEvent.WAIT_FOR_ALL_TASKS.getId(), TraceEvent.WAIT_FOR_ALL_TASKS.getType());
        }
        Application app = Application.registerApplication(appId);
        LOGGER.info("Barrier for app " + appId + " with noMoreTasks = " + noMoreTasks);
        if (noMoreTasks) {
            this.noMoreTasks(app);
        } else {
            ap.barrier(app);
        }
        if (Tracer.extraeEnabled()) {
            Tracer.emitEvent(0L, TraceEvent.WAIT_FOR_ALL_TASKS.getType());
        }
    }

    @Override
    public void barrierGroup(Long appId, String groupName) throws COMPSsException {
        if (Tracer.extraeEnabled()) {
            Tracer.emitEvent(TraceEvent.WAIT_FOR_ALL_TASKS.getId(), TraceEvent.WAIT_FOR_ALL_TASKS.getType());
        }
        Application app = Application.registerApplication(appId);
        ap.barrierGroup(app, groupName);
        if (Tracer.extraeEnabled()) {
            Tracer.emitEvent(0L, TraceEvent.WAIT_FOR_ALL_TASKS.getType());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean deleteFile(Long appId, String fileName, boolean waitForData) {
        if (fileName == null || fileName.isEmpty()) {
            return false;
        }
        LOGGER.info("Deleting File " + fileName + " with wait for data " + waitForData);
        if (Tracer.extraeEnabled()) {
            Tracer.emitEvent(TraceEvent.DELETE.getId(), TraceEvent.DELETE.getType());
        }
        try {
            DataLocation loc = this.createLocation(ProtocolType.FILE_URI, fileName);
            Application app = Application.registerApplication(appId);
            ap.markForDeletion(app, loc, waitForData);
            if (sReg != null) {
                sReg.deleteTaskFile(appId, fileName);
            }
        }
        catch (IOException ioe) {
            ErrorManager.fatal(ERROR_FILE_NAME, ioe);
        }
        finally {
            if (Tracer.extraeEnabled()) {
                Tracer.emitEvent(0L, TraceEvent.DELETE.getType());
            }
        }
        LOGGER.info("File " + fileName + " Deleted.");
        return true;
    }

    @Override
    public boolean deleteFile(Long appId, String fileName) {
        return this.deleteFile(appId, fileName, true);
    }

    @Override
    public void emitEvent(int type, long id) {
        Tracer.emitEvent(id, type);
    }

    @Override
    public void openTaskGroup(String groupName, boolean implicitBarrier, Long appId) {
        Application app = Application.registerApplication(appId);
        ap.setCurrentTaskGroup(groupName, implicitBarrier, app);
    }

    @Override
    public void closeTaskGroup(String groupName, Long appId) {
        Application app = Application.registerApplication(appId);
        ap.closeCurrentTaskGroup(app);
    }

    @Override
    public String getBindingObject(Long appId, String fileName) {
        LOGGER.debug(" Calling get binding object : " + fileName);
        Application app = Application.registerApplication(appId);
        BindingObjectLocation sourceLocation = new BindingObjectLocation(Comm.getAppHost(), BindingObject.generate(fileName));
        String finalPath = this.mainAccessToBindingObject(app, fileName, sourceLocation);
        LOGGER.debug(" Returning binding object as id: " + finalPath);
        return finalPath;
    }

    @Override
    public boolean deleteBindingObject(Long appId, String fileName) {
        if (fileName == null || fileName.isEmpty()) {
            return false;
        }
        LOGGER.info("Deleting BindingObject " + fileName);
        if (Tracer.extraeEnabled()) {
            Tracer.emitEvent(TraceEvent.DELETE.getId(), TraceEvent.DELETE.getType());
        }
        BindingObject bo = BindingObject.generate(fileName);
        int hashCode = this.externalObjectHashcode(bo.getId());
        ap.markForBindingObjectDeletion(hashCode);
        if (Tracer.extraeEnabled()) {
            Tracer.emitEvent(0L, TraceEvent.DELETE.getType());
        }
        return true;
    }

    @Override
    public void cancelApplicationTasks(Long appId) {
        Application app = Application.registerApplication(appId);
        ap.cancelApplicationTasks(app);
    }

    @Override
    public void deregisterObject(Long appId, Object o) {
        oReg.delete(appId, o);
    }

    @Override
    public void removeObject(Object o, int hashcode) {
        ap.deregisterObject(o);
    }

    @Override
    public int getNumberOfResources() {
        LOGGER.info("Received request for number of active resources");
        return ResourceManager.getTotalNumberOfWorkers();
    }

    @Override
    public void requestResources(Long appId, int numResources, String groupName) {
        LOGGER.info("Received request to create " + numResources + " resources and notify " + groupName + " for application " + appId);
        if (numResources > 0) {
            Application app = Application.registerApplication(appId);
            CancelTaskGroupOnResourceCreation rcl = new CancelTaskGroupOnResourceCreation(ap, app, numResources, groupName);
            ResourceManager.requestResources(1, rcl);
        }
    }

    @Override
    public void freeResources(Long appId, int numResources, String groupName) {
        LOGGER.info("Received request to destroy " + numResources + " resources and notify " + groupName + " for application " + appId);
        Application app = Application.registerApplication(appId);
        if (groupName != null && !groupName.isEmpty()) {
            ap.cancelTaskGroup(app, groupName);
        }
        if (numResources > 0) {
            ResourceManager.freeResources(numResources);
        }
    }

    @Override
    public void getFile(Long appId, String fileName) {
        if (Tracer.extraeEnabled()) {
            Tracer.emitEvent(TraceEvent.GET_FILE.getId(), TraceEvent.GET_FILE.getType());
        }
        DataLocation sourceLocation = null;
        try {
            sourceLocation = this.createLocation(ProtocolType.FILE_URI, fileName);
        }
        catch (IOException ioe) {
            ErrorManager.fatal(ERROR_FILE_NAME, ioe);
        }
        if (sourceLocation == null) {
            ErrorManager.fatal(ERROR_FILE_NAME);
        }
        LOGGER.debug("Getting file " + fileName);
        Application app = Application.registerApplication(appId);
        String renamedPath = this.openFileSystemData(app, fileName, Direction.INOUT, false);
        if (!renamedPath.equals(sourceLocation.getPath())) {
            try {
                String intermediateTmpPath = renamedPath + ".tmp";
                FileOpsManager.moveSync(new File(renamedPath), new File(intermediateTmpPath));
                this.closeFile(app, fileName, Direction.INOUT);
                ap.markForDeletion(app, sourceLocation, true);
                if (sReg != null) {
                    sReg.deleteTaskFile(appId, fileName);
                }
                FileOpsManager.moveSync(new File(intermediateTmpPath), new File(fileName));
            }
            catch (IOException ioe) {
                LOGGER.error("Move not possible ", (Throwable)ioe);
            }
        }
        if (Tracer.extraeEnabled()) {
            Tracer.emitEvent(0L, TraceEvent.GET_FILE.getType());
        }
    }

    @Override
    public void getDirectory(Long appId, String dirName) {
        if (Tracer.extraeEnabled()) {
            Tracer.emitEvent(TraceEvent.GET_DIRECTORY.getId(), TraceEvent.GET_DIRECTORY.getType());
        }
        DataLocation sourceLocation = null;
        try {
            sourceLocation = this.createLocation(ProtocolType.DIR_URI, dirName);
        }
        catch (IOException ioe) {
            ErrorManager.fatal(ERROR_DIR_NAME, ioe);
        }
        if (sourceLocation == null) {
            ErrorManager.fatal(ERROR_DIR_NAME);
        }
        LOGGER.debug("Getting directory " + dirName);
        Application app = Application.registerApplication(appId);
        String renamedPath = this.openFileSystemData(app, dirName, Direction.IN, true);
        try {
            LOGGER.debug("Getting directory renamed path: " + renamedPath);
            String intermediateTmpPath = renamedPath + ".tmp";
            FileOpsManager.moveDirSync(new File(renamedPath), new File(intermediateTmpPath));
            this.closeFile(app, dirName, Direction.IN);
            ap.markForDeletion(app, sourceLocation, true);
            if (sReg != null) {
                sReg.deleteTaskFile(appId, dirName);
            }
            FileOpsManager.moveDirSync(new File(intermediateTmpPath), new File(dirName));
        }
        catch (IOException ioe) {
            LOGGER.error("Move not possible ", (Throwable)ioe);
        }
        if (Tracer.extraeEnabled()) {
            Tracer.emitEvent(0L, TraceEvent.GET_DIRECTORY.getType());
        }
    }

    private void processDelete(Application app, Parameter p) {
        switch (p.getType()) {
            case DIRECTORY_T: {
                ap.markForDeletion(app, ((DirectoryParameter)p).getLocation(), false);
                if (sReg == null) break;
                sReg.deleteTaskFile(app.getId(), ((DirectoryParameter)p).getOriginalName());
                break;
            }
            case FILE_T: {
                ap.markForDeletion(app, ((FileParameter)p).getLocation(), false);
                if (sReg == null) break;
                sReg.deleteTaskFile(app.getId(), ((FileParameter)p).getOriginalName());
                break;
            }
            case BINDING_OBJECT_T: {
                ap.markForBindingObjectDeletion(((BindingObjectParameter)p).getCode());
                break;
            }
            case OBJECT_T: {
                ObjectParameter op = (ObjectParameter)p;
                oReg.delete(app.getId(), op.getValue());
                break;
            }
            case COLLECTION_T: {
                for (Parameter sp : ((CollectionParameter)p).getParameters()) {
                    this.processDelete(app, sp);
                }
                break;
            }
            case DICT_COLLECTION_T: {
                for (Map.Entry<Parameter, Parameter> sp : ((DictCollectionParameter)p).getParameters().entrySet()) {
                    this.processDelete(app, sp.getKey());
                    this.processDelete(app, sp.getValue());
                }
                break;
            }
        }
    }

    @Override
    public Object getObject(Long appId, Object obj, int hashCode, String destDir) {
        Application app = Application.registerApplication(appId);
        if (Tracer.extraeEnabled()) {
            Tracer.emitEvent(TraceEvent.GET_OBJECT.getId(), TraceEvent.GET_OBJECT.getType());
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Getting object with hash code " + hashCode);
        }
        Object oUpdated = this.mainAccessToObject(app, obj, hashCode);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Object obtained " + (oUpdated == null ? oUpdated : Integer.valueOf(oUpdated.hashCode())));
        }
        if (Tracer.extraeEnabled()) {
            Tracer.emitEvent(0L, TraceEvent.GET_OBJECT.getType());
        }
        return oUpdated;
    }

    @Override
    public void serializeObject(Object o, int hashCode, String destDir) {
    }

    @Override
    public ObjectRegistry getObjectRegistry() {
        return oReg;
    }

    @Override
    public StreamRegistry getStreamRegistry() {
        return sReg;
    }

    @Override
    public void setObjectRegistry(ObjectRegistry oReg) {
        COMPSsRuntimeImpl.oReg = oReg;
    }

    @Override
    public void setStreamRegistry(StreamRegistry sReg) {
        COMPSsRuntimeImpl.sReg = sReg;
    }

    @Override
    public String getTempDir() {
        return Comm.getAppHost().getTempDirPath();
    }

    @Override
    public boolean isFileAccessed(Long appId, String fileName) {
        DataLocation loc;
        try {
            loc = this.createLocation(ProtocolType.FILE_URI, fileName);
        }
        catch (IOException ioe) {
            ErrorManager.fatal(ERROR_FILE_NAME, ioe);
            loc = null;
        }
        if (loc != null) {
            Application app = Application.registerApplication(appId);
            return ap.alreadyAccessed(app, loc);
        }
        return false;
    }

    @Override
    public String openFile(Long appId, String fileName, Direction mode) {
        Application app = Application.registerApplication(appId);
        return this.openFileSystemData(app, fileName, mode, false);
    }

    private String openFileSystemData(Application app, String fileName, Direction mode, boolean isDir) {
        String finalPath;
        DataLocation loc;
        LOGGER.info("Opening " + fileName + " in mode " + (Object)((Object)mode));
        TraceEvent tEvent = null;
        if (Tracer.extraeEnabled()) {
            tEvent = isDir ? TraceEvent.OPEN_DIRECTORY : TraceEvent.OPEN_FILE;
            Tracer.emitEvent(tEvent.getId(), tEvent.getType());
        }
        try {
            loc = this.createLocation(isDir ? ProtocolType.DIR_URI : ProtocolType.FILE_URI, fileName);
        }
        catch (IOException ioe) {
            ErrorManager.fatal(ERROR_FILE_NAME, ioe);
            return null;
        }
        AccessParams.AccessMode am = null;
        switch (mode) {
            case IN: 
            case IN_DELETE: {
                am = AccessParams.AccessMode.R;
                break;
            }
            case OUT: {
                am = AccessParams.AccessMode.W;
                break;
            }
            case INOUT: {
                am = AccessParams.AccessMode.RW;
                break;
            }
            case CONCURRENT: {
                am = AccessParams.AccessMode.C;
                break;
            }
            case COMMUTATIVE: {
                am = AccessParams.AccessMode.CV;
            }
        }
        switch (loc.getType()) {
            case PRIVATE: 
            case SHARED: {
                finalPath = this.mainAccessToFile(app, fileName, loc, am, null, isDir);
                if (!LOGGER.isDebugEnabled()) break;
                LOGGER.debug("File " + (isDir ? "(dir) " : "") + "target Location: " + finalPath);
                break;
            }
            case PERSISTENT: {
                finalPath = this.mainAccessToExternalPSCO(app, fileName, loc);
                if (!LOGGER.isDebugEnabled()) break;
                LOGGER.debug("External PSCO target Location: " + finalPath);
                break;
            }
            default: {
                finalPath = null;
                ErrorManager.error("ERROR: Unrecognised protocol requesting " + (isDir ? "openDirectory " : "openFile ") + fileName);
            }
        }
        if (Tracer.extraeEnabled()) {
            Tracer.emitEvent(0L, tEvent.getType());
        }
        return finalPath;
    }

    @Override
    public String openDirectory(Long appId, String dirName, Direction mode) {
        Application app = Application.registerApplication(appId);
        return this.openFileSystemData(app, dirName, mode, true);
    }

    @Override
    public void closeFile(Long appId, String fileName, Direction mode) {
        Application app = Application.registerApplication(appId);
        this.closeFile(app, fileName, mode);
    }

    public void closeFile(Application app, String fileName, Direction mode) {
        DataLocation loc;
        LOGGER.info("Closing " + fileName + " in mode " + (Object)((Object)mode));
        try {
            loc = this.createLocation(ProtocolType.FILE_URI, fileName);
        }
        catch (Exception e) {
            ErrorManager.fatal(ERROR_FILE_NAME, e);
            return;
        }
        AccessParams.AccessMode am = null;
        switch (mode) {
            case IN: 
            case IN_DELETE: {
                am = AccessParams.AccessMode.R;
                break;
            }
            case OUT: {
                am = AccessParams.AccessMode.W;
                break;
            }
            case INOUT: {
                am = AccessParams.AccessMode.RW;
                break;
            }
            case CONCURRENT: {
                am = AccessParams.AccessMode.C;
                break;
            }
            case COMMUTATIVE: {
                am = AccessParams.AccessMode.CV;
            }
        }
        switch (loc.getType()) {
            case PRIVATE: 
            case SHARED: {
                this.finishAccessToFile(app, fileName, loc, am, null);
                if (!LOGGER.isDebugEnabled()) break;
                LOGGER.debug("Closing file " + loc.getPath());
                break;
            }
            case PERSISTENT: {
                ErrorManager.warn("WARN: Cannot close file " + fileName + " with PSCO protocol");
                break;
            }
            case BINDING: {
                ErrorManager.warn("WARN: Cannot close binding object " + fileName + " with PSCO protocol");
                break;
            }
            default: {
                ErrorManager.error("ERROR: Unrecognised protocol requesting closeFile " + fileName);
            }
        }
    }

    @Override
    public boolean handleError() {
        return this.handleFatalError();
    }

    @Override
    public boolean handleFatalError() {
        ErrorManager.info("Shutting down COMPSs...", null, System.err);
        new Thread(){

            @Override
            public void run() {
                ErrorManager.logError("Error detected. Shutting down COMPSs", null);
                COMPSsRuntimeImpl.this.stopIT(true);
                System.err.println("Shutting down the running process");
                System.exit(1);
            }
        }.start();
        return true;
    }

    private boolean hasReturn(List<Parameter> parameters) {
        boolean hasReturn = false;
        if (parameters.size() != 0) {
            Parameter lastParam = parameters.get(parameters.size() - 1);
            DataType type = lastParam.getType();
            hasReturn = lastParam.getDirection() == Direction.OUT && (type == DataType.OBJECT_T || type == DataType.PSCO_T || type == DataType.EXTERNAL_PSCO_T || type == DataType.BINDING_OBJECT_T);
        }
        return hasReturn;
    }

    private int addParameter(Application app, Object content, DataType type, Direction direction, StdIOStream stream, String prefix, String name, String pyType, double weight, boolean keepRename, ArrayList<Parameter> pars, int offset, String[] vals) {
        long appId = app.getId();
        switch (type) {
            case DIRECTORY_T: {
                try {
                    String dirName = content.toString();
                    File dirFile = new File(dirName);
                    String originalName = dirFile.getName();
                    DataLocation location = this.createLocation(ProtocolType.DIR_URI, dirName);
                    pars.add(new DirectoryParameter(direction, stream, prefix, name, pyType, weight, keepRename, location, originalName));
                }
                catch (Exception e) {
                    LOGGER.error("ERROR: Not a valid directory : " + e.getMessage());
                    ErrorManager.fatal(ERROR_DIR_NAME, e);
                }
                break;
            }
            case FILE_T: {
                try {
                    String fileName = content.toString();
                    String originalName = new File(fileName).getName();
                    DataLocation location = this.createLocation(ProtocolType.FILE_URI, content.toString());
                    pars.add(new FileParameter(direction, stream, prefix, name, pyType, weight, keepRename, location, originalName));
                }
                catch (Exception e) {
                    LOGGER.error(ERROR_FILE_NAME, (Throwable)e);
                    ErrorManager.fatal(ERROR_FILE_NAME, e);
                }
                break;
            }
            case OBJECT_T: 
            case PSCO_T: {
                int code = oReg.newObjectParameter(appId, content);
                pars.add(new ObjectParameter(direction, stream, prefix, name, pyType, weight, content, code));
                break;
            }
            case STREAM_T: {
                int streamCode = oReg.newObjectParameter(appId, content);
                pars.add(new StreamParameter(direction, stream, prefix, name, content, streamCode));
                break;
            }
            case EXTERNAL_STREAM_T: {
                try {
                    String fileName = content.toString();
                    DataLocation location = this.createLocation(ProtocolType.EXTERNAL_STREAM_URI, fileName);
                    String originalName = new File(fileName).getName();
                    pars.add(new ExternalStreamParameter(direction, stream, prefix, name, location, originalName));
                }
                catch (Exception e) {
                    LOGGER.error(ERROR_FILE_NAME, (Throwable)e);
                    ErrorManager.fatal(ERROR_FILE_NAME, e);
                }
                break;
            }
            case EXTERNAL_PSCO_T: {
                String id = content.toString();
                pars.add(new ExternalPSCOParameter(direction, stream, prefix, name, weight, id, this.externalObjectHashcode(id)));
                break;
            }
            case BINDING_OBJECT_T: {
                String value = content.toString();
                if (value.contains(":")) {
                    String[] fields = value.split(":");
                    if (fields.length == 3) {
                        String extObjectId = fields[0];
                        int extObjectType = Integer.parseInt(fields[1]);
                        int extObjectElements = Integer.parseInt(fields[2]);
                        pars.add(new BindingObjectParameter(direction, stream, prefix, name, pyType, weight, new BindingObject(extObjectId, extObjectType, extObjectElements), this.externalObjectHashcode(extObjectId)));
                        break;
                    }
                    LOGGER.error("ERROR: Incorrect number of parameters for external objects received value is " + value);
                    ErrorManager.fatal("ERROR: Incorrect number of parameters for external objects received value is " + value);
                    break;
                }
                LOGGER.error("ERROR: Incorrect number of parameters for external objects received value is " + value);
                ErrorManager.fatal("ERROR: Incorrect number of parameters for external objects received value is " + value);
                break;
            }
            case COLLECTION_T: {
                String[] values = vals == null ? ((String)content).split(" ") : vals;
                String collectionId = values[offset];
                int numOfElements = Integer.parseInt(values[offset + 1]);
                String colPyType = values[offset + 2];
                ArrayList<DataType> contentTypes = new ArrayList<DataType>();
                ArrayList<String> contentIds = new ArrayList<String>();
                ArrayList<Parameter> collectionParameters = new ArrayList<Parameter>();
                int ret = 3;
                for (int j = 0; j < numOfElements; ++j) {
                    int idx = Integer.parseInt(values[offset + ret]);
                    DataType dataType = DataType.values()[idx];
                    contentTypes.add(dataType);
                    contentIds.add(values[offset + ret + 1]);
                    DataType elemType = (DataType)((Object)contentTypes.get(j));
                    Direction elemDir = direction;
                    String elemPyType = values[offset + ret + 2];
                    String[] elemContent = elemType == DataType.COLLECTION_T ? values : contentIds.get(j);
                    StdIOStream elemStream = StdIOStream.UNSPECIFIED;
                    String elemPrefix = "null";
                    String elemName = name + "." + j;
                    if (!elemName.startsWith("@")) {
                        elemName = "@" + elemName;
                    }
                    ret += this.addParameter(app, elemContent, elemType, elemDir, elemStream, "null", elemName, elemPyType, weight, keepRename, collectionParameters, offset + ret + 1, values) + 2;
                }
                CollectionParameter cp = new CollectionParameter(collectionId, collectionParameters, direction, stream, prefix, name, colPyType, weight, keepRename);
                pars.add(cp);
                return ret;
            }
            case DICT_COLLECTION_T: {
                String[] values1 = vals == null ? content.toString().split(" ") : vals;
                String dictCollectionId = values1[offset];
                int numOfEntries = Integer.parseInt(values1[offset + 1]);
                String dictColPyType = values1[offset + 2];
                ArrayList<Parameter> dictCollectionParametersKeys = new ArrayList<Parameter>();
                ArrayList<Parameter> dictCollectionParametersValues = new ArrayList<Parameter>();
                int pointer = 3;
                for (int j = 0; j < numOfEntries; ++j) {
                    int idKey = Integer.parseInt(values1[offset + pointer]);
                    DataType dataTypeKey = DataType.values()[idKey];
                    String[] contentKey = values1[offset + pointer + 1];
                    String elemPyTypeKey = values1[offset + pointer + 2];
                    StdIOStream elemStreamKey = StdIOStream.UNSPECIFIED;
                    String elemPrefixKey = "null";
                    String elemNameKey = name + "." + j;
                    if (!elemNameKey.startsWith("@key")) {
                        elemNameKey = "@key" + elemNameKey;
                    }
                    Direction elemDirKey = direction;
                    String[] elemContentKey = contentKey;
                    int extraKey = 2;
                    if (dataTypeKey == DataType.DICT_COLLECTION_T || dataTypeKey == DataType.COLLECTION_T) {
                        elemContentKey = values1;
                        ++pointer;
                        extraKey = 0;
                    }
                    int kDret = this.addParameter(app, elemContentKey, dataTypeKey, elemDirKey, elemStreamKey, "null", elemNameKey, elemPyTypeKey, weight, keepRename, dictCollectionParametersKeys, offset + pointer, values1) + extraKey;
                    int idValue = Integer.parseInt(values1[offset + (pointer += kDret)]);
                    DataType dataTypeValue = DataType.values()[idValue];
                    String[] contentValue = values1[offset + pointer + 1];
                    String elemPyTypeValue = values1[offset + pointer + 2];
                    StdIOStream elemStreamValue = StdIOStream.UNSPECIFIED;
                    String elemPrefixValue = "null";
                    String elemNameValue = name + "." + j;
                    if (!elemNameValue.startsWith("@value")) {
                        elemNameValue = "@value" + elemNameKey;
                    }
                    Direction elemDirValue = direction;
                    String[] elemContentValue = contentValue;
                    int extraValue = 2;
                    if (dataTypeValue == DataType.DICT_COLLECTION_T || dataTypeValue == DataType.COLLECTION_T) {
                        elemContentValue = values1;
                        ++pointer;
                        extraValue = 0;
                    }
                    int vDret = this.addParameter(app, elemContentValue, dataTypeValue, elemDirValue, elemStreamValue, "null", elemNameValue, elemPyTypeValue, weight, keepRename, dictCollectionParametersValues, offset + pointer, values1) + extraValue;
                    pointer += vDret;
                }
                Map<Parameter, Parameter> dictCollectionParams = IntStream.range(0, dictCollectionParametersKeys.size()).boxed().collect(Collectors.toMap(dictCollectionParametersKeys::get, dictCollectionParametersValues::get));
                DictCollectionParameter dcp = new DictCollectionParameter(dictCollectionId, dictCollectionParams, direction, stream, prefix, name, dictColPyType, weight, keepRename);
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Add Dictionary Collection " + dcp.getName() + " with " + dcp.getParameters().size() + " entries");
                    LOGGER.debug(dcp.toString());
                }
                pars.add(dcp);
                return pointer;
            }
            case NULL_T: {
                LOGGER.warn("WARNING: Optional parameter: Parameter " + name + " is defined as None or Null");
                pars.add(new BasicTypeParameter(type, Direction.IN, stream, prefix, name, content, weight, "null"));
                break;
            }
            default: {
                if (direction != Direction.IN && direction != Direction.IN_DELETE) {
                    LOGGER.warn("WARNING: Invalid parameter direction: Parameter " + name + " is a basic type, therefore it must have IN direction");
                }
                pars.add(new BasicTypeParameter(type, Direction.IN, stream, prefix, name, content, weight, pyType));
            }
        }
        return 1;
    }

    private List<Parameter> processParameters(Application app, int parameterCount, Object[] parameters) {
        ArrayList<Parameter> pars = new ArrayList<Parameter>();
        for (int i = 0; i < parameterCount; ++i) {
            Object content = parameters[9 * i];
            DataType type = (DataType)((Object)parameters[9 * i + 1]);
            if (type == null) {
                type = DataType.NULL_T;
            }
            Direction direction = (Direction)((Object)parameters[9 * i + 2]);
            StdIOStream stream = (StdIOStream)((Object)parameters[9 * i + 3]);
            String prefix = (String)parameters[9 * i + 4];
            String name = (String)parameters[9 * i + 5];
            String contentType = (String)parameters[9 * i + 6];
            double weight = Double.parseDouble(EnvironmentLoader.loadFromEnvironment((String)parameters[9 * i + 7]));
            boolean keepRename = (Boolean)parameters[9 * i + 8];
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug(" Parameter " + i + " has type " + type.name());
            }
            this.addParameter(app, content, type, direction, stream, prefix, name, contentType, weight, keepRename, pars, 0, null);
        }
        return pars;
    }

    private int externalObjectHashcode(String id) {
        int hashCode = 7;
        for (int i = 0; i < id.length(); ++i) {
            hashCode = hashCode * 31 + id.charAt(i);
        }
        return hashCode;
    }

    private void finishAccessToFile(Application app, String fileName, DataLocation loc, AccessParams.AccessMode am, String destDir) {
        FileAccessParams fap = new FileAccessParams(app, am, loc);
        ap.finishAccessToFile(loc, fap, destDir);
    }

    private String mainAccessToFile(Application app, String fileName, DataLocation loc, AccessParams.AccessMode am, String destDir, boolean isDirectory) {
        DataLocation finalLocation;
        FileAccessParams fap = new FileAccessParams(app, am, loc);
        DataLocation targetLocation = isDirectory ? ap.mainAccessToDirectory(app, loc, fap, destDir) : ap.mainAccessToFile(app, loc, fap, destDir);
        String path = targetLocation == null ? fileName : targetLocation.getPath();
        DataLocation dataLocation = finalLocation = targetLocation == null ? loc : targetLocation;
        if (finalLocation == null) {
            ErrorManager.fatal(ERROR_FILE_NAME);
            return null;
        }
        MultiURI u = finalLocation.getURIInHost(Comm.getAppHost());
        String finalPath = u != null ? u.getPath() : path;
        return finalPath;
    }

    private Object mainAccessToObject(Application app, Object obj, int hashCode) {
        boolean validValue = ap.isCurrentRegisterValueValid(hashCode);
        if (validValue) {
            return null;
        }
        return ap.mainAccessToObject(app, obj, hashCode);
    }

    private String mainAccessToExternalPSCO(Application app, String fileName, DataLocation loc) {
        String id = ((PersistentLocation)loc).getId();
        int hashCode = this.externalObjectHashcode(id);
        boolean validValue = ap.isCurrentRegisterValueValid(hashCode);
        if (validValue) {
            return fileName;
        }
        return ap.mainAccessToExternalPSCO(app, id, hashCode);
    }

    private String mainAccessToBindingObject(Application app, String fileName, BindingObjectLocation loc) {
        String id = loc.getId();
        int hashCode = this.externalObjectHashcode(id);
        boolean validValue = ap.isCurrentRegisterValueValid(hashCode);
        if (validValue) {
            return fileName;
        }
        return ap.mainAccessToBindingObject(app, loc.getBindingObject(), hashCode);
    }

    private DataLocation createLocation(ProtocolType defaultSchema, String fileName) throws IOException {
        SimpleURI uri = new SimpleURI(fileName);
        if (uri.getSchema().isEmpty()) {
            if (fileName.startsWith("/")) {
                uri = new SimpleURI(defaultSchema.getSchema() + fileName);
            } else {
                String canonicalPath = new File(fileName).getCanonicalPath();
                uri = new SimpleURI(defaultSchema.getSchema() + canonicalPath);
            }
        }
        Resource host = Comm.getAppHost();
        String hostName = uri.getHost();
        if (hostName != null && !hostName.isEmpty() && (host = ResourcesPool.getResource(hostName)) == null) {
            ErrorManager.error("Host " + hostName + " not found when creating data location.");
        }
        return DataLocation.createLocation(host, uri);
    }

    @Override
    public void removeApplicationData(Long appId) {
        Application app = Application.registerApplication(appId);
        ap.deleteAllApplicationDataRequest(app);
    }

    @Override
    public void setWallClockLimit(Long appId, long wcl, boolean stopRT) {
        if (wcl > 0L) {
            if (timer == null) {
                if (Tracer.basicModeEnabled()) {
                    Tracer.enablePThreads(1);
                }
                timer = new Timer("Application wall clock limit timer");
                timer.schedule(new TimerTask(){

                    @Override
                    public void run() {
                        if (Tracer.basicModeEnabled()) {
                            Tracer.disablePThreads(1);
                        }
                        if (Tracer.extraeEnabled()) {
                            Tracer.emitEvent(TraceEvent.WALLCLOCK_THREAD_ID.getId(), TraceEvent.WALLCLOCK_THREAD_ID.getType());
                        }
                    }
                }, 0L);
            }
            LOGGER.info("Setting wall clock limit for app " + appId + " of " + wcl + "seconds.");
            Application app = Application.registerApplication(appId);
            WallClockTimerTask wcTask = new WallClockTimerTask(app, ap, stopRT ? this : null);
            app.setTimerTask(wcTask);
            timer.schedule((TimerTask)wcTask, (wcl + 1L) * 1000L);
        }
    }

    static {
        timer = null;
        LOGGER = LogManager.getLogger("es.bsc.compss.API");
        DO_NOTHING_MONITOR = new DoNothingTaskMonitor();
        String propertiesLoc = System.getProperty("compss.properties.location");
        if (propertiesLoc == null) {
            InputStream stream = COMPSsRuntimeImpl.findPropertiesConfigFile();
            if (stream != null) {
                try {
                    COMPSsRuntimeImpl.setPropertiesFromRuntime(new RuntimeConfigManager(stream));
                }
                catch (Exception e) {
                    System.err.println(WARN_IT_FILE_NOT_READ);
                    e.printStackTrace();
                }
            } else {
                COMPSsRuntimeImpl.setDefaultProperties();
            }
        } else {
            try {
                COMPSsRuntimeImpl.setPropertiesFromRuntime(new RuntimeConfigManager(propertiesLoc));
            }
            catch (Exception e) {
                System.err.println(WARN_IT_FILE_NOT_READ);
                e.printStackTrace();
            }
        }
        Comm.init(new MasterResourceImpl());
    }
}

