/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.components.impl;

import es.bsc.compss.api.TaskMonitor;
import es.bsc.compss.components.impl.DataInfoProvider;
import es.bsc.compss.components.monitor.impl.EdgeType;
import es.bsc.compss.components.monitor.impl.GraphGenerator;
import es.bsc.compss.components.monitor.impl.GraphHandler;
import es.bsc.compss.types.AbstractTask;
import es.bsc.compss.types.Application;
import es.bsc.compss.types.Barrier;
import es.bsc.compss.types.CommutativeGroupTask;
import es.bsc.compss.types.CommutativeIdentifier;
import es.bsc.compss.types.ReadersInfo;
import es.bsc.compss.types.Task;
import es.bsc.compss.types.TaskDescription;
import es.bsc.compss.types.TaskListener;
import es.bsc.compss.types.TaskState;
import es.bsc.compss.types.accesses.DataAccessesInfo;
import es.bsc.compss.types.annotations.parameter.DataType;
import es.bsc.compss.types.annotations.parameter.OnFailure;
import es.bsc.compss.types.data.DataAccessId;
import es.bsc.compss.types.data.DataInfo;
import es.bsc.compss.types.data.DataInstanceId;
import es.bsc.compss.types.data.accessid.RAccessId;
import es.bsc.compss.types.data.accessid.RWAccessId;
import es.bsc.compss.types.data.accessid.WAccessId;
import es.bsc.compss.types.data.accessparams.AccessParams;
import es.bsc.compss.types.data.operation.ResultListener;
import es.bsc.compss.types.implementations.TaskType;
import es.bsc.compss.types.parameter.BindingObjectParameter;
import es.bsc.compss.types.parameter.CollectionParameter;
import es.bsc.compss.types.parameter.DependencyParameter;
import es.bsc.compss.types.parameter.DictCollectionParameter;
import es.bsc.compss.types.parameter.DirectoryParameter;
import es.bsc.compss.types.parameter.ExternalPSCOParameter;
import es.bsc.compss.types.parameter.ExternalStreamParameter;
import es.bsc.compss.types.parameter.FileParameter;
import es.bsc.compss.types.parameter.ObjectParameter;
import es.bsc.compss.types.parameter.Parameter;
import es.bsc.compss.types.parameter.StreamParameter;
import es.bsc.compss.types.request.ap.BarrierGroupRequest;
import es.bsc.compss.types.request.ap.BarrierRequest;
import es.bsc.compss.types.request.ap.EndOfAppRequest;
import es.bsc.compss.types.request.ap.RegisterDataAccessRequest;
import es.bsc.compss.util.ErrorManager;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.Semaphore;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import storage.StubItf;

public class TaskAnalyser
implements GraphHandler {
    private static final Logger LOGGER = LogManager.getLogger("es.bsc.compss.Components.TaskProcessor.TaskAnalyser");
    private static final boolean DEBUG = LOGGER.isDebugEnabled();
    private static final String TASK_FAILED = "Task failed: ";
    private static final String TASK_CANCELED = "Task canceled: ";
    private DataInfoProvider dip;
    private GraphGenerator gm;
    private final Map<Integer, DataAccessesInfo> accessesInfo = new TreeMap<Integer, DataAccessesInfo>();
    private Map<String, CommutativeGroupTask> commutativeGroup = new TreeMap<String, CommutativeGroupTask>();
    private Map<String, LinkedList<Task>> pendingToDrawCommutative = new TreeMap<String, LinkedList<Task>>();
    private List<String> reduceTasksNames = new ArrayList<String>();
    private static final boolean IS_DRAW_GRAPH = GraphGenerator.isEnabled();
    private int synchronizationId = 0;
    private boolean taskDetectedAfterSync = false;

    public TaskAnalyser() {
        LOGGER.info("Initialization finished");
    }

    public void setCoWorkers(DataInfoProvider dip) {
        this.dip = dip;
    }

    public void setGM(GraphGenerator gm) {
        this.gm = gm;
        if (IS_DRAW_GRAPH) {
            this.gm.addSynchroToGraph(0);
        }
    }

    public void processTask(Task currentTask) {
        TaskDescription description = currentTask.getTaskDescription();
        LOGGER.info("New " + description.getType().toString().toLowerCase() + " task: Name:" + description.getName() + "), ID = " + currentTask.getId());
        if (IS_DRAW_GRAPH) {
            this.addNewTask(currentTask);
        }
        Application app = currentTask.getApplication();
        app.newTask(currentTask);
        int constrainingParam = -1;
        if (description.getType() == TaskType.SERVICE && description.hasTargetObject()) {
            constrainingParam = description.getParameters().size() - 1 - description.getNumReturns();
        }
        if (description.isReduction()) {
            this.reduceTasksNames.add(description.getName());
        }
        boolean taskHasEdge = this.processTaskParameters(app, currentTask, constrainingParam);
        this.registerIntermediateParameter(app, currentTask);
        this.markIntermediateParametersToDelete(app, currentTask);
        if (IS_DRAW_GRAPH && !taskHasEdge) {
            this.addEdgeFromMainToTask(currentTask);
        }
    }

    private boolean processTaskParameters(Application app, Task currentTask, int constrainingParam) {
        List<Parameter> parameters = currentTask.getParameters();
        boolean taskHasEdge = false;
        for (int paramIdx = 0; paramIdx < parameters.size(); ++paramIdx) {
            boolean isConstraining = paramIdx == constrainingParam;
            boolean paramHasEdge = this.registerParameterAccessAndAddDependencies(app, currentTask, parameters.get(paramIdx), isConstraining);
            taskHasEdge = taskHasEdge || paramHasEdge;
        }
        return taskHasEdge;
    }

    private void markIntermediateParametersToDelete(Application app, Task task) {
        for (Parameter p : task.getParameterDataToRemove()) {
            this.markParameterToDelete(app, p, true);
        }
    }

    private void registerIntermediateParameter(Application app, Task task) {
        for (Parameter p : task.getIntermediateParameters()) {
            this.registerParameterAccessAndAddDependencies(app, task, p, false);
        }
    }

    private void markParameterToDelete(Application app, Parameter p, boolean noReuse) {
        switch (p.getType()) {
            case DIRECTORY_T: {
                DirectoryParameter dp = (DirectoryParameter)p;
                this.dip.deleteData(app, dp.getLocation(), noReuse);
                break;
            }
            case FILE_T: {
                FileParameter fp = (FileParameter)p;
                this.dip.deleteData(app, fp.getLocation(), noReuse);
                break;
            }
            case OBJECT_T: 
            case PSCO_T: {
                ObjectParameter op = (ObjectParameter)p;
                this.dip.deleteData(op.getCode(), noReuse);
                break;
            }
            case EXTERNAL_PSCO_T: {
                ExternalPSCOParameter epscop = (ExternalPSCOParameter)p;
                this.dip.deleteData(epscop.getCode(), noReuse);
                break;
            }
            case BINDING_OBJECT_T: {
                BindingObjectParameter bindingObjectparam = (BindingObjectParameter)p;
                this.dip.deleteData(bindingObjectparam.getCode(), noReuse);
                break;
            }
            case STREAM_T: {
                StreamParameter sp = (StreamParameter)p;
                this.dip.deleteData(sp.getCode(), noReuse);
                break;
            }
            case EXTERNAL_STREAM_T: {
                ExternalStreamParameter esp = (ExternalStreamParameter)p;
                this.dip.deleteData(app, esp.getLocation(), noReuse);
                break;
            }
            case COLLECTION_T: {
                CollectionParameter cp = (CollectionParameter)p;
                this.dip.deleteCollection(cp.getCollectionId(), true);
                break;
            }
            case DICT_COLLECTION_T: {
                DictCollectionParameter dcp = (DictCollectionParameter)p;
                this.dip.deleteDictCollection(dcp.getDictCollectionId(), true);
                break;
            }
        }
    }

    public DataAccessId processMainAccess(RegisterDataAccessRequest rdar) {
        int dataId;
        DataAccessesInfo dai;
        AccessParams access = rdar.getAccessParams();
        if (DEBUG) {
            LOGGER.debug("Registering access " + access.toString() + " from main code");
        }
        DataAccessId daId = this.dip.registerDataAccess(access);
        if (DEBUG) {
            LOGGER.debug("Registered access to data " + daId.getDataId() + " from main code");
        }
        if (access.getMode() != AccessParams.AccessMode.W && (dai = this.accessesInfo.get(dataId = daId.getDataId())) != null) {
            int dataVersion = 0;
            if (IS_DRAW_GRAPH) {
                TreeSet<Integer> toPass = new TreeSet<Integer>();
                toPass.add(dataId);
                DataInstanceId dii = this.dip.getLastVersions(toPass).get(0);
                dataVersion = dii.getVersionId();
            }
            dai.mainAccess(rdar, this, dataId, dataVersion);
        }
        return daId;
    }

    public void endTask(AbstractTask aTask) {
        int taskId = aTask.getId();
        long start = System.currentTimeMillis();
        if (aTask instanceof Task) {
            Application app;
            List<TaskListener> listeners;
            Task task = (Task)aTask;
            boolean isFree = task.isFree();
            TaskState taskState = task.getStatus();
            OnFailure onFailure = task.getOnFailure();
            LOGGER.info("Notification received for task " + taskId + " with end status " + (Object)((Object)taskState));
            if (!isFree) {
                LOGGER.debug("Task " + taskId + " is not registered as free. Waiting for other executions to end");
                return;
            }
            TaskMonitor registeredMonitor = task.getTaskMonitor();
            switch (taskState) {
                case FAILED: {
                    registeredMonitor.onFailure();
                    if (onFailure == OnFailure.RETRY || onFailure == OnFailure.FAIL) {
                        ErrorManager.error(TASK_FAILED + task);
                        return;
                    }
                    if (onFailure != OnFailure.IGNORE && onFailure != OnFailure.CANCEL_SUCCESSORS) break;
                    ErrorManager.warn(TASK_FAILED + task);
                    break;
                }
                case CANCELED: {
                    registeredMonitor.onCancellation();
                    ErrorManager.warn(TASK_CANCELED + task);
                    break;
                }
                default: {
                    registeredMonitor.onCompletion();
                }
            }
            if (DEBUG) {
                LOGGER.debug("Freeing barriers for task " + taskId);
            }
            if (DEBUG) {
                LOGGER.debug("Releasing waiting tasks for task " + taskId);
            }
            if ((listeners = task.getListeners()) != null) {
                for (TaskListener listener : listeners) {
                    listener.taskFinished();
                }
            }
            if (DEBUG) {
                LOGGER.debug("Marking accessed parameters for task " + taskId);
            }
            for (Parameter param : task.getTaskDescription().getParameters()) {
                this.updateParameterAccess(task, param);
                this.updateLastWritters(task, param);
            }
            for (Parameter param : task.getUnusedIntermediateParameters()) {
                this.updateParameterAccess(task, param);
                this.updateLastWritters(task, param);
            }
            if (DEBUG) {
                LOGGER.debug("Checking result file transfers for task " + taskId);
            }
            if ((app = task.getApplication()).isEnding()) {
                this.checkResultFileTransfer(task);
            }
            app.endTask(task);
            this.releaseCommutativeGroups(task);
        }
        if (DEBUG) {
            LOGGER.debug("Releasing data dependant tasks for task " + taskId);
        }
        aTask.releaseDataDependents();
        if (DEBUG) {
            long time = System.currentTimeMillis() - start;
            LOGGER.debug("Task " + taskId + " end message processed in " + time + " ms.");
        }
    }

    public void barrier(BarrierRequest request) {
        Application app = request.getApp();
        if (IS_DRAW_GRAPH) {
            this.addMissingCommutativeTasksToGraph();
            this.addNewBarrier();
            this.gm.commitGraph(false);
        }
        app.reachesBarrier(request);
    }

    public void noMoreTasks(EndOfAppRequest request) {
        if (IS_DRAW_GRAPH) {
            this.addMissingCommutativeTasksToGraph();
            this.gm.commitGraph(true);
        }
        Application app = request.getApp();
        app.endReached(request);
    }

    public void deleteData(DataInfo dataInfo) {
        int dataId = dataInfo.getDataId();
        LOGGER.info("Deleting data " + dataId);
        DataAccessesInfo dai = this.accessesInfo.remove(dataId);
        if (dai != null) {
            switch (dai.getDataType()) {
                case STREAM_T: 
                case EXTERNAL_STREAM_T: {
                    break;
                }
                case FILE_T: {
                    Application.removeWrittenFileIdFromAllApps(dataId);
                    break;
                }
                case PSCO_T: {
                    Application.removeWrittenPSCOIdFromAllApps(dataId);
                    break;
                }
            }
        } else {
            LOGGER.warn("Writters info for data " + dataId + " not found.");
        }
    }

    public Set<Integer> getAndRemoveWrittenFiles(Application app) {
        return app.getWrittenFileIds();
    }

    public void shutdown() {
        if (IS_DRAW_GRAPH) {
            GraphGenerator.removeTemporaryGraph();
        }
    }

    public void setCurrentTaskGroup(Application app, boolean barrier, String groupName) {
        app.stackTaskGroup(groupName);
        if (IS_DRAW_GRAPH) {
            this.gm.addTaskGroupToGraph(groupName);
            LOGGER.debug("Group " + groupName + " added to graph");
        }
    }

    public void closeCurrentTaskGroup(Application app) {
        app.popGroup();
        if (IS_DRAW_GRAPH) {
            this.gm.closeGroupInGraph();
        }
    }

    private void releaseCommutativeGroups(Task task) {
        if (!task.getCommutativeGroupList().isEmpty()) {
            for (CommutativeGroupTask group : task.getCommutativeGroupList()) {
                group.setStatus(TaskState.FINISHED);
                group.removePredecessor(task);
                if (!group.getPredecessors().isEmpty()) continue;
                group.releaseDataDependents();
                List<TaskListener> listeners = group.getListeners();
                if (listeners != null) {
                    for (TaskListener listener : listeners) {
                        listener.taskFinished();
                    }
                }
                if (!DEBUG) continue;
                LOGGER.debug("Group " + group.getId() + " ended execution");
                LOGGER.debug("Data dependents of group " + group.getCommutativeIdentifier() + " released ");
            }
        }
    }

    public void barrierGroup(BarrierGroupRequest request) {
        Application app = request.getApp();
        String groupName = request.getGroupName();
        if (IS_DRAW_GRAPH) {
            this.addMissingCommutativeTasksToGraph();
            this.addNewGroupBarrierToGraph(app, groupName);
            this.gm.commitGraph(false);
        }
        app.reachesGroupBarrier(groupName, (Barrier)request);
    }

    private void addMissingCommutativeTasksToGraph() {
        LinkedList<String> identifiers = new LinkedList<String>();
        for (String identifier : this.pendingToDrawCommutative.keySet()) {
            this.addCommutativeGroupTaskToGraph(identifier);
            identifiers.add(identifier);
        }
        for (String identifier : identifiers) {
            this.pendingToDrawCommutative.remove(identifier);
        }
    }

    private boolean registerParameterAccessAndAddDependencies(Application app, Task currentTask, Parameter p, boolean isConstraining) {
        DataAccessId daId;
        DependencyParameter dp;
        AccessParams.AccessMode am = AccessParams.AccessMode.R;
        switch (p.getDirection()) {
            case IN: 
            case IN_DELETE: {
                am = AccessParams.AccessMode.R;
                break;
            }
            case OUT: {
                am = AccessParams.AccessMode.W;
                break;
            }
            case INOUT: {
                am = AccessParams.AccessMode.RW;
                break;
            }
            case CONCURRENT: {
                am = AccessParams.AccessMode.C;
                break;
            }
            case COMMUTATIVE: {
                am = AccessParams.AccessMode.CV;
            }
        }
        ReadersInfo readerData = new ReadersInfo(p, currentTask);
        DataAccessId firstRegistered = null;
        boolean hasParamEdge = false;
        switch (p.getType()) {
            case DIRECTORY_T: {
                dp = (DirectoryParameter)p;
                daId = this.dip.registerFileAccess(app, am, ((DirectoryParameter)dp).getLocation(), readerData);
                break;
            }
            case FILE_T: {
                FileParameter fp = (FileParameter)p;
                daId = this.dip.registerFileAccess(app, am, fp.getLocation(), readerData);
                break;
            }
            case PSCO_T: {
                ObjectParameter pscop = (ObjectParameter)p;
                pscop.setType(DataType.PSCO_T);
                daId = this.dip.registerObjectAccess(app, am, pscop.getValue(), pscop.getCode(), readerData);
                break;
            }
            case EXTERNAL_PSCO_T: {
                ExternalPSCOParameter externalPSCOparam = (ExternalPSCOParameter)p;
                externalPSCOparam.setType(DataType.EXTERNAL_PSCO_T);
                daId = this.dip.registerExternalPSCOAccess(app, am, externalPSCOparam.getId(), externalPSCOparam.getCode(), readerData);
                break;
            }
            case BINDING_OBJECT_T: {
                BindingObjectParameter bindingObjectparam = (BindingObjectParameter)p;
                bindingObjectparam.setType(DataType.BINDING_OBJECT_T);
                daId = this.dip.registerBindingObjectAccess(app, am, bindingObjectparam.getBindingObject(), bindingObjectparam.getCode(), readerData);
                break;
            }
            case OBJECT_T: {
                ObjectParameter op = (ObjectParameter)p;
                if (op.getValue() instanceof StubItf && ((StubItf)op.getValue()).getID() != null) {
                    op.setType(DataType.PSCO_T);
                }
                daId = this.dip.registerObjectAccess(app, am, op.getValue(), op.getCode(), readerData);
                break;
            }
            case STREAM_T: {
                StreamParameter sp = (StreamParameter)p;
                daId = this.dip.registerStreamAccess(app, am, sp.getValue(), sp.getCode(), readerData);
                break;
            }
            case EXTERNAL_STREAM_T: {
                ExternalStreamParameter esp = (ExternalStreamParameter)p;
                daId = this.dip.registerExternalStreamAccess(app, am, esp.getLocation(), readerData);
                break;
            }
            case COLLECTION_T: {
                CollectionParameter cp = (CollectionParameter)p;
                if (IS_DRAW_GRAPH) {
                    this.gm.startGroupingEdges();
                }
                for (Parameter content : cp.getParameters()) {
                    boolean hasCollectionParamEdge = this.registerParameterAccessAndAddDependencies(app, currentTask, content, isConstraining);
                    hasParamEdge = hasParamEdge || hasCollectionParamEdge;
                }
                daId = this.dip.registerCollectionAccess(app, am, cp, readerData);
                if (IS_DRAW_GRAPH) {
                    this.gm.stopGroupingEdges();
                }
                DataInfo ci = this.dip.deleteCollection(cp.getCollectionId(), true);
                this.deleteData(ci);
                break;
            }
            case DICT_COLLECTION_T: {
                DictCollectionParameter dcp = (DictCollectionParameter)p;
                if (IS_DRAW_GRAPH) {
                    this.gm.startGroupingEdges();
                }
                for (Map.Entry<Parameter, Parameter> entry : dcp.getParameters().entrySet()) {
                    boolean hasDictCollectionParamEdgeKey = this.registerParameterAccessAndAddDependencies(app, currentTask, entry.getKey(), isConstraining);
                    boolean hasDictCollectionParamEdgeValue = this.registerParameterAccessAndAddDependencies(app, currentTask, entry.getValue(), isConstraining);
                    hasParamEdge = hasParamEdge || hasDictCollectionParamEdgeKey || hasDictCollectionParamEdgeValue;
                }
                daId = this.dip.registerDictCollectionAccess(app, am, dcp, readerData);
                if (IS_DRAW_GRAPH) {
                    this.gm.stopGroupingEdges();
                }
                DataInfo dci = this.dip.deleteDictCollection(dcp.getDictCollectionId(), true);
                this.deleteData(dci);
                break;
            }
            default: {
                daId = null;
                currentTask.registerFreeParam(p);
            }
        }
        if (daId != null) {
            dp = (DependencyParameter)p;
            if (am == AccessParams.AccessMode.CV) {
                Integer coreId = currentTask.getTaskDescription().getCoreElement().getCoreId();
                CommutativeIdentifier comId = new CommutativeIdentifier(coreId, daId.getDataId());
                CommutativeGroupTask com = null;
                for (CommutativeGroupTask cgt : this.commutativeGroup.values()) {
                    if (cgt.getCommutativeIdentifier().compareTo(comId) != 1) continue;
                    com = cgt;
                }
                if (com == null) {
                    firstRegistered = daId;
                    LOGGER.debug("The FIRST registered daId in the commutative group " + comId.toString() + " is " + daId);
                } else {
                    com.addVersionToList(daId);
                    daId = com.getRegisteredVersion();
                    LOGGER.debug("Registering daId " + daId + " in commutative group " + comId.toString());
                }
                dp.setDataAccessId(daId);
                hasParamEdge = this.addCommutativeDependencies(currentTask, dp, firstRegistered, coreId);
            } else {
                dp.setDataAccessId(daId);
                hasParamEdge = this.addDependencies(am, currentTask, isConstraining, dp);
            }
        }
        return hasParamEdge;
    }

    private boolean addDependencies(AccessParams.AccessMode am, Task currentTask, boolean isConstraining, DependencyParameter dp) {
        boolean hasParamEdge = false;
        DataAccessId daId = dp.getDataAccessId();
        int dataId = daId.getDataId();
        DataAccessesInfo dai = this.accessesInfo.get(dataId);
        switch (am) {
            case R: {
                this.checkInputDependency(currentTask, dp, false, dataId, dai, isConstraining);
                hasParamEdge = true;
                break;
            }
            case RW: {
                this.checkInputDependency(currentTask, dp, false, dataId, dai, isConstraining);
                hasParamEdge = true;
                this.registerOutputValues(currentTask, dp, false, dai);
                break;
            }
            case W: {
                this.registerOutputValues(currentTask, dp, false, dai);
                break;
            }
            case C: {
                this.checkInputDependency(currentTask, dp, true, dataId, dai, isConstraining);
                hasParamEdge = true;
                this.registerOutputValues(currentTask, dp, true, dai);
                break;
            }
        }
        return hasParamEdge;
    }

    private void checkInputDependency(Task currentTask, DependencyParameter dp, boolean isConcurrent, int dataId, DataAccessesInfo dai, boolean isConstraining) {
        if (DEBUG) {
            LOGGER.debug("Checking READ dependency for datum " + dataId + " and task " + currentTask.getId());
        }
        if (dai != null) {
            dai.readValue(currentTask, dp, isConcurrent, this);
            if (isConstraining) {
                AbstractTask lastWriter = dai.getConstrainingProducer();
                currentTask.setEnforcingTask((Task)lastWriter);
            }
        } else {
            if (DEBUG) {
                LOGGER.debug("There is no last writer for datum " + dataId);
            }
            currentTask.registerFreeParam(dp);
            if (IS_DRAW_GRAPH) {
                this.drawEdges(currentTask, dp, null);
            }
        }
    }

    private void registerOutputValues(AbstractTask currentTask, DependencyParameter dp, boolean isConcurrent, DataAccessesInfo dai) {
        int currentTaskId = currentTask.getId();
        int dataId = dp.getDataAccessId().getDataId();
        Application app = currentTask.getApplication();
        if (DEBUG) {
            LOGGER.debug("Checking WRITE dependency for datum " + dataId + " and task " + currentTaskId);
        }
        if (dai == null) {
            dai = DataAccessesInfo.createAccessInfo(dp.getType());
            this.accessesInfo.put(dataId, dai);
        }
        dai.writeValue(currentTask, dp, isConcurrent, this);
        switch (dp.getType()) {
            case DIRECTORY_T: 
            case FILE_T: {
                app.addWrittenFileId(dataId);
                break;
            }
            case PSCO_T: {
                app.addWrittenPSCOId(dataId);
                break;
            }
        }
        if (DEBUG) {
            LOGGER.debug("New writer for datum " + dataId + " is task " + currentTaskId);
        }
    }

    private boolean addCommutativeDependencies(Task currentTask, DependencyParameter dp, DataAccessId firstRegistered, int coreId) {
        DataAccessId daId = dp.getDataAccessId();
        CommutativeIdentifier comId = new CommutativeIdentifier(coreId, daId.getDataId());
        CommutativeGroupTask com = null;
        LinkedList<Task> pendingToDraw = null;
        for (CommutativeGroupTask cgt : this.commutativeGroup.values()) {
            if (cgt.getCommutativeIdentifier().compareTo(comId) != 1) continue;
            com = cgt;
            if (!IS_DRAW_GRAPH) continue;
            pendingToDraw = this.pendingToDrawCommutative.get(comId.toString());
        }
        if (IS_DRAW_GRAPH) {
            if (pendingToDraw == null) {
                pendingToDraw = new LinkedList<Task>();
            }
            pendingToDraw.add(currentTask);
            this.pendingToDrawCommutative.put(comId.toString(), pendingToDraw);
        }
        DataAccessesInfo dai = this.accessesInfo.get(daId.getDataId());
        if (com == null) {
            LOGGER.info("Creating a new commutative group " + comId);
            com = new CommutativeGroupTask(currentTask.getApplication(), comId);
            if (IS_DRAW_GRAPH) {
                LOGGER.debug("Checking if previous group in graph");
                this.checkIfPreviousGroupInGraph(daId.getDataId());
            }
            if (dai != null) {
                List<AbstractTask> predecessors = dai.getDataWriters();
                AbstractTask predecessor = null;
                if (!predecessors.isEmpty()) {
                    predecessor = predecessors.get(0);
                }
                com.setParentDataDependency(predecessor);
                LOGGER.debug("Setting parent data dependency");
            }
            this.commutativeGroup.put(comId.toString(), com);
            com.setRegisteredVersion(firstRegistered);
        }
        com.setFinalVersion(((RWAccessId)daId).getWVersionId());
        boolean hasParamEdge = this.checkDependencyForCommutative(currentTask, dp, com);
        this.registerOutputValues(com, dp, false, dai);
        return hasParamEdge;
    }

    private boolean checkDependencyForCommutative(Task currentTask, DependencyParameter dp, CommutativeGroupTask commutativeGroup) {
        AbstractTask t = commutativeGroup.getParentDataDependency();
        if (t != null) {
            LOGGER.debug("Adding dependency with parent task of commutative group");
            currentTask.addDataDependency(t, dp);
        }
        if (IS_DRAW_GRAPH) {
            this.drawEdges(currentTask, dp, t);
        }
        commutativeGroup.addDataDependency(currentTask, dp);
        commutativeGroup.addCommutativeTask(currentTask);
        currentTask.setCommutativeGroup(commutativeGroup, dp.getDataAccessId());
        return true;
    }

    private void updateLastWritters(AbstractTask task, Parameter p) {
        DataType type = p.getType();
        int currentTaskId = task.getId();
        if (type == DataType.COLLECTION_T) {
            CollectionParameter cp = (CollectionParameter)p;
            for (Parameter parameter : cp.getParameters()) {
                this.updateLastWritters(task, parameter);
            }
        }
        if (type == DataType.DICT_COLLECTION_T) {
            DictCollectionParameter dcp = (DictCollectionParameter)p;
            for (Map.Entry entry : dcp.getParameters().entrySet()) {
                this.updateLastWritters(task, (Parameter)entry.getKey());
                this.updateLastWritters(task, (Parameter)entry.getValue());
            }
        }
        if (type == DataType.FILE_T || type == DataType.OBJECT_T || type == DataType.PSCO_T || type == DataType.EXTERNAL_PSCO_T || type == DataType.BINDING_OBJECT_T || type == DataType.COLLECTION_T || type == DataType.DICT_COLLECTION_T) {
            DataAccessesInfo dataAccessesInfo;
            DependencyParameter dp = (DependencyParameter)p;
            int dataId = dp.getDataAccessId().getDataId();
            if (DEBUG) {
                LOGGER.debug("Removing writters info for datum " + dataId + " and task " + currentTaskId);
            }
            if ((dataAccessesInfo = this.accessesInfo.get(dataId)) != null) {
                switch (dp.getDirection()) {
                    case OUT: 
                    case INOUT: {
                        dataAccessesInfo.completedProducer(task);
                        break;
                    }
                }
            }
        }
    }

    private void updateParameterAccess(Task t, Parameter p) {
        DataType type = p.getType();
        if (type == DataType.COLLECTION_T) {
            for (Parameter parameter : ((CollectionParameter)p).getParameters()) {
                this.updateParameterAccess(t, parameter);
            }
        }
        if (type == DataType.DICT_COLLECTION_T) {
            for (Map.Entry entry : ((DictCollectionParameter)p).getParameters().entrySet()) {
                this.updateParameterAccess(t, (Parameter)entry.getKey());
                this.updateParameterAccess(t, (Parameter)entry.getValue());
            }
        }
        if (type == DataType.FILE_T || type == DataType.DIRECTORY_T || type == DataType.OBJECT_T || type == DataType.PSCO_T || type == DataType.STREAM_T || type == DataType.EXTERNAL_STREAM_T || type == DataType.EXTERNAL_PSCO_T || type == DataType.BINDING_OBJECT_T || type == DataType.COLLECTION_T || type == DataType.DICT_COLLECTION_T) {
            DependencyParameter dPar = (DependencyParameter)p;
            DataAccessId dataAccessId = dPar.getDataAccessId();
            if (DEBUG) {
                LOGGER.debug("Treating that data " + dataAccessId + " has been accessed at " + dPar.getDataTarget());
            }
            ReadersInfo readerData = new ReadersInfo(p, t);
            if (t.getOnFailure() == OnFailure.CANCEL_SUCCESSORS && (t.getStatus() == TaskState.FAILED || t.getStatus() == TaskState.CANCELED) || t.isCancelledByException()) {
                this.dip.dataAccessHasBeenCanceled(dataAccessId, readerData);
            } else {
                this.dip.dataHasBeenAccessed(dataAccessId);
            }
        }
    }

    private void checkResultFileTransfer(Task t) {
        LinkedList<DataInstanceId> fileIds = new LinkedList<DataInstanceId>();
        for (Parameter p : t.getTaskDescription().getParameters()) {
            DataAccessesInfo dai;
            DataType type = p.getType();
            if (type != DataType.DIRECTORY_T && type != DataType.FILE_T) continue;
            DependencyParameter fp = (DependencyParameter)p;
            DataInstanceId dId = null;
            switch (fp.getDirection()) {
                case INOUT: 
                case COMMUTATIVE: {
                    dId = ((RWAccessId)fp.getDataAccessId()).getWrittenDataInstance();
                    break;
                }
                case OUT: {
                    dId = ((WAccessId)fp.getDataAccessId()).getWrittenDataInstance();
                    break;
                }
            }
            if (dId == null || (dai = this.accessesInfo.get(dId.getDataId())) == null || !dai.isFinalProducer(t)) continue;
            fileIds.add(dId);
        }
        int numFT = fileIds.size();
        if (numFT > 0) {
            if (DEBUG) {
                LOGGER.debug("Ordering transfers for result files of task " + t.getId());
            }
            for (DataInstanceId fileId : fileIds) {
                int id = fileId.getDataId();
                if (DEBUG) {
                    LOGGER.debug("- Requesting result file " + id + " because of task " + t.getId());
                }
                this.dip.blockDataAndGetResultFile(id, new ResultListener(new Semaphore(0)));
                this.dip.unblockDataId(id);
            }
        }
    }

    @Override
    public void drawEdges(Task currentTask, DependencyParameter dp, AbstractTask lastWriter) {
        int dataVersion;
        int dataId = dp.getDataAccessId().getDataId();
        DataAccessId.Direction d = dp.getDataAccessId().getDirection();
        switch (d) {
            case C: 
            case R: {
                dataVersion = ((RAccessId)dp.getDataAccessId()).getRVersionId();
                break;
            }
            case W: {
                dataVersion = ((WAccessId)dp.getDataAccessId()).getWVersionId();
                break;
            }
            default: {
                dataVersion = ((RWAccessId)dp.getDataAccessId()).getRVersionId();
            }
        }
        switch (dp.getType()) {
            case STREAM_T: 
            case EXTERNAL_STREAM_T: {
                this.drawStreamEdge(currentTask, dp, !d.equals((Object)DataAccessId.Direction.R));
                break;
            }
            default: {
                if (lastWriter != null && lastWriter != currentTask) {
                    if (lastWriter instanceof Task) {
                        if (lastWriter.getSuccessors().contains(currentTask.getCommutativeGroup(dataId))) {
                            this.addEdgeFromCommutativeToTask(currentTask, dataId, dataVersion, (CommutativeGroupTask)lastWriter, false);
                            break;
                        }
                        this.addDataEdgeFromTaskToTask((Task)lastWriter, currentTask, dataId, dataVersion);
                        break;
                    }
                    if (lastWriter instanceof Task && !currentTask.hasCommutativeParams()) break;
                    this.addEdgeFromCommutativeToTask(currentTask, dataId, dataVersion, (CommutativeGroupTask)lastWriter, true);
                    break;
                }
                this.addDataEdgeFromMainToTask(currentTask, dataId, dataVersion);
            }
        }
    }

    @Override
    public void drawStreamEdge(AbstractTask currentTask, DependencyParameter dp, boolean isWrite) {
        String stream = "Stream" + dp.getDataAccessId().getDataId();
        this.addStreamToGraph(stream);
        this.addStreamEdge(currentTask, stream, isWrite);
    }

    private void addNewTask(Task task) {
        task.setSynchronizationId(this.synchronizationId);
        this.taskDetectedAfterSync = true;
        if (!task.hasCommutativeParams()) {
            this.addTaskToGraph(task);
        }
    }

    private void addTaskToGraph(Task task) {
        this.gm.addTaskToGraph(task);
    }

    private void addStreamToGraph(String stream) {
        this.gm.addStreamToGraph(stream);
    }

    @Override
    public void checkIfPreviousGroupInGraph(int dataId) {
        DataAccessesInfo dai = this.accessesInfo.get(dataId);
        if (dai != null) {
            List<AbstractTask> lastWriters = dai.getDataWriters();
            AbstractTask lastWriter = null;
            if (!lastWriters.isEmpty()) {
                lastWriter = lastWriters.get(0);
            }
            if (lastWriter instanceof CommutativeGroupTask && !((CommutativeGroupTask)lastWriter).getGraphDrawn()) {
                CommutativeIdentifier comId = ((CommutativeGroupTask)lastWriter).getCommutativeIdentifier();
                this.addCommutativeGroupTaskToGraph(comId.toString());
                ((CommutativeGroupTask)lastWriter).setGraphDrawn();
                this.pendingToDrawCommutative.remove(((CommutativeGroupTask)lastWriter).getCommutativeIdentifier().toString());
            }
        }
    }

    private void addCommutativeGroupTaskToGraph(String identifier) {
        LOGGER.debug("Adding commutative group to graph");
        this.gm.addCommutativeGroupToGraph(identifier);
        for (Task t : this.pendingToDrawCommutative.get(identifier)) {
            this.addTaskToGraph(t);
        }
        this.gm.closeGroupInGraph();
    }

    private void addDataEdgeFromTaskToTask(Task source, Task dest, int dataId, int dataVersion) {
        if (source.getSynchronizationId() == dest.getSynchronizationId()) {
            String src = String.valueOf(source.getId());
            String dst = String.valueOf(dest.getId());
            String dep = String.valueOf(dataId) + "v" + String.valueOf(dataVersion);
            this.gm.addEdgeToGraph(src, dst, EdgeType.DATA_DEPENDENCY, dep);
        } else {
            String src = "Synchro" + dest.getSynchronizationId();
            String dst = String.valueOf(dest.getId());
            String dep = String.valueOf(dataId) + "v" + String.valueOf(dataVersion);
            this.gm.addEdgeToGraph(src, dst, EdgeType.DATA_DEPENDENCY, dep);
        }
    }

    private void addDataEdgeFromMainToTask(Task dest, int dataId, int dataVersion) {
        String src = "Synchro" + dest.getSynchronizationId();
        String dst = String.valueOf(dest.getId());
        String dep = String.valueOf(dataId) + "v" + String.valueOf(dataVersion);
        this.gm.addEdgeToGraph(src, dst, EdgeType.DATA_DEPENDENCY, dep);
    }

    private void addEdgeFromMainToTask(Task dest) {
        String src = "Synchro" + dest.getSynchronizationId();
        String dst = String.valueOf(dest.getId());
        String dep = "";
        this.gm.addEdgeToGraph(src, dst, EdgeType.DATA_DEPENDENCY, dep);
    }

    @Override
    public void addEdgeFromTaskToMain(AbstractTask task, EdgeType edgeType, int dataId, int dataVersion) {
        if (this.taskDetectedAfterSync) {
            this.taskDetectedAfterSync = false;
            int oldSyncId = this.synchronizationId++;
            this.gm.addSynchroToGraph(this.synchronizationId);
            String oldSync = "Synchro" + oldSyncId;
            String currentSync = "Synchro" + this.synchronizationId;
            this.gm.addEdgeToGraph(oldSync, currentSync, edgeType, "");
        }
        String dest = "Synchro" + this.synchronizationId;
        if (task instanceof CommutativeGroupTask && !((CommutativeGroupTask)task).getCommutativeTasks().isEmpty()) {
            CommutativeGroupTask commGroupTask = (CommutativeGroupTask)task;
            String src = String.valueOf(commGroupTask.getCommutativeTasks().get(0).getId());
            String groupId = commGroupTask.getCommutativeIdentifier().toString();
            this.gm.addEdgeToGraphFromGroup(src, dest, String.valueOf(dataId) + "v" + String.valueOf(dataVersion), groupId, "clusterCommutative", edgeType);
        } else {
            String src = String.valueOf(task.getId());
            this.gm.addEdgeToGraph(src, dest, edgeType, String.valueOf(dataId) + "v" + String.valueOf(dataVersion));
        }
    }

    private void addStreamEdge(AbstractTask task, String stream, boolean isWrite) {
        String taskId = String.valueOf(task.getId());
        if (isWrite) {
            this.gm.addEdgeToGraph(taskId, stream, EdgeType.STREAM_DEPENDENCY, "");
        } else {
            this.gm.addEdgeToGraph(stream, taskId, EdgeType.STREAM_DEPENDENCY, "");
        }
    }

    private void addEdgeFromCommutativeToTask(Task dest, int dataId, int dataVersion, CommutativeGroupTask cgt, boolean comToTask) {
        String src = String.valueOf(cgt.getCommutativeTasks().get(0).getId());
        String dst = String.valueOf(dest.getId());
        String dep = String.valueOf(dataId) + "v" + String.valueOf(dataVersion);
        String comId = cgt.getCommutativeIdentifier().toString();
        if (comToTask) {
            this.gm.addEdgeToGraphFromGroup(src, dst, dep, comId, "clusterCommutative", EdgeType.DATA_DEPENDENCY);
        } else {
            this.gm.addEdgeToGraphFromGroup(dst, src, dep, comId, "clusterCommutative", EdgeType.DATA_DEPENDENCY);
        }
    }

    private void addNewBarrier() {
        int oldSync = this.synchronizationId++;
        String oldSyncStr = "Synchro" + oldSync;
        String newSyncStr = "Synchro" + this.synchronizationId;
        this.gm.addBarrierToGraph(this.synchronizationId);
        this.gm.addEdgeToGraph(oldSyncStr, newSyncStr, EdgeType.USER_DEPENDENCY, "");
        this.taskDetectedAfterSync = false;
        HashSet<AbstractTask> uniqueWriters = new HashSet<AbstractTask>();
        for (DataAccessesInfo dai : this.accessesInfo.values()) {
            if (dai == null) continue;
            List<AbstractTask> dataWriters = dai.getDataWriters();
            uniqueWriters.addAll(dataWriters);
        }
        for (AbstractTask writer : uniqueWriters) {
            if (writer == null || writer.getSynchronizationId() != oldSync) continue;
            String taskId = String.valueOf(writer.getId());
            this.gm.addEdgeToGraph(taskId, newSyncStr, EdgeType.USER_DEPENDENCY, "");
        }
    }

    private void addNewGroupBarrierToGraph(Application app, String groupName) {
        int oldSync = this.synchronizationId++;
        String oldSyncStr = "Synchro" + oldSync;
        String newSyncStr = "Synchro" + this.synchronizationId;
        this.gm.addBarrierToGraph(this.synchronizationId);
        this.gm.addEdgeToGraph(oldSyncStr, newSyncStr, EdgeType.USER_DEPENDENCY, "");
        this.taskDetectedAfterSync = false;
        String src = String.valueOf(app.drawnBarrier(groupName));
        this.gm.addEdgeToGraphFromGroup(src, newSyncStr, "", groupName, "clusterTasks", EdgeType.USER_DEPENDENCY);
    }
}

