/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.scheduler.types.allocatableactions;

import es.bsc.compss.components.impl.ResourceScheduler;
import es.bsc.compss.components.impl.TaskScheduler;
import es.bsc.compss.scheduler.exceptions.BlockedActionException;
import es.bsc.compss.scheduler.exceptions.FailedActionException;
import es.bsc.compss.scheduler.exceptions.UnassignedActionException;
import es.bsc.compss.scheduler.types.AllocatableAction;
import es.bsc.compss.scheduler.types.SchedulingInformation;
import es.bsc.compss.scheduler.types.Score;
import es.bsc.compss.types.annotations.parameter.OnFailure;
import es.bsc.compss.types.implementations.AbstractMethodImplementation;
import es.bsc.compss.types.implementations.Implementation;
import es.bsc.compss.types.implementations.ServiceImplementation;
import es.bsc.compss.types.resources.DynamicMethodWorker;
import es.bsc.compss.types.resources.MethodResourceDescription;
import es.bsc.compss.types.resources.Worker;
import es.bsc.compss.types.resources.WorkerResourceDescription;
import es.bsc.compss.types.resources.updates.PendingReduction;
import es.bsc.compss.types.resources.updates.ResourceUpdate;
import es.bsc.compss.util.ErrorManager;
import es.bsc.compss.util.ResourceManager;
import es.bsc.compss.worker.COMPSsException;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public class ReduceWorkerAction<T extends WorkerResourceDescription>
extends AllocatableAction {
    private final ResourceScheduler<T> worker;
    private final Implementation impl;
    private final PendingReduction<T> ru;

    public ReduceWorkerAction(SchedulingInformation schedulingInformation, ResourceScheduler<T> worker, TaskScheduler ts, ResourceUpdate<T> modification) {
        super(schedulingInformation, ts.getOrchestrator());
        this.worker = worker;
        this.ru = (PendingReduction)modification;
        this.impl = modification.getModification() instanceof MethodResourceDescription ? AbstractMethodImplementation.generateDummy((MethodResourceDescription)modification.getModification()) : ServiceImplementation.generateDummy();
    }

    @Override
    public boolean isToReserveResources() {
        return true;
    }

    @Override
    public boolean isToReleaseResources() {
        return false;
    }

    @Override
    public boolean isToStopResource() {
        return false;
    }

    @Override
    protected void doAction() {
        new Thread(){

            @Override
            public void run() {
                Thread.currentThread().setName(ReduceWorkerAction.this.worker.getName() + " stopper");
                DynamicMethodWorker w = (DynamicMethodWorker)ReduceWorkerAction.this.worker.getResource();
                PendingReduction red = ReduceWorkerAction.this.ru;
                ResourceManager.reduceDynamicWorker(w, red);
                w.endTask((MethodResourceDescription)ReduceWorkerAction.this.getResourceConsumption());
                try {
                    ReduceWorkerAction.this.ru.waitForCompletion();
                }
                catch (Exception e) {
                    LOGGER.error("ERROR: Exception raised on worker reduction", (Throwable)e);
                    ErrorManager.warn("Exception reducing worker. Check runtime.log for more details", e);
                    ReduceWorkerAction.this.notifyError();
                }
                ReduceWorkerAction.this.notifyCompleted();
            }
        }.start();
    }

    @Override
    protected void doAbort() {
    }

    @Override
    protected void doCompleted() {
        Worker<T> w = this.worker.getResource();
        ResourceManager.confirmWorkerReduction(w, this.ru);
    }

    @Override
    protected void doError() throws FailedActionException {
        throw new FailedActionException();
    }

    @Override
    protected void doFailed() {
        LOGGER.error("Error waiting for tasks to end");
    }

    @Override
    protected void doCanceled() {
    }

    @Override
    protected void doFailIgnored() {
    }

    @Override
    protected void doException(COMPSsException e) {
    }

    @Override
    public Integer getCoreId() {
        return null;
    }

    public LinkedList<ResourceScheduler<? extends WorkerResourceDescription>> getCompatibleWorkers() {
        LinkedList<ResourceScheduler<? extends WorkerResourceDescription>> workers = new LinkedList<ResourceScheduler<? extends WorkerResourceDescription>>();
        workers.add(this.worker);
        return workers;
    }

    @Override
    public Implementation[] getImplementations() {
        Implementation[] impls = new Implementation[]{this.impl};
        return impls;
    }

    public <R extends WorkerResourceDescription> boolean isCompatible(Worker<R> r) {
        return r == this.worker.getResource();
    }

    public <R extends WorkerResourceDescription> LinkedList<Implementation> getCompatibleImplementations(ResourceScheduler<R> r) {
        LinkedList<Implementation> impls = new LinkedList<Implementation>();
        if (r == this.worker) {
            impls.add(this.impl);
        }
        return impls;
    }

    public <R extends WorkerResourceDescription> Score schedulingScore(ResourceScheduler<R> targetWorker, Score actionScore) {
        return null;
    }

    @Override
    public void schedule(Score actionScore) throws BlockedActionException, UnassignedActionException {
        this.schedule((ResourceScheduler<R>)this.worker, this.impl);
    }

    public <R extends WorkerResourceDescription> void schedule(ResourceScheduler<R> targetWorker, Score actionScore) throws BlockedActionException, UnassignedActionException {
        this.schedule(targetWorker, this.impl);
    }

    public <R extends WorkerResourceDescription> void schedule(ResourceScheduler<R> targetWorker, Implementation impl) throws BlockedActionException, UnassignedActionException {
        if (targetWorker != this.getEnforcedTargetResource()) {
            throw new UnassignedActionException();
        }
        this.assignResource(targetWorker);
        this.assignImplementation(impl);
        targetWorker.scheduleAction(this);
    }

    @Override
    public String toString() {
        return "ReduceWorkerAction (Worker " + this.worker.getName() + ")";
    }

    @Override
    public int getPriority() {
        return Integer.MAX_VALUE;
    }

    @Override
    public long getGroupPriority() {
        return -1L;
    }

    @Override
    public OnFailure getOnFailure() {
        return OnFailure.RETRY;
    }

    @Override
    public boolean taskIsReadyForExecution() {
        return true;
    }

    @Override
    protected void treatDependencyFreeAction(List<AllocatableAction> freeTasks) {
    }

    @Override
    public boolean checkIfCanceled(AllocatableAction aa) {
        return false;
    }

    @Override
    protected void stopAction() throws Exception {
    }

    public List<ResourceScheduler<?>> tryToSchedule(Score actionScore, Set<ResourceScheduler<? extends WorkerResourceDescription>> availableResources) throws BlockedActionException, UnassignedActionException {
        this.schedule(actionScore);
        LinkedList uselessWorkers = new LinkedList();
        if (!this.worker.canRunSomething()) {
            uselessWorkers.add(this.worker);
        }
        return uselessWorkers;
    }
}

