/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.types.accesses;

import es.bsc.compss.components.monitor.impl.GraphGenerator;
import es.bsc.compss.components.monitor.impl.GraphHandler;
import es.bsc.compss.types.AbstractTask;
import es.bsc.compss.types.Task;
import es.bsc.compss.types.accesses.StandardDataAccessesInfo;
import es.bsc.compss.types.accesses.StreamDataAccessesInfo;
import es.bsc.compss.types.annotations.parameter.DataType;
import es.bsc.compss.types.parameter.DependencyParameter;
import es.bsc.compss.types.request.ap.RegisterDataAccessRequest;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class DataAccessesInfo {
    protected static final Logger LOGGER = LogManager.getLogger("es.bsc.compss.Components.TaskProcessor.TaskAnalyser");
    protected static final boolean DEBUG = LOGGER.isDebugEnabled();
    protected static final boolean IS_DRAW_GRAPH = GraphGenerator.isEnabled();
    private final DataType dataType;

    public static DataAccessesInfo createAccessInfo(DataType type) {
        DataAccessesInfo ai;
        switch (type) {
            case STREAM_T: 
            case EXTERNAL_STREAM_T: {
                ai = new StreamDataAccessesInfo(type);
                break;
            }
            default: {
                ai = new StandardDataAccessesInfo(type);
            }
        }
        return ai;
    }

    protected DataAccessesInfo(DataType type) {
        this.dataType = type;
    }

    public DataType getDataType() {
        return this.dataType;
    }

    public abstract void completedProducer(AbstractTask var1);

    public abstract AbstractTask getConstrainingProducer();

    public abstract void readValue(Task var1, DependencyParameter var2, boolean var3, GraphHandler var4);

    public abstract void writeValue(AbstractTask var1, DependencyParameter var2, boolean var3, GraphHandler var4);

    public abstract void mainAccess(RegisterDataAccessRequest var1, GraphHandler var2, int var3, int var4);

    public abstract boolean isFinalProducer(Task var1);

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("WI [ ");
        sb.append("dataType = ").append((Object)this.dataType).append(", ");
        sb.append(this.toStringDetails());
        sb.append("]");
        return sb.toString();
    }

    protected abstract String toStringDetails();

    public abstract List<AbstractTask> getDataWriters();
}

