/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.types.request.ap;

import es.bsc.compss.components.impl.AccessProcessor;
import es.bsc.compss.components.impl.DataInfoProvider;
import es.bsc.compss.components.impl.TaskAnalyser;
import es.bsc.compss.components.impl.TaskDispatcher;
import es.bsc.compss.types.Application;
import es.bsc.compss.types.Barrier;
import es.bsc.compss.types.request.ap.APRequest;
import es.bsc.compss.types.request.ap.APRequestType;
import es.bsc.compss.worker.COMPSsException;
import java.util.concurrent.Semaphore;

public class EndOfAppRequest
extends APRequest
implements Barrier {
    private final Application app;
    private final Semaphore sem;
    private boolean released;

    public EndOfAppRequest(Application app) {
        this.app = app;
        this.sem = new Semaphore(0);
        this.released = false;
    }

    public Application getApp() {
        return this.app;
    }

    public Semaphore getSemaphore() {
        return this.sem;
    }

    @Override
    public void process(AccessProcessor ap, TaskAnalyser ta, DataInfoProvider dip, TaskDispatcher td) {
        LOGGER.info("TA Processes no More tasks for app " + this.app.getId());
        ta.noMoreTasks(this);
        this.sem.release();
        LOGGER.info("TA Processed no More tasks for app " + this.app.getId());
    }

    @Override
    public APRequestType getRequestType() {
        return APRequestType.END_OF_APP;
    }

    @Override
    public void setException(COMPSsException exception) {
    }

    @Override
    public COMPSsException getException() {
        return null;
    }

    @Override
    public void release() {
        LOGGER.info("No More tasks for app " + this.app.getId() + " released");
        this.released = true;
        this.sem.release();
    }

    public void waitForCompletion() {
        this.sem.acquireUninterruptibly();
        boolean stalled = false;
        if (!this.released) {
            LOGGER.info("No More tasks for app " + this.app.getId() + " becomes stalled");
            this.app.stalled();
            stalled = true;
        }
        this.sem.acquireUninterruptibly();
        if (stalled) {
            this.app.readyToContinue(this.sem);
            this.sem.acquireUninterruptibly();
        }
    }
}

