/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.types.request.td;

import es.bsc.compss.components.impl.AccessProcessor;
import es.bsc.compss.components.impl.ResourceScheduler;
import es.bsc.compss.components.impl.TaskScheduler;
import es.bsc.compss.scheduler.types.SchedulingInformation;
import es.bsc.compss.types.AbstractTask;
import es.bsc.compss.types.CoreElement;
import es.bsc.compss.types.ReduceTask;
import es.bsc.compss.types.Task;
import es.bsc.compss.types.TaskState;
import es.bsc.compss.types.allocatableactions.ExecutionAction;
import es.bsc.compss.types.allocatableactions.MultiNodeExecutionAction;
import es.bsc.compss.types.allocatableactions.MultiNodeGroup;
import es.bsc.compss.types.allocatableactions.ReduceExecutionAction;
import es.bsc.compss.types.request.exceptions.ShutdownException;
import es.bsc.compss.types.request.td.TDRequest;
import es.bsc.compss.types.request.td.TDRequestType;
import es.bsc.compss.types.resources.WorkerResourceDescription;
import es.bsc.compss.util.ErrorManager;
import es.bsc.compss.util.ResourceManager;
import java.util.Collection;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ExecuteTasksRequest
extends TDRequest {
    private static final Logger TIMER_LOGGER = LogManager.getLogger("es.bsc.compss.Timers");
    private static final boolean IS_TIMER_COMPSS_ENABLED;
    private final AccessProcessor ap;
    private final Task task;

    public ExecuteTasksRequest(AccessProcessor ap, Task t) {
        this.ap = ap;
        this.task = t;
    }

    public AbstractTask getTask() {
        return this.task;
    }

    @Override
    public void process(TaskScheduler ts) throws ShutdownException {
        if (IS_TIMER_COMPSS_ENABLED) {
            long startTime = System.nanoTime();
            this.processTask(ts);
            long endTime = System.nanoTime();
            float elapsedTime = (float)(endTime - startTime) / 1000000.0f;
            TIMER_LOGGER.info("[TIMER] TD Schedule of task " + this.task.getId() + ": " + elapsedTime + " ms");
        } else {
            this.processTask(ts);
        }
    }

    private void processTask(TaskScheduler ts) throws ShutdownException {
        int coreId = this.task.getTaskDescription().getCoreElement().getCoreId();
        if (DEBUG) {
            LOGGER.debug("Treating Scheduling request for task " + this.task.getId() + "(core " + coreId + ")");
        }
        this.task.setStatus(TaskState.TO_EXECUTE);
        int numNodes = this.task.getTaskDescription().getNumNodes();
        boolean isReplicated = this.task.getTaskDescription().isReplicated();
        boolean isDistributed = this.task.getTaskDescription().isDistributed();
        if (isReplicated) {
            if (DEBUG) {
                LOGGER.debug("Replicating task " + this.task.getId());
            }
            Collection<ResourceScheduler<? extends WorkerResourceDescription>> resources = ts.getWorkers();
            this.task.setExecutionCount(resources.size() * numNodes);
            for (ResourceScheduler<? extends WorkerResourceDescription> rs : resources) {
                this.submitTask(ts, numNodes, rs);
            }
        } else if (isDistributed) {
            if (DEBUG) {
                LOGGER.debug("Distributing task " + this.task.getId());
            }
            ResourceScheduler<? extends WorkerResourceDescription> selectedResource = ts.getNextResourForDistributed(this.task.getTaskDescription().getCoreElement().getCoreId());
            this.task.setExecutionCount(numNodes);
            this.submitTask(ts, numNodes, selectedResource);
        } else {
            if (DEBUG) {
                LOGGER.debug("Submitting task " + this.task.getId());
            }
            this.task.setExecutionCount(numNodes);
            this.submitTask(ts, numNodes, null);
        }
        if (DEBUG) {
            LOGGER.debug("Treated Scheduling request for task " + this.task.getId() + " (core " + coreId + ")");
        }
    }

    private <T extends WorkerResourceDescription> void submitTask(TaskScheduler ts, int numNodes, ResourceScheduler<T> specificResource) {
        if (numNodes == 1) {
            this.submitSingleTask(ts, specificResource);
        } else {
            this.submitMultiNodeTask(ts, numNodes, specificResource);
        }
    }

    private <T extends WorkerResourceDescription> void submitSingleTask(TaskScheduler ts, ResourceScheduler<T> specificResource) {
        if (this.task.isReduction()) {
            LOGGER.debug("Scheduling request for reduce task " + this.task.getId() + " treated as singleTask");
            ReduceExecutionAction action = new ReduceExecutionAction(new SchedulingInformation(), ts.getOrchestrator(), this.ap, (ReduceTask)this.task, ts);
            ts.newAllocatableAction(action);
        } else {
            LOGGER.debug("Scheduling request for task " + this.task.getId() + " treated as singleTask");
            ExecutionAction action = new ExecutionAction(ts.generateSchedulingInformation(specificResource, this.task.getFreeParams(), this.task.getTaskDescription().getCoreElement().getCoreId()), ts.getOrchestrator(), this.ap, this.task);
            ts.newAllocatableAction(action);
        }
    }

    private <T extends WorkerResourceDescription> void submitMultiNodeTask(TaskScheduler ts, int numNodes, ResourceScheduler<T> specificResource) {
        boolean toBlocked = false;
        LOGGER.debug("Scheduling request for task " + this.task.getId() + " treated as multiNodeTask with " + numNodes + " nodes");
        if (this.exceedsMaxResources(numNodes, this.task.getTaskDescription().getCoreElement())) {
            ErrorManager.warn("Task " + this.task.getId() + " can't be executed because exceeds the maximum number of available cores. Adding actions to blocked.");
            toBlocked = true;
        }
        MultiNodeGroup group = new MultiNodeGroup(numNodes);
        for (int i = 0; i < numNodes; ++i) {
            MultiNodeExecutionAction action = new MultiNodeExecutionAction(ts.generateSchedulingInformation(specificResource, this.task.getTaskDescription().getParameters(), this.task.getTaskDescription().getCoreElement().getCoreId()), ts.getOrchestrator(), this.ap, this.task, group);
            group.addAction(action);
            if (toBlocked) {
                ts.addToBlocked(action);
                continue;
            }
            ts.newAllocatableAction(action);
        }
    }

    private boolean exceedsMaxResources(int numNodes, CoreElement coreElement) {
        return numNodes > ResourceManager.getTotalSlots()[coreElement.getCoreId()];
    }

    @Override
    public TDRequestType getType() {
        return TDRequestType.EXECUTE_TASKS;
    }

    static {
        String isTimerCOMPSsEnabledProperty = System.getProperty("compss.timers");
        IS_TIMER_COMPSS_ENABLED = isTimerCOMPSsEnabledProperty == null || isTimerCOMPSsEnabledProperty.isEmpty() || isTimerCOMPSsEnabledProperty.equals("null") ? false : Boolean.valueOf(isTimerCOMPSsEnabledProperty);
    }
}

